/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.oauth2;

import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.AuthenticationToken;
import io.vrap.rmf.base.client.AutoCloseableService;
import io.vrap.rmf.base.client.ResponseSerializer;
import io.vrap.rmf.base.client.VrapHttpClient;
import io.vrap.rmf.base.client.http.InternalLogger;
import io.vrap.rmf.base.client.oauth2.AuthException;
import io.vrap.rmf.base.client.oauth2.TokenSupplier;
import io.vrap.rmf.base.client.utils.Utils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public abstract class BaseAuthTokenSupplier
extends AutoCloseableService
implements TokenSupplier {
    protected final VrapHttpClient vrapHttpClient;
    protected final ApiHttpRequest apiHttpRequest;
    protected final InternalLogger logger = InternalLogger.getLogger("commercetools.auth");
    protected final ResponseSerializer serializer;

    public BaseAuthTokenSupplier(VrapHttpClient vrapHttpClient, ApiHttpRequest apiHttpRequest) {
        this(vrapHttpClient, apiHttpRequest, ResponseSerializer.of());
    }

    public BaseAuthTokenSupplier(VrapHttpClient vrapHttpClient, ApiHttpRequest apiHttpRequest, ResponseSerializer serializer) {
        this.vrapHttpClient = vrapHttpClient;
        this.apiHttpRequest = apiHttpRequest;
        this.serializer = serializer;
    }

    @Override
    public CompletableFuture<AuthenticationToken> getToken() {
        return ((CompletableFuture)((CompletableFuture)this.vrapHttpClient.execute(this.apiHttpRequest).whenComplete((response, throwable) -> {
            this.logger.info(() -> String.format("%s %s %s", this.apiHttpRequest.getMethod().name(), this.apiHttpRequest.getUri(), response.getStatusCode()));
            if (throwable != null) {
                this.logger.error(() -> response, (Throwable)throwable);
            } else {
                this.logger.debug(() -> response);
            }
        })).thenApply(apiHttpResponse -> {
            if (apiHttpResponse.getStatusCode() < 200 || apiHttpResponse.getStatusCode() > 299) {
                if (apiHttpResponse.getStatusCode() == 405) {
                    throw new CompletionException(new AuthException(apiHttpResponse.getStatusCode(), new String((byte[])apiHttpResponse.getBody()), this.apiHttpRequest.getHeaders(), apiHttpResponse.getMessage() + " : auth token URI may be incorrect e.g. https://auth.europe-west1.gcp.commercetools.com/oauth/token", (ApiHttpResponse<byte[]>)apiHttpResponse));
                }
                throw new CompletionException(new AuthException(apiHttpResponse.getStatusCode(), new String((byte[])apiHttpResponse.getBody()), this.apiHttpRequest.getHeaders(), apiHttpResponse.getMessage(), (ApiHttpResponse<byte[]>)apiHttpResponse));
            }
            return apiHttpResponse;
        })).thenApply(Utils.wrapToCompletionException(response -> this.serializer.convertResponse((ApiHttpResponse<byte[]>)response, AuthenticationToken.class).getBody()));
    }

    static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    protected void internalClose() {
        if (this.vrapHttpClient instanceof AutoCloseable) {
            BaseAuthTokenSupplier.closeQuietly((AutoCloseable)((Object)this.vrapHttpClient));
        }
    }
}

