/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.error;

import io.vrap.rmf.base.client.ApiHttpException;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.ResponseSerializer;
import io.vrap.rmf.base.client.error.ApiClientException;
import io.vrap.rmf.base.client.error.ApiServerException;
import io.vrap.rmf.base.client.error.BadGatewayException;
import io.vrap.rmf.base.client.error.BadRequestException;
import io.vrap.rmf.base.client.error.ConcurrentModificationException;
import io.vrap.rmf.base.client.error.DefaultHttpExceptionFactory;
import io.vrap.rmf.base.client.error.ForbiddenException;
import io.vrap.rmf.base.client.error.GatewayTimeoutException;
import io.vrap.rmf.base.client.error.InternalServerErrorException;
import io.vrap.rmf.base.client.error.NotFoundException;
import io.vrap.rmf.base.client.error.ServiceUnavailableException;
import io.vrap.rmf.base.client.error.UnauthorizedException;
import java.util.Optional;

public interface HttpExceptionFactory {
    public ResponseSerializer getResponseSerializer();

    default public ApiHttpException create(ApiHttpRequest request, ApiHttpResponse<byte[]> response) {
        if (response.getStatusCode() >= 500) {
            return this.createServerException(request, response);
        }
        return this.createClientException(request, response);
    }

    default public ApiHttpException createServerException(ApiHttpRequest request, ApiHttpResponse<byte[]> response) {
        ResponseSerializer serializer = this.getResponseSerializer();
        String message = "Server error response [url] " + request.getUri().toString() + " [status code] " + response.getStatusCode() + " [reason phrase] " + response.getMessage();
        String body = Optional.ofNullable(response.getBody()).map(String::new).orElse("");
        switch (response.getStatusCode()) {
            case 500: {
                return new InternalServerErrorException(response.getStatusCode(), body, request.getHeaders(), message, response, request, serializer);
            }
            case 502: {
                return new BadGatewayException(response.getStatusCode(), body, request.getHeaders(), message, response, request, serializer);
            }
            case 503: {
                return new ServiceUnavailableException(response.getStatusCode(), body, request.getHeaders(), message, response, request, serializer);
            }
            case 504: {
                return new GatewayTimeoutException(response.getStatusCode(), body, request.getHeaders(), message, response, request, serializer);
            }
        }
        return new ApiServerException(response.getStatusCode(), body, response.getHeaders(), message, response, request);
    }

    default public ApiHttpException createClientException(ApiHttpRequest request, ApiHttpResponse<byte[]> response) {
        ResponseSerializer serializer = this.getResponseSerializer();
        String message = "Client error response [url] " + request.getUri().toString() + " [status code] " + response.getStatusCode() + " [reason phrase] " + response.getMessage();
        String body = Optional.ofNullable(response.getBody()).map(String::new).orElse("");
        switch (response.getStatusCode()) {
            case 400: {
                return new BadRequestException(response.getStatusCode(), body, request.getHeaders(), message, response, request, serializer);
            }
            case 401: {
                return new UnauthorizedException(response.getStatusCode(), body, request.getHeaders(), message, response, request, serializer);
            }
            case 403: {
                return new ForbiddenException(response.getStatusCode(), body, request.getHeaders(), message, response, request, serializer);
            }
            case 404: {
                return new NotFoundException(response.getStatusCode(), body, request.getHeaders(), message, response, request, serializer);
            }
            case 409: {
                return new ConcurrentModificationException(response.getStatusCode(), body, request.getHeaders(), message, response, request, serializer);
            }
        }
        return new ApiClientException(response.getStatusCode(), body, response.getHeaders(), message, response, request);
    }

    public static HttpExceptionFactory of(ResponseSerializer serializer) {
        return new DefaultHttpExceptionFactory(serializer);
    }
}

