/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.http;

import dev.failsafe.Bulkhead;
import dev.failsafe.BulkheadBuilder;
import dev.failsafe.Policy;
import dev.failsafe.Timeout;
import dev.failsafe.TimeoutBuilder;
import dev.failsafe.spi.Scheduler;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.http.FailsafeConcurrencyBuilderOptions;
import io.vrap.rmf.base.client.http.FailsafeTimeoutBuilderOptions;
import io.vrap.rmf.base.client.http.PolicyMiddleware;
import io.vrap.rmf.base.client.http.RetryPolicyBuilder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;

public class PolicyBuilder {
    private final List<Policy<ApiHttpResponse<byte[]>>> policies;
    private final Scheduler scheduler;

    public PolicyBuilder() {
        this.policies = new ArrayList<Policy<ApiHttpResponse<byte[]>>>();
        this.scheduler = Scheduler.DEFAULT;
    }

    List<Policy<ApiHttpResponse<byte[]>>> getPolicies() {
        return this.policies;
    }

    public PolicyBuilder(List<Policy<ApiHttpResponse<byte[]>>> policies) {
        this.policies = policies;
        this.scheduler = Scheduler.DEFAULT;
    }

    public PolicyBuilder(Scheduler scheduler, List<Policy<ApiHttpResponse<byte[]>>> policies) {
        this.policies = policies;
        this.scheduler = scheduler;
    }

    public PolicyBuilder withScheduler(ScheduledExecutorService scheduler) {
        return new PolicyBuilder(Scheduler.of((ScheduledExecutorService)scheduler), this.policies);
    }

    public PolicyBuilder withScheduler(ExecutorService scheduler) {
        return new PolicyBuilder(Scheduler.of((ExecutorService)scheduler), this.policies);
    }

    public PolicyBuilder withScheduler(Scheduler scheduler) {
        return new PolicyBuilder(scheduler, this.policies);
    }

    public PolicyBuilder withRetry(RetryPolicyBuilder retryPolicyBuilder) {
        return this.withPolicy((Policy<ApiHttpResponse<byte[]>>)retryPolicyBuilder.build());
    }

    public PolicyBuilder withRetry(Function<RetryPolicyBuilder, RetryPolicyBuilder> fn) {
        return this.withPolicy((Policy<ApiHttpResponse<byte[]>>)fn.apply(RetryPolicyBuilder.of()).build());
    }

    public PolicyBuilder withRetry(int maxRetries) {
        return this.withRetry((RetryPolicyBuilder retry) -> retry.maxRetries(maxRetries));
    }

    public PolicyBuilder withRetry(int maxRetries, List<Integer> statusCodes) {
        return this.withRetry((RetryPolicyBuilder retry) -> retry.maxRetries(maxRetries).statusCodes(statusCodes));
    }

    public PolicyBuilder withRetry(int maxRetries, List<Integer> statusCodes, List<Class<? extends Throwable>> failures) {
        return this.withRetry((RetryPolicyBuilder retry) -> retry.maxRetries(maxRetries).statusCodes(statusCodes).failures(failures));
    }

    public PolicyBuilder withBulkhead(int maxConcurrency) {
        return this.withPolicy((Policy<ApiHttpResponse<byte[]>>)PolicyBuilder.bulkhead(maxConcurrency));
    }

    public PolicyBuilder withBulkhead(int maxConcurrency, Duration maxWaitTime) {
        return this.withPolicy((Policy<ApiHttpResponse<byte[]>>)PolicyBuilder.bulkhead(maxConcurrency, maxWaitTime));
    }

    public PolicyBuilder withBulkhead(int maxConcurrency, FailsafeConcurrencyBuilderOptions fn) {
        return this.withPolicy((Policy<ApiHttpResponse<byte[]>>)PolicyBuilder.bulkhead(maxConcurrency, fn));
    }

    public PolicyBuilder withBulkhead(int maxConcurrency, Duration maxWaitTime, FailsafeConcurrencyBuilderOptions fn) {
        return this.withPolicy((Policy<ApiHttpResponse<byte[]>>)PolicyBuilder.bulkhead(maxConcurrency, maxWaitTime, fn));
    }

    public PolicyBuilder withTimeout(Duration duration) {
        return this.withPolicy((Policy<ApiHttpResponse<byte[]>>)PolicyBuilder.timeout(duration));
    }

    public PolicyBuilder withTimeout(Duration duration, FailsafeTimeoutBuilderOptions fn) {
        return this.withPolicy((Policy<ApiHttpResponse<byte[]>>)PolicyBuilder.timeout(duration, fn));
    }

    public PolicyBuilder withPolicy(Policy<ApiHttpResponse<byte[]>> policy) {
        ArrayList<Policy<ApiHttpResponse<byte[]>>> copy = new ArrayList<Policy<ApiHttpResponse<byte[]>>>(this.policies);
        copy.add(policy);
        return new PolicyBuilder(copy);
    }

    public PolicyMiddleware build() {
        return PolicyMiddleware.of(this.scheduler, this.policies);
    }

    public static PolicyBuilder of() {
        return new PolicyBuilder();
    }

    public static Timeout<ApiHttpResponse<byte[]>> timeout(Duration duration) {
        return PolicyBuilder.timeout(duration, options -> options);
    }

    public static Timeout<ApiHttpResponse<byte[]>> timeout(Duration duration, FailsafeTimeoutBuilderOptions fn) {
        return fn.apply((TimeoutBuilder<ApiHttpResponse<byte[]>>)Timeout.builder((Duration)duration)).build();
    }

    public static Bulkhead<ApiHttpResponse<byte[]>> bulkhead(int maxConcurrency) {
        return PolicyBuilder.bulkhead(maxConcurrency, (BulkheadBuilder<ApiHttpResponse<byte[]>> options) -> options);
    }

    public static Bulkhead<ApiHttpResponse<byte[]>> bulkhead(int maxConcurrency, Duration maxWaitTime) {
        return PolicyBuilder.bulkhead(maxConcurrency, maxWaitTime, options -> options);
    }

    public static Bulkhead<ApiHttpResponse<byte[]>> bulkhead(int maxConcurrency, FailsafeConcurrencyBuilderOptions fn) {
        return fn.apply((BulkheadBuilder<ApiHttpResponse<byte[]>>)Bulkhead.builder((int)maxConcurrency)).build();
    }

    public static Bulkhead<ApiHttpResponse<byte[]>> bulkhead(int maxConcurrency, Duration maxWaitTime, FailsafeConcurrencyBuilderOptions fn) {
        return fn.apply((BulkheadBuilder<ApiHttpResponse<byte[]>>)Bulkhead.builder((int)maxConcurrency).withMaxWaitTime(maxWaitTime)).build();
    }
}

