/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.http;

import dev.failsafe.Policy;
import dev.failsafe.spi.Scheduler;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.http.PolicyBuilder;
import io.vrap.rmf.base.client.http.PolicyMiddleware;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class RequestPolicyBuilder {
    private final Map<Predicate<ApiHttpRequest>, List<Policy<ApiHttpResponse<byte[]>>>> policies;
    private final Scheduler scheduler;

    public RequestPolicyBuilder() {
        this.policies = new LinkedHashMap<Predicate<ApiHttpRequest>, List<Policy<ApiHttpResponse<byte[]>>>>();
        this.scheduler = Scheduler.DEFAULT;
    }

    public RequestPolicyBuilder(Map<Predicate<ApiHttpRequest>, List<Policy<ApiHttpResponse<byte[]>>>> policies) {
        this.policies = policies;
        this.scheduler = Scheduler.DEFAULT;
    }

    public RequestPolicyBuilder(Scheduler scheduler, Map<Predicate<ApiHttpRequest>, List<Policy<ApiHttpResponse<byte[]>>>> policies) {
        this.policies = policies;
        this.scheduler = scheduler;
    }

    public RequestPolicyBuilder withScheduler(ScheduledExecutorService scheduler) {
        return new RequestPolicyBuilder(Scheduler.of((ScheduledExecutorService)scheduler), this.policies);
    }

    public RequestPolicyBuilder withScheduler(ExecutorService scheduler) {
        return new RequestPolicyBuilder(Scheduler.of((ExecutorService)scheduler), this.policies);
    }

    public RequestPolicyBuilder withScheduler(Scheduler scheduler) {
        return new RequestPolicyBuilder(scheduler, this.policies);
    }

    public RequestPolicyBuilder withRequestMatching(Predicate<ApiHttpRequest> predicate, Function<PolicyBuilder, PolicyBuilder> fn) {
        LinkedHashMap<Predicate<ApiHttpRequest>, List<Policy<ApiHttpResponse<byte[]>>>> policiesCopy = new LinkedHashMap<Predicate<ApiHttpRequest>, List<Policy<ApiHttpResponse<byte[]>>>>(this.policies);
        policiesCopy.put(predicate, fn.apply(PolicyBuilder.of()).getPolicies());
        return new RequestPolicyBuilder(this.scheduler, policiesCopy);
    }

    public RequestPolicyBuilder withAllOtherRequests(Function<PolicyBuilder, PolicyBuilder> fn) {
        LinkedHashMap<Predicate<ApiHttpRequest>, List<Policy<ApiHttpResponse<byte[]>>>> policiesCopy = new LinkedHashMap<Predicate<ApiHttpRequest>, List<Policy<ApiHttpResponse<byte[]>>>>(this.policies);
        policiesCopy.put(apiHttpRequest -> true, fn.apply(PolicyBuilder.of()).getPolicies());
        return new RequestPolicyBuilder(this.scheduler, policiesCopy);
    }

    public PolicyMiddleware build() {
        return PolicyMiddleware.of(new ArrayList<Map.Entry<Predicate<ApiHttpRequest>, List<Policy<ApiHttpResponse<byte[]>>>>>(this.policies.entrySet()), this.scheduler);
    }

    public static RequestPolicyBuilder of() {
        return new RequestPolicyBuilder();
    }
}

