/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.http;

import dev.failsafe.Failsafe;
import dev.failsafe.FailsafeExecutor;
import dev.failsafe.Policy;
import dev.failsafe.spi.Scheduler;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.http.PolicyMiddleware;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RequestPolicyMiddlewareImpl
implements AutoCloseable,
PolicyMiddleware {
    private final List<Map.Entry<Predicate<ApiHttpRequest>, FailsafeExecutor<ApiHttpResponse<byte[]>>>> executors;

    RequestPolicyMiddlewareImpl(Scheduler scheduler, List<Map.Entry<Predicate<ApiHttpRequest>, List<Policy<ApiHttpResponse<byte[]>>>>> policies) {
        this.executors = policies.stream().map(entry -> Map.entry((Predicate)entry.getKey(), Failsafe.with((List)((List)entry.getValue())).with(scheduler))).collect(Collectors.toList());
    }

    @Override
    public CompletableFuture<ApiHttpResponse<byte[]>> invoke(ApiHttpRequest request, Function<ApiHttpRequest, CompletableFuture<ApiHttpResponse<byte[]>>> next) {
        Optional<FailsafeExecutor> failsafeExecutor = this.executors.stream().filter(entry -> ((Predicate)entry.getKey()).test(request)).findFirst().map(Map.Entry::getValue);
        if (failsafeExecutor.isPresent()) {
            return failsafeExecutor.get().getStageAsync(() -> (CompletionStage)next.apply(request));
        }
        return next.apply(request);
    }

    @Override
    public void close() {
    }
}

