/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.utils.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.vrap.rmf.base.client.utils.json.JsonException;
import io.vrap.rmf.base.client.utils.json.ModuleSupplier;
import io.vrap.rmf.base.client.utils.json.modules.ModuleOptions;
import io.vrap.rmf.base.client.utils.json.modules.SubTypeModule;
import io.vrap.rmf.base.client.utils.json.modules.ZonedDateTimeDeserializationModule;
import io.vrap.rmf.base.client.utils.json.modules.ZonedDateTimeSerializationModule;
import io.vrap.rmf.base.client.utils.json.modules.deserializers.LocalDateDeserializationModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public class JsonUtils {
    public static ObjectMapper createObjectMapper() {
        return JsonUtils.createObjectMapper(name -> null);
    }

    public static ObjectMapper createObjectMapper(ModuleOptions options) {
        ServiceLoader<SimpleModule> loader = ServiceLoader.load(SimpleModule.class, SimpleModule.class.getClassLoader());
        ServiceLoader<ModuleSupplier> suppliers = ServiceLoader.load(ModuleSupplier.class, ModuleSupplier.class.getClassLoader());
        ArrayList moduleList = new ArrayList();
        suppliers.iterator().forEachRemaining(moduleSupplier -> moduleList.add(moduleSupplier.getModule(options)));
        return ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new JavaTimeModule())).addModule((Module)new ZonedDateTimeSerializationModule())).addModule((Module)new ZonedDateTimeDeserializationModule())).addModule((Module)new LocalDateDeserializationModule())).addModule((Module)new SubTypeModule("com.commercetools"))).addModules(loader)).addModules(moduleList)).serializationInclusion(JsonInclude.Include.NON_NULL)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).configure(DeserializationFeature.USE_LONG_FOR_INTS, true)).configure(MapperFeature.REQUIRE_TYPE_ID_FOR_SUBTYPES, false)).build();
    }

    public static byte[] toJsonByteArray(Object value) throws JsonProcessingException {
        return JsonUtils.getConfiguredObjectMapper().writeValueAsBytes(value);
    }

    public static String toJsonString(Object value) throws JsonProcessingException {
        return JsonUtils.getConfiguredObjectMapper().writeValueAsString(value);
    }

    public static <T> T fromJsonString(String content, Class<T> clazz) {
        return (T)JsonUtils.executing(() -> JsonUtils.getConfiguredObjectMapper().readValue(content, clazz));
    }

    public static <T> T fromJsonString(String jsonAsString, TypeReference<T> typeReference) {
        return (T)JsonUtils.executing(() -> JsonUtils.getConfiguredObjectMapper().readValue(jsonAsString, typeReference));
    }

    public static <T> T fromJsonNode(JsonNode jsonNode, TypeReference<T> typeReference) {
        return (T)JsonUtils.executing(() -> JsonUtils.getConfiguredObjectMapper().readerFor(typeReference).readValue(jsonNode));
    }

    public static JsonNode toJsonNode(Object value) {
        return JsonUtils.getConfiguredObjectMapper().valueToTree(value);
    }

    public static JsonNode parse(String jsonAsString) {
        return JsonUtils.executing(() -> JsonUtils.getConfiguredObjectMapper().readTree(jsonAsString));
    }

    public static <T> T fromJsonByteArray(byte[] content, Class<T> clazz) {
        return (T)JsonUtils.executing(() -> JsonUtils.getConfiguredObjectMapper().readValue(content, clazz));
    }

    public static <T> T fromInputStream(InputStream content, Class<T> clazz) {
        return (T)JsonUtils.executing(() -> JsonUtils.getConfiguredObjectMapper().readValue(content, clazz));
    }

    public static <T> T fromInputStream(InputStream content, TypeReference<T> typeReference) {
        return (T)JsonUtils.executing(() -> JsonUtils.getConfiguredObjectMapper().readValue(content, typeReference));
    }

    public static <T> T readObjectFromResource(String resourcePath, TypeReference<T> typeReference) {
        return (T)JsonUtils.executing(() -> {
            InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);
            return JsonUtils.getConfiguredObjectMapper().readValue((Reader)new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8.name()), typeReference);
        });
    }

    public static <T> T readObjectFromResource(String resourcePath, JavaType javaType) {
        return (T)JsonUtils.executing(() -> {
            InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);
            return JsonUtils.getConfiguredObjectMapper().readValue((Reader)new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8.name()), javaType);
        });
    }

    public static <T> T readObjectFromResource(String resourcePath, Class<T> clazz) {
        return (T)JsonUtils.executing(() -> {
            InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);
            return JsonUtils.getConfiguredObjectMapper().readValue((Reader)new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8.name()), clazz);
        });
    }

    public static ObjectMapper getConfiguredObjectMapper() {
        return ObjectMapperHolder.OBJECT_MAPPER;
    }

    private static JsonNode secure(JsonNode node) {
        if (node.isObject()) {
            ObjectNode objectNode = (ObjectNode)node;
            Iterator fields = node.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                if (((JsonNode)field.getValue()).isTextual() && (((String)field.getKey()).toLowerCase().contains("pass") || ((String)field.getKey()).toLowerCase().contains("access_token") || ((String)field.getKey()).toLowerCase().contains("refresh_token"))) {
                    objectNode.put((String)field.getKey(), "**removed from output**");
                    continue;
                }
                JsonUtils.secure((JsonNode)field.getValue());
            }
            return objectNode;
        }
        if (node.isArray()) {
            ArrayNode arrayNode = (ArrayNode)node;
            Iterator elements = arrayNode.elements();
            while (elements.hasNext()) {
                JsonUtils.secure((JsonNode)elements.next());
            }
            return arrayNode;
        }
        return node;
    }

    public static String prettyPrint(String json) {
        return JsonUtils.executing(() -> {
            ObjectMapper jsonParser = new ObjectMapper();
            JsonNode jsonTree = (JsonNode)jsonParser.readValue(json, JsonNode.class);
            JsonUtils.secure(jsonTree);
            ObjectWriter writer = jsonParser.writerWithDefaultPrettyPrinter();
            return writer.writeValueAsString((Object)jsonTree);
        });
    }

    public static <T> T executing(SupplierThrowingIOException<T> supplier) {
        try {
            return supplier.get();
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    @FunctionalInterface
    public static interface SupplierThrowingIOException<T> {
        public T get() throws IOException;
    }

    private static class ObjectMapperHolder {
        static final ObjectMapper OBJECT_MAPPER = JsonUtils.createObjectMapper();

        private ObjectMapperHolder() {
        }
    }
}

