/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client;

import io.vrap.rmf.base.client.ApiHttpHeaders;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.ResponseSerializer;
import io.vrap.rmf.base.client.SerializationException;
import io.vrap.rmf.base.client.error.BaseException;
import io.vrap.rmf.base.client.utils.json.JsonUtils;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import javax.annotation.Nullable;

public class ApiHttpException
extends BaseException {
    private final int statusCode;
    @Nullable
    private final String body;
    @Nullable
    private final ApiHttpHeaders headers;
    @Nullable
    private final ApiHttpResponse<byte[]> response;
    @Nullable
    private final ApiHttpRequest request;
    private final ResponseSerializer serializer;
    private final String dateAsString = DateTimeFormatter.ISO_INSTANT.format(ZonedDateTime.now().withZoneSameInstant(ZoneOffset.UTC));

    public ApiHttpException(int statusCode, String body, ApiHttpHeaders headers) {
        this(statusCode, body, headers, null, null, null, ResponseSerializer.of());
    }

    public ApiHttpException(int statusCode, String body, ApiHttpHeaders headers, ApiHttpResponse<byte[]> response) {
        this(statusCode, body, headers, null, response, null, ResponseSerializer.of());
    }

    public ApiHttpException(int statusCode, String body, ApiHttpHeaders headers, String message, ApiHttpResponse<byte[]> response) {
        this(statusCode, body, headers, message, response, null, ResponseSerializer.of());
    }

    public ApiHttpException(int statusCode, String body, ApiHttpHeaders headers, String message, ApiHttpResponse<byte[]> response, Throwable cause) {
        this(statusCode, body, headers, message, response, null, ResponseSerializer.of(), cause);
    }

    public ApiHttpException(int statusCode, String body, ApiHttpHeaders headers, String message, ApiHttpResponse<byte[]> response, ResponseSerializer serializer) {
        this(statusCode, body, headers, message, response, null, serializer);
    }

    public ApiHttpException(int statusCode, @Nullable String body, @Nullable ApiHttpHeaders headers, @Nullable String message, @Nullable ApiHttpResponse<byte[]> response, @Nullable ApiHttpRequest request) {
        this(statusCode, body, headers, message, response, request, ResponseSerializer.of());
    }

    public ApiHttpException(int statusCode, @Nullable String body, @Nullable ApiHttpHeaders headers, @Nullable String message, @Nullable ApiHttpResponse<byte[]> response, @Nullable ApiHttpRequest request, ResponseSerializer serializer, Throwable cause) {
        super(message, cause);
        this.statusCode = statusCode;
        this.body = body;
        this.headers = headers;
        this.response = response;
        this.request = request;
        this.serializer = serializer;
    }

    public ApiHttpException(int statusCode, @Nullable String body, @Nullable ApiHttpHeaders headers, @Nullable String message, @Nullable ApiHttpResponse<byte[]> response, @Nullable ApiHttpRequest request, ResponseSerializer serializer) {
        super(message);
        this.statusCode = statusCode;
        this.body = body;
        this.headers = headers;
        this.response = response;
        this.request = request;
        this.serializer = serializer;
    }

    public <T> T getBodyAs(Class<T> clazz) throws SerializationException {
        try {
            return this.serializer.convertResponse(this.response, clazz).getBody();
        }
        catch (Exception e) {
            throw new SerializationException(e.getMessage());
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getBody() {
        return this.body;
    }

    public ApiHttpHeaders getHeaders() {
        return this.headers;
    }

    public ApiHttpResponse<byte[]> getResponse() {
        return this.response;
    }

    public ApiHttpRequest getRequest() {
        return this.request;
    }

    @Override
    public final String getMessage() {
        return Optional.ofNullable(super.getMessage()).map(s -> "detailMessage: " + s + "\n").orElse("") + this.httpSummary() + this.responseBodyFormatted() + "http response: " + Optional.ofNullable(this.getResponse()).map(Object::toString).orElse("<unknown>") + "\nSDK: 19.4.0\n" + Optional.ofNullable(this.request).map(x -> String.valueOf((Object)x.getMethod()) + " " + String.valueOf(x.getUri())).map(x -> "endpoint: " + x + "\n").orElse("") + "Java: " + System.getProperty("java.version") + "\ncwd: " + System.getProperty("user.dir") + "\nrequest: " + Optional.ofNullable(this.request).map(Object::toString).orElse("<unknown>") + "\n" + this.httpRequestLine() + this.requestBodyFormatted();
    }

    private String httpSummary() {
        try {
            StringBuilder builder = new StringBuilder();
            if (this.request != null) {
                builder.append("summary: ");
                String httpMethod = Optional.of(this.request).map(r -> r.getMethod().toString()).orElseGet(() -> this.request.getMethod().toString());
                String path = Optional.of(this.request).map(ApiHttpRequest::getUri).orElseGet(this.request::getUri).toString();
                String responseCode = " with " + Optional.ofNullable(this.response).map(ApiHttpResponse::getStatusCode).map(Object::toString).map(r -> "response code " + r).orElse("an unknown status code");
                String correlationId = Optional.ofNullable(this.response).map(ApiHttpResponse::getHeaders).flatMap(headers -> headers.getHeaders("X-Correlation-ID").stream().findFirst()).map(id -> " with X-Correlation-ID `" + String.valueOf(id) + "`").orElse("");
                builder.append(httpMethod).append(" ").append(path).append(" failed ").append(responseCode).append(correlationId).append(" on ").append(this.dateAsString).append("\n");
            }
            return builder.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    private String httpRequestLine() {
        if (this.request == null) {
            return "";
        }
        return "http request: " + this.request.toString() + "\n";
    }

    private String responseBodyFormatted() {
        try {
            return Optional.ofNullable(this.response).map(ApiHttpResponse::getBody).map(b -> JsonUtils.prettyPrint(new String((byte[])b, StandardCharsets.UTF_8))).map(s -> "http response formatted body: " + s + "\n").orElse("");
        }
        catch (Exception e) {
            return "";
        }
    }

    private String requestBodyFormatted() {
        try {
            Optional<String> stringBodyOfHttpRequest = this.stringBodyOfHttpRequest();
            Optional<String> stringBodyOfHttpRequestIntentSupplier = Optional.ofNullable(this.request).map(ApiHttpRequest::getSecuredBody);
            return Optional.ofNullable(stringBodyOfHttpRequest.orElse(stringBodyOfHttpRequestIntentSupplier.orElse(null))).map(JsonUtils::prettyPrint).map(s -> "http request formatted body: " + s + "\n").orElse("");
        }
        catch (Exception e) {
            return "";
        }
    }

    private Optional<String> stringBodyOfHttpRequest() {
        return Optional.ofNullable(this.request).map(ApiHttpRequest::getSecuredBody);
    }
}

