/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.error;

import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.error.BaseException;
import io.vrap.rmf.base.client.utils.json.JsonUtils;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.concurrent.TimeoutException;

public class RmfTimeoutException
extends BaseException {
    private final ApiHttpRequest request;
    private final String dateAsString = DateTimeFormatter.ISO_INSTANT.format(ZonedDateTime.now().withZoneSameInstant(ZoneOffset.UTC));

    public RmfTimeoutException(TimeoutException cause) {
        super(cause.getMessage(), cause);
        this.request = null;
    }

    public RmfTimeoutException(TimeoutException cause, ApiHttpRequest request) {
        super(cause.getMessage(), cause);
        this.request = request;
    }

    public ApiHttpRequest getRequest() {
        return this.request;
    }

    @Override
    public final String getMessage() {
        return Optional.ofNullable(super.getMessage()).map(s -> "detailMessage: " + s + "\n").orElse("") + this.httpSummary() + Optional.ofNullable(this.request).map(x -> String.valueOf((Object)x.getMethod()) + " " + String.valueOf(x.getUri())).map(x -> "endpoint: " + x + "\n").orElse("") + "Java: " + System.getProperty("java.version") + "\ncwd: " + System.getProperty("user.dir") + "\nrequest: " + Optional.ofNullable(this.request).map(Object::toString).orElse("<unknown>") + "\n" + this.httpRequestLine() + this.requestBodyFormatted();
    }

    private String httpSummary() {
        try {
            StringBuilder builder = new StringBuilder();
            if (this.request != null) {
                builder.append("summary: ");
                String httpMethod = Optional.of(this.request).map(r -> r.getMethod().toString()).orElseGet(() -> this.request.getMethod().toString());
                String path = Optional.of(this.request).map(ApiHttpRequest::getUri).orElseGet(this.request::getUri).toString();
                builder.append(httpMethod).append(" ").append(path).append(" failed ").append(" on ").append(this.dateAsString).append("\n");
            }
            return builder.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    private String httpRequestLine() {
        if (this.request == null) {
            return "";
        }
        return "http request: " + this.request.toString() + "\n";
    }

    private String requestBodyFormatted() {
        try {
            Optional<String> stringBodyOfHttpRequest = this.stringBodyOfHttpRequest();
            Optional<String> stringBodyOfHttpRequestIntentSupplier = Optional.ofNullable(this.request).map(ApiHttpRequest::getSecuredBody);
            return Optional.ofNullable(stringBodyOfHttpRequest.orElse(stringBodyOfHttpRequestIntentSupplier.orElse(null))).map(JsonUtils::prettyPrint).map(s -> "http request formatted body: " + s + "\n").orElse("");
        }
        catch (Exception e) {
            return "";
        }
    }

    private Optional<String> stringBodyOfHttpRequest() {
        return Optional.ofNullable(this.request).map(ApiHttpRequest::getSecuredBody);
    }
}

