/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.http;

import dev.failsafe.Failsafe;
import dev.failsafe.FailsafeExecutor;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import dev.failsafe.event.ExecutionAttemptedEvent;
import dev.failsafe.spi.Scheduler;
import io.vrap.rmf.base.client.ApiHttpException;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.http.FailsafeRetryPolicyBuilderOptions;
import io.vrap.rmf.base.client.http.InternalLogger;
import io.vrap.rmf.base.client.http.RetryRequestMiddleware;
import io.vrap.rmf.base.client.utils.json.JsonException;
import io.vrap.rmf.base.client.utils.json.JsonUtils;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class RetryMiddleware
implements RetryRequestMiddleware,
AutoCloseable {
    static final String loggerName = "commercetools.retry";
    private static final InternalLogger logger = InternalLogger.getLogger("commercetools.retry");
    private static final Logger classLogger = LoggerFactory.getLogger(RetryMiddleware.class);
    private final FailsafeExecutor<ApiHttpResponse<byte[]>> failsafeExecutor;

    RetryMiddleware(int maxRetries, List<Integer> statusCodes, List<Class<? extends Throwable>> failures) {
        this(Scheduler.DEFAULT, maxRetries, 200L, 60000L, statusCodes, failures);
    }

    RetryMiddleware(int maxRetries, long delay, long maxDelay, List<Integer> statusCodes, List<Class<? extends Throwable>> failures) {
        this(Scheduler.DEFAULT, maxRetries, delay, maxDelay, RetryRequestMiddleware.handleFailures(failures).andThen(RetryRequestMiddleware.handleStatusCodes(statusCodes)));
    }

    RetryMiddleware(ExecutorService executorService, int maxRetries, long delay, long maxDelay, List<Integer> statusCodes, List<Class<? extends Throwable>> failures) {
        this(executorService, maxRetries, delay, maxDelay, RetryRequestMiddleware.handleFailures(failures).andThen(RetryRequestMiddleware.handleStatusCodes(statusCodes)));
    }

    RetryMiddleware(ScheduledExecutorService executorService, int maxRetries, long delay, long maxDelay, List<Integer> statusCodes, List<Class<? extends Throwable>> failures) {
        this(executorService, maxRetries, delay, maxDelay, RetryRequestMiddleware.handleFailures(failures).andThen(RetryRequestMiddleware.handleStatusCodes(statusCodes)));
    }

    RetryMiddleware(Scheduler scheduler, int maxRetries, long delay, long maxDelay, List<Integer> statusCodes, List<Class<? extends Throwable>> failures) {
        this(scheduler, maxRetries, delay, maxDelay, RetryRequestMiddleware.handleFailures(failures).andThen(RetryRequestMiddleware.handleStatusCodes(statusCodes)));
    }

    RetryMiddleware(int maxRetries, long delay, long maxDelay, FailsafeRetryPolicyBuilderOptions fn) {
        this(Scheduler.DEFAULT, maxRetries, delay, maxDelay, fn);
    }

    RetryMiddleware(ExecutorService executorService, int maxRetries, long delay, long maxDelay, FailsafeRetryPolicyBuilderOptions fn) {
        this(Scheduler.of((ExecutorService)executorService), maxRetries, delay, maxDelay, fn);
    }

    RetryMiddleware(ScheduledExecutorService executorService, int maxRetries, long delay, long maxDelay, FailsafeRetryPolicyBuilderOptions fn) {
        this(Scheduler.of((ScheduledExecutorService)executorService), maxRetries, delay, maxDelay, fn);
    }

    RetryMiddleware(Scheduler scheduler, int maxRetries, long delay, long maxDelay, FailsafeRetryPolicyBuilderOptions fn) {
        RetryPolicy retryPolicy = fn.apply((RetryPolicyBuilder<ApiHttpResponse<byte[]>>)RetryPolicy.builder().withBackoff(delay, maxDelay, ChronoUnit.MILLIS).withJitter(0.25).withMaxRetries(maxRetries).onRetry(this::logEventFailure)).build();
        this.failsafeExecutor = Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]).with(scheduler);
    }

    private void logEventFailure(ExecutionAttemptedEvent<ApiHttpResponse<byte[]>> event) {
        int attempt = event.getAttemptCount();
        logger.info(() -> "Retry #" + attempt);
        logger.trace(() -> {
            Throwable failure = event.getLastException();
            if (failure instanceof ApiHttpException) {
                ApiHttpException httpException = (ApiHttpException)failure;
                ApiHttpRequest request = httpException.getRequest();
                ApiHttpResponse<byte[]> response = httpException.getResponse();
                if (request != null) {
                    return this.requestLog(attempt, request, response);
                }
            }
            return event.toString();
        });
    }

    private String requestLog(int attempt, ApiHttpRequest request, ApiHttpResponse<?> response) {
        String output;
        String httpMethodAndUrl = request.getMethod().name() + " " + request.getUrl().toString();
        if (request.getBody() != null) {
            String unformattedBody = request.getSecuredBody();
            boolean isJsonRequest = request.getHeaders().getHeaders("Content-Type").stream().findFirst().map(ct -> ((String)ct.getValue()).toLowerCase().contains("json")).orElse(true);
            if (isJsonRequest) {
                String prettyPrint;
                try {
                    prettyPrint = JsonUtils.prettyPrint(unformattedBody);
                }
                catch (JsonException e) {
                    classLogger.warn("pretty print failed", (Throwable)e);
                    prettyPrint = unformattedBody;
                }
                output = "Retry #" + attempt + ": " + String.valueOf(request) + "\n" + httpMethodAndUrl + "\nformatted: " + prettyPrint;
            } else {
                output = "Retry #" + attempt + ": " + String.valueOf(request) + "\n" + request.getMethod().name() + " " + String.valueOf(request.getUrl()) + " " + unformattedBody;
            }
        } else {
            output = "Retry #" + attempt + ": " + String.valueOf(request) + "\n" + httpMethodAndUrl + " <no body>";
        }
        if (response != null) {
            output = output + "\nFailure response: " + response.getStatusCode() + "\n" + String.valueOf(response) + "\n" + Optional.ofNullable(response.getBody()).map(body -> JsonUtils.prettyPrint(response.getBodyAsString().orElse(""))).orElse("<no body>");
        }
        return output;
    }

    @Override
    public CompletableFuture<ApiHttpResponse<byte[]>> invoke(ApiHttpRequest request, Function<ApiHttpRequest, CompletableFuture<ApiHttpResponse<byte[]>>> next) {
        return this.failsafeExecutor.getStageAsync(() -> (CompletionStage)next.apply(request));
    }

    @Override
    public void close() {
    }
}

