/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.http;

import dev.failsafe.Bulkhead;
import dev.failsafe.BulkheadBuilder;
import dev.failsafe.RetryPolicy;
import dev.failsafe.Timeout;
import dev.failsafe.TimeoutBuilder;
import dev.failsafe.event.ExecutionAttemptedEvent;
import io.vrap.rmf.base.client.ApiHttpException;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.http.FailsafeConcurrencyBuilderOptions;
import io.vrap.rmf.base.client.http.FailsafeRetryPolicyBuilderOptions;
import io.vrap.rmf.base.client.http.FailsafeTimeoutBuilderOptions;
import io.vrap.rmf.base.client.http.InternalLogger;
import io.vrap.rmf.base.client.http.PolicyMiddleware;
import io.vrap.rmf.base.client.utils.json.JsonException;
import io.vrap.rmf.base.client.utils.json.JsonUtils;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryPolicyBuilder {
    static final String loggerName = "commercetools.retry";
    int DEFAULT_MAX_DELAY = 60000;
    int DEFAULT_INITIAL_DELAY = 200;
    int DEFAULT_RETRIES = 3;
    List<Integer> DEFAULT_RETRY_STATUS_CODES = Arrays.asList(500, 503);
    private static final InternalLogger logger = InternalLogger.getLogger("commercetools.retry");
    private static final Logger classLogger = LoggerFactory.getLogger(PolicyMiddleware.class);
    private final int maxRetries;
    private final long initialDelay;
    private final long maxDelay;
    private final List<Integer> statusCodes;
    private final List<Class<? extends Throwable>> failures;
    private final FailsafeRetryPolicyBuilderOptions fn;

    public RetryPolicyBuilder() {
        this.maxRetries = this.DEFAULT_RETRIES;
        this.initialDelay = this.DEFAULT_INITIAL_DELAY;
        this.maxDelay = this.DEFAULT_MAX_DELAY;
        this.statusCodes = this.DEFAULT_RETRY_STATUS_CODES;
        this.failures = null;
        this.fn = options -> options;
    }

    public RetryPolicyBuilder(int maxRetries, long initialDelay, long maxDelay, List<Integer> statusCodes, List<Class<? extends Throwable>> failures, FailsafeRetryPolicyBuilderOptions fn) {
        this.maxRetries = maxRetries;
        this.initialDelay = initialDelay;
        this.maxDelay = maxDelay;
        this.statusCodes = statusCodes;
        this.failures = failures;
        this.fn = fn;
    }

    public RetryPolicyBuilder maxRetries(int maxRetries) {
        return new RetryPolicyBuilder(maxRetries, this.initialDelay, this.maxDelay, this.statusCodes, this.failures, this.fn);
    }

    public RetryPolicyBuilder initialDelay(long initialDelay) {
        return new RetryPolicyBuilder(this.maxRetries, initialDelay, this.maxDelay, this.statusCodes, this.failures, this.fn);
    }

    public RetryPolicyBuilder maxDelay(long maxDelay) {
        return new RetryPolicyBuilder(this.maxRetries, this.initialDelay, maxDelay, this.statusCodes, this.failures, this.fn);
    }

    public RetryPolicyBuilder statusCodes(List<Integer> statusCodes) {
        return new RetryPolicyBuilder(this.maxRetries, this.initialDelay, this.maxDelay, statusCodes, this.failures, this.fn);
    }

    public RetryPolicyBuilder failures(List<Class<? extends Throwable>> failures) {
        return new RetryPolicyBuilder(this.maxRetries, this.initialDelay, this.maxDelay, this.statusCodes, failures, this.fn);
    }

    public RetryPolicyBuilder options(FailsafeRetryPolicyBuilderOptions options) {
        return new RetryPolicyBuilder(this.maxRetries, this.initialDelay, this.maxDelay, this.statusCodes, this.failures, options);
    }

    public RetryPolicy<ApiHttpResponse<byte[]>> build() {
        return RetryPolicyBuilder.retry(this.maxRetries, this.initialDelay, this.maxDelay, RetryPolicyBuilder.handleStatusCodes(this.statusCodes).andThen(RetryPolicyBuilder.handleFailures(this.failures).andThen(this.fn)));
    }

    public static RetryPolicyBuilder of() {
        return new RetryPolicyBuilder();
    }

    public static RetryPolicy<ApiHttpResponse<byte[]>> retry(int maxRetries, long delay, long maxDelay, FailsafeRetryPolicyBuilderOptions fn) {
        return fn.apply((dev.failsafe.RetryPolicyBuilder<ApiHttpResponse<byte[]>>)RetryPolicy.builder().withBackoff(delay, maxDelay, ChronoUnit.MILLIS).withJitter(0.25).withMaxRetries(maxRetries).onRetry(RetryPolicyBuilder::logEventFailure)).build();
    }

    public static Timeout<ApiHttpResponse<byte[]>> timeout(Duration duration) {
        return RetryPolicyBuilder.timeout(duration, options -> options);
    }

    public static Timeout<ApiHttpResponse<byte[]>> timeout(Duration duration, FailsafeTimeoutBuilderOptions fn) {
        return fn.apply((TimeoutBuilder<ApiHttpResponse<byte[]>>)Timeout.builder((Duration)duration)).build();
    }

    public static Bulkhead<ApiHttpResponse<byte[]>> bulkhead(int maxConcurrency) {
        return RetryPolicyBuilder.bulkhead(maxConcurrency, (BulkheadBuilder<ApiHttpResponse<byte[]>> options) -> options);
    }

    public static Bulkhead<ApiHttpResponse<byte[]>> bulkhead(int maxConcurrency, Duration maxWaitTime) {
        return RetryPolicyBuilder.bulkhead(maxConcurrency, maxWaitTime, options -> options);
    }

    public static Bulkhead<ApiHttpResponse<byte[]>> bulkhead(int maxConcurrency, FailsafeConcurrencyBuilderOptions fn) {
        return fn.apply((BulkheadBuilder<ApiHttpResponse<byte[]>>)Bulkhead.builder((int)maxConcurrency)).build();
    }

    public static Bulkhead<ApiHttpResponse<byte[]>> bulkhead(int maxConcurrency, Duration maxWaitTime, FailsafeConcurrencyBuilderOptions fn) {
        return fn.apply((BulkheadBuilder<ApiHttpResponse<byte[]>>)Bulkhead.builder((int)maxConcurrency).withMaxWaitTime(maxWaitTime)).build();
    }

    public static FailsafeRetryPolicyBuilderOptions handleFailures(List<Class<? extends Throwable>> failures) {
        return builder -> {
            if (failures != null) {
                builder.handle(failures);
            }
            return builder;
        };
    }

    public static FailsafeRetryPolicyBuilderOptions handleStatusCodes(List<Integer> statusCodes) {
        return builder -> (dev.failsafe.RetryPolicyBuilder)builder.handleIf((response, throwable) -> {
            if (throwable instanceof ApiHttpException) {
                return statusCodes.contains(((ApiHttpException)throwable).getStatusCode());
            }
            return statusCodes.contains(response.getStatusCode());
        });
    }

    private static void logEventFailure(ExecutionAttemptedEvent<ApiHttpResponse<byte[]>> event) {
        int attempt = event.getAttemptCount();
        logger.info(() -> "Retry #" + attempt);
        logger.trace(() -> {
            Throwable failure = event.getLastException();
            if (failure instanceof ApiHttpException) {
                ApiHttpException httpException = (ApiHttpException)failure;
                ApiHttpRequest request = httpException.getRequest();
                ApiHttpResponse<byte[]> response = httpException.getResponse();
                if (request != null) {
                    return RetryPolicyBuilder.requestLog(attempt, request, response);
                }
            }
            return event.toString();
        });
    }

    private static String requestLog(int attempt, ApiHttpRequest request, ApiHttpResponse<?> response) {
        String output;
        String httpMethodAndUrl = request.getMethod().name() + " " + request.getUrl().toString();
        if (request.getBody() != null) {
            String unformattedBody = request.getSecuredBody();
            boolean isJsonRequest = request.getHeaders().getHeaders("Content-Type").stream().findFirst().map(ct -> ((String)ct.getValue()).toLowerCase().contains("json")).orElse(true);
            if (isJsonRequest) {
                String prettyPrint;
                try {
                    prettyPrint = JsonUtils.prettyPrint(unformattedBody);
                }
                catch (JsonException e) {
                    classLogger.warn("pretty print failed", (Throwable)e);
                    prettyPrint = unformattedBody;
                }
                output = "Retry #" + attempt + ": " + String.valueOf(request) + "\n" + httpMethodAndUrl + "\nformatted: " + prettyPrint;
            } else {
                output = "Retry #" + attempt + ": " + String.valueOf(request) + "\n" + request.getMethod().name() + " " + String.valueOf(request.getUrl()) + " " + unformattedBody;
            }
        } else {
            output = "Retry #" + attempt + ": " + String.valueOf(request) + "\n" + httpMethodAndUrl + " <no body>";
        }
        if (response != null) {
            output = output + "\nFailure response: " + response.getStatusCode() + "\n" + String.valueOf(response) + "\n" + Optional.ofNullable(response.getBody()).map(body -> JsonUtils.prettyPrint(response.getBodyAsString().orElse(""))).orElse("<no body>");
        }
        return output;
    }
}

