/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.utils;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class CompletableFutureUtils {
    private CompletableFutureUtils() {
    }

    public static <T> CompletableFuture<T> successful(T object) {
        return CompletableFuture.completedFuture(object);
    }

    static <T> Throwable blockForFailure(CompletionStage<T> future) {
        try {
            future.toCompletableFuture().join();
            throw new NoSuchElementException(String.valueOf(future) + " did not complete exceptionally.");
        }
        catch (CompletionException e1) {
            return e1.getCause();
        }
    }

    public static <T> CompletableFuture<T> exceptionallyCompletedFuture(Throwable e) {
        return CompletableFutureUtils.failed(e);
    }

    public static <T> CompletableFuture<T> failed(Throwable e) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(e);
        return future;
    }

    public static <T> void transferResult(CompletionStage<T> source, CompletableFuture<T> target) {
        source.whenCompleteAsync((result, throwable) -> {
            boolean isSuccessful;
            boolean bl = isSuccessful = throwable == null;
            if (isSuccessful) {
                target.complete(result);
            } else {
                target.completeExceptionally((Throwable)throwable);
            }
        });
    }

    public static <T> CompletionStage<T> onFailure(CompletionStage<T> future, Consumer<? super Throwable> consumer) {
        return future.whenCompleteAsync((value, throwable) -> {
            if (throwable != null) {
                consumer.accept((Throwable)throwable);
            }
        });
    }

    public static <T> CompletionStage<T> onSuccess(CompletionStage<T> future, Consumer<? super T> consumer) {
        return future.whenCompleteAsync((value, throwable) -> {
            if (throwable == null) {
                consumer.accept(value);
            }
        });
    }

    public static <T> CompletionStage<T> recover(CompletionStage<T> future, Function<Throwable, ? extends T> f) {
        return future.exceptionally(f);
    }

    public static <T> CompletableFuture<T> recoverWith(CompletionStage<T> future, Function<? super Throwable, CompletionStage<T>> f) {
        return CompletableFutureUtils.recoverWith(future, f, ForkJoinPool.commonPool());
    }

    public static <T> CompletableFuture<T> recoverWith(CompletionStage<T> future, Function<? super Throwable, CompletionStage<T>> f, Executor executor) {
        CompletableFuture result = new CompletableFuture();
        BiConsumer<Object, Throwable> action = (value, error) -> {
            if (value != null) {
                result.complete(value);
            } else {
                CompletionStage alternative = (CompletionStage)f.apply((Throwable)error);
                alternative.whenCompleteAsync((alternativeValue, alternativeError) -> {
                    if (alternativeValue != null) {
                        result.complete(alternativeValue);
                    } else {
                        result.completeExceptionally((Throwable)alternativeError);
                    }
                }, executor);
            }
        };
        future.whenCompleteAsync(action, executor);
        return result;
    }

    public static <T, X extends Throwable> T orElseThrow(CompletionStage<T> stage, Supplier<? extends X> exceptionSupplier) throws X {
        CompletableFuture<T> future = stage.toCompletableFuture();
        if (future.isDone()) {
            return future.join();
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public static <T> T orElseGet(CompletionStage<T> stage, Supplier<T> other) {
        CompletableFuture<T> future = stage.toCompletableFuture();
        return future.isDone() ? future.join() : other.get();
    }

    public static <T, U> CompletionStage<U> map(CompletionStage<T> future, Function<? super T, ? extends U> f) {
        return future.thenApplyAsync(f);
    }

    public static <T, U> CompletionStage<U> flatMap(CompletionStage<T> future, Function<? super T, CompletionStage<U>> f) {
        return future.thenComposeAsync(f);
    }

    public static <T> CompletableFuture<List<T>> listOfFuturesToFutureOfList(List<? extends CompletionStage<T>> list) {
        List<CompletableFuture> futureList = list.stream().map(CompletionStage::toCompletableFuture).collect(Collectors.toList());
        CompletableFuture[] futuresAsArray = futureList.toArray(new CompletableFuture[futureList.size()]);
        return CompletableFuture.allOf(futuresAsArray).thenApplyAsync(x -> futureList.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    public static <T> CompletableFuture<List<T>> sequence(List<? extends CompletionStage<T>> list) {
        return CompletableFutureUtils.listOfFuturesToFutureOfList(list);
    }
}

