/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client;

import io.vrap.rmf.base.client.Base;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ApiHttpHeaders
extends Base {
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String AUTHORIZATION = "Authorization";
    public static final String USER_AGENT = "User-Agent";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String X_CORRELATION_ID = "X-Correlation-ID";
    private final List<StringHeaderEntry> headers;

    public static StringHeaderEntry headerEntry(String key) {
        return new StringHeaderEntry(key);
    }

    public static StringHeaderEntry headerEntry(String key, String value) {
        return new StringHeaderEntry(key, value);
    }

    public ApiHttpHeaders() {
        this.headers = new ArrayList<StringHeaderEntry>();
    }

    public ApiHttpHeaders(StringHeaderEntry ... headers) {
        this.headers = new ArrayList<StringHeaderEntry>(Arrays.asList(headers));
    }

    public ApiHttpHeaders(List<Map.Entry<String, String>> headers) {
        this.headers = ApiHttpHeaders.mapToHeaderEntries(headers);
    }

    public ApiHttpHeaders(ApiHttpHeaders t) {
        this.headers = new ArrayList<StringHeaderEntry>(t.headers);
    }

    public ApiHttpHeaders addHeader(String key, String value) {
        ApiHttpHeaders headers = this.copy();
        headers.headers.add(ApiHttpHeaders.headerEntry(key, value));
        return headers;
    }

    public ApiHttpHeaders withHeader(String key, String value) {
        ApiHttpHeaders headers = this.withoutHeader(key);
        headers.headers.add(ApiHttpHeaders.headerEntry(key, value));
        return headers;
    }

    public final ApiHttpHeaders withHeaders(StringHeaderEntry ... headers) {
        return new ApiHttpHeaders(new ArrayList<Map.Entry<String, String>>(Arrays.asList(headers)));
    }

    public ApiHttpHeaders withHeaders(List<Map.Entry<String, String>> headers) {
        return new ApiHttpHeaders(headers);
    }

    public ApiHttpHeaders withoutHeader(String key) {
        return this.withHeaders(this.headers.stream().filter(e -> !((String)e.getKey()).equalsIgnoreCase(key)).collect(Collectors.toList()));
    }

    @Nullable
    public String getFirst(String key) {
        return this.headers.stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(key)).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    public List<String> getHeaderValue(String key) {
        return this.headers.stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(key)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public List<Map.Entry<String, String>> getHeaders(String key) {
        return this.headers.stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(key)).collect(Collectors.toList());
    }

    public List<Map.Entry<String, String>> getHeaders() {
        return new ArrayList<Map.Entry<String, String>>(this.headers);
    }

    @Override
    public String toString() {
        return this.headers.toString();
    }

    private ApiHttpHeaders copy() {
        return new ApiHttpHeaders(this);
    }

    private static List<StringHeaderEntry> mapToHeaderEntries(List<Map.Entry<String, String>> entries) {
        return entries.stream().map(ApiHttpHeaders::mapToHeaderEntry).collect(Collectors.toList());
    }

    private static StringHeaderEntry mapToHeaderEntry(Map.Entry<String, String> entry) {
        if (entry instanceof StringHeaderEntry) {
            return (StringHeaderEntry)entry;
        }
        return ApiHttpHeaders.headerEntry(entry.getKey(), entry.getValue());
    }

    public static class HeaderEntry<K, V>
    extends Base
    implements Map.Entry<K, V> {
        protected final K key;
        protected V value;

        public HeaderEntry(K key) {
            this.key = key;
        }

        public HeaderEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public String toString() {
            if (this.key.toString().equalsIgnoreCase(ApiHttpHeaders.AUTHORIZATION)) {
                return "{key=" + this.key + ", value=**removed from output**}";
            }
            return "{key=" + this.key + ", value=" + this.value + '}';
        }
    }

    public static class StringHeaderEntry
    extends HeaderEntry<String, String> {
        public StringHeaderEntry(String key) {
            super(key);
        }

        public StringHeaderEntry(String key, String value) {
            super(key, value);
        }
    }
}

