/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client;

import io.vrap.rmf.base.client.ApiHttpHeaders;
import io.vrap.rmf.base.client.ApiHttpMethod;
import io.vrap.rmf.base.client.Base;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ApiHttpRequest
extends Base {
    private ApiHttpMethod method;
    private URI uri;
    private ApiHttpHeaders headers;
    private byte[] body;

    public ApiHttpRequest() {
    }

    public ApiHttpRequest(ApiHttpMethod method, URI uri, ApiHttpHeaders headers, byte[] body) {
        this.method = method;
        this.uri = uri;
        this.headers = headers;
        this.body = body;
    }

    public ApiHttpRequest(ApiHttpRequest r) {
        this.method = r.method;
        this.uri = r.uri;
        this.headers = r.headers;
        this.body = r.body;
    }

    public ApiHttpMethod getMethod() {
        return this.method;
    }

    public ApiHttpRequest withMethod(ApiHttpMethod method) {
        ApiHttpRequest request = this.copy();
        request.method = method;
        return request;
    }

    public ApiHttpHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = new ApiHttpHeaders();
        }
        return this.headers;
    }

    public ApiHttpRequest addHeader(String key, String value) {
        ApiHttpRequest request = this.copy();
        request.headers = this.getHeaders().addHeader(key, value);
        return request;
    }

    public ApiHttpRequest withHeaders(ApiHttpHeaders headers) {
        ApiHttpRequest request = this.copy();
        request.headers = headers;
        return request;
    }

    public ApiHttpRequest withHeader(String key, String value) {
        ApiHttpRequest request = this.copy();
        request.headers = this.getHeaders().withHeader(key, value);
        return request;
    }

    public ApiHttpRequest withoutHeader(String key) {
        ApiHttpRequest request = this.copy();
        request.headers = this.getHeaders().withoutHeader(key);
        return request;
    }

    public byte[] getBody() {
        return this.body;
    }

    public ApiHttpRequest withBody(byte[] body) {
        ApiHttpRequest request = this.copy();
        request.body = body;
        return request;
    }

    public ApiHttpRequest withBody(String body) {
        ApiHttpRequest request = this.copy();
        request.body = (byte[])(body == null ? null : body.getBytes(StandardCharsets.UTF_8));
        return request;
    }

    public URI getUri() {
        return this.uri;
    }

    public URL getUrl() {
        try {
            return this.uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Malformed URI", e);
        }
    }

    public ApiHttpRequest withUri(String uri) {
        ApiHttpRequest request = this.copy();
        request.uri = URI.create(uri);
        return request;
    }

    public ApiHttpRequest withUri(URI uri) {
        ApiHttpRequest request = this.copy();
        request.uri = uri;
        return request;
    }

    public ApiHttpRequest resolve(URI baseUri) {
        return this.withUri(baseUri.resolve(this.uri));
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("method", (Object)this.method).append("uri", (Object)("\"" + this.uri + "\"")).append("headers", (Object)this.headers).append("textInterpretedBody", (Object)this.getSecuredBody()).toString();
    }

    public String getSecuredBody() {
        return Optional.ofNullable(this.body).map(b -> ApiHttpRequest.tryToFilter(new String((byte[])b, StandardCharsets.UTF_8))).orElse("empty body");
    }

    static String tryToFilter(String input) {
        return input.replaceAll("(\"\\w*([Pp]ass|access_token|refresh_token)\\w*\"):\"[^\"]*\"", "$1:\"**removed from output**\"");
    }

    private ApiHttpRequest copy() {
        return new ApiHttpRequest(this);
    }
}

