/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client;

import io.vrap.rmf.base.client.ApiHttpHeaders;
import io.vrap.rmf.base.client.Base;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ApiHttpResponse<U>
extends Base {
    private int statusCode;
    private ApiHttpHeaders headers;
    private U body;
    private String message;

    public ApiHttpResponse(int statusCode, ApiHttpHeaders headers, U body) {
        this(statusCode, headers, body, null);
    }

    public ApiHttpResponse(int statusCode, ApiHttpHeaders headers, U body, String message) {
        this.statusCode = statusCode;
        this.headers = headers;
        this.body = body;
        this.message = message;
    }

    public ApiHttpResponse(ApiHttpResponse<U> response) {
        this.statusCode = response.statusCode;
        this.headers = response.headers;
        this.body = response.body;
        this.message = response.message;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public ApiHttpResponse<U> withStatusCode(int statusCode) {
        ApiHttpResponse<U> response = this.copy();
        response.statusCode = statusCode;
        return response;
    }

    public ApiHttpHeaders getHeaders() {
        return this.headers;
    }

    public ApiHttpResponse<U> withHeaders(ApiHttpHeaders headers) {
        ApiHttpResponse<U> response = this.copy();
        response.headers = headers;
        return response;
    }

    public U getBody() {
        return this.body;
    }

    public ApiHttpResponse<U> withBody(U body) {
        ApiHttpResponse<U> response = this.copy();
        response.body = body;
        return response;
    }

    public String getMessage() {
        return this.message;
    }

    public ApiHttpResponse<U> withMessage(String message) {
        ApiHttpResponse<U> response = this.copy();
        response.message = message;
        return response;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("statusCode", this.statusCode).append("headers", (Object)this.headers).append("textInterpretedBody", (Object)this.getSecuredBody()).toString();
    }

    static String tryToFilter(String input) {
        return input.replaceAll("(\"\\w*([Pp]ass|access_token|refresh_token)\\w*\"):\"[^\"]*\"", "$1:\"**removed from output**\"");
    }

    public Optional<String> getBodyAsString() {
        if (this.body instanceof byte[]) {
            return Optional.of(this.body).map(b -> ApiHttpResponse.tryToFilter(new String((byte[])b, StandardCharsets.UTF_8)));
        }
        return Optional.ofNullable(this.body.toString());
    }

    public String getSecuredBody() {
        return this.getBodyAsString().orElse("empty body");
    }

    private ApiHttpResponse<U> copy() {
        return new ApiHttpResponse<U>(this);
    }
}

