/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client;

import io.vrap.rmf.base.client.ApiHttpClient;
import io.vrap.rmf.base.client.ApiHttpHeaders;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.RequestCommand;
import io.vrap.rmf.base.client.utils.ClientUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public abstract class ApiMethod<T extends ApiMethod<T, TResult>, TResult>
implements RequestCommand<TResult> {
    private ApiHttpHeaders headers = new ApiHttpHeaders();
    private List<ParamEntry<String, String>> queryParams = new ArrayList<ParamEntry<String, String>>();
    private final ApiHttpClient apiHttpClient;

    protected ApiHttpClient apiHttpClient() {
        return this.apiHttpClient;
    }

    public ApiMethod(ApiHttpClient apiHttpClient) {
        this.apiHttpClient = apiHttpClient;
    }

    public ApiMethod(ApiMethod<T, TResult> apiMethod) {
        this.apiHttpClient = apiMethod.apiHttpClient;
        this.headers = new ApiHttpHeaders(apiMethod.headers);
        this.queryParams = new ArrayList<ParamEntry<String, String>>(apiMethod.queryParams);
    }

    public T addHeader(String key, String value) {
        T c = this.copy();
        ((ApiMethod)c).headers = ((ApiMethod)c).headers.addHeader(key, value);
        return c;
    }

    public T withoutHeader(String key) {
        T c = this.copy();
        ((ApiMethod)c).headers = ((ApiMethod)c).headers.withoutHeader(key);
        return c;
    }

    public T withHeader(String key, String value) {
        T c = this.copy();
        ((ApiMethod)c).headers = ((ApiMethod)c).headers.withHeader(key, value);
        return c;
    }

    public T withHeaders(ApiHttpHeaders headers) {
        T c = this.copy();
        ((ApiMethod)c).headers = ((ApiMethod)c).headers = headers;
        return c;
    }

    public ApiHttpHeaders getHeaders() {
        return this.headers;
    }

    public <V> T addQueryParam(String key, V value) {
        T c = this.copy();
        ((ApiMethod)c).queryParams.add(new ParamEntry<String, String>(key, value.toString()));
        return c;
    }

    public <V> T withQueryParam(String key, V value) {
        return ((ApiMethod)this.withoutQueryParam(key)).addQueryParam(key, value);
    }

    public T withoutQueryParam(String key) {
        T c = this.copy();
        ((ApiMethod)c).queryParams = ((ApiMethod)c).queryParams.stream().filter(e -> !((String)e.getKey()).equalsIgnoreCase(key)).collect(Collectors.toList());
        return c;
    }

    public T withQueryParams(List<ParamEntry<String, String>> queryParams) {
        T c = this.copy();
        ((ApiMethod)c).queryParams = queryParams;
        return c;
    }

    public List<ParamEntry<String, String>> getQueryParams() {
        return new ArrayList<ParamEntry<String, String>>(this.queryParams);
    }

    public List<String> getQueryParam(String key) {
        return this.queryParams.stream().filter(e -> ((String)e.key).equals(key)).map(e -> (String)e.value).collect(Collectors.toList());
    }

    public List<String> getQueryParamUriStrings() {
        return this.queryParams.stream().map(ParamEntry::toUriString).collect(Collectors.toList());
    }

    @Nullable
    public String getFirstQueryParam(String key) {
        return this.queryParams.stream().filter(e -> ((String)e.getKey()).equals(key)).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    protected abstract T copy();

    public abstract ApiHttpRequest createHttpRequest();

    @Override
    public abstract CompletableFuture<ApiHttpResponse<TResult>> execute();

    @Override
    public ApiHttpResponse<TResult> executeBlocking() {
        return this.executeBlocking(Duration.ofSeconds(120L));
    }

    @Override
    public abstract ApiHttpResponse<TResult> executeBlocking(Duration var1);

    public CompletableFuture<ApiHttpResponse<byte[]>> send() {
        return this.apiHttpClient.execute(this.createHttpRequest());
    }

    public ApiHttpResponse<byte[]> sendBlocking() {
        return this.sendBlocking(Duration.ofSeconds(120L));
    }

    public ApiHttpResponse<byte[]> sendBlocking(Duration timeout) {
        return ClientUtils.blockingWait(this.send(), timeout);
    }

    public static class ParamEntry<K, V>
    implements Map.Entry<K, V> {
        protected final K key;
        protected V value;

        public ParamEntry(K key) {
            this.key = key;
        }

        public ParamEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public String toUriString() {
            try {
                return this.key + "=" + URLEncoder.encode(this.value.toString(), StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return "";
            }
        }
    }
}

