/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client;

import io.vrap.rmf.base.client.ApiHttpClient;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.MiddlewareFactory;
import io.vrap.rmf.base.client.VrapHttpClient;
import io.vrap.rmf.base.client.http.CorrelationIdProvider;
import io.vrap.rmf.base.client.http.HandlerStack;
import io.vrap.rmf.base.client.http.HttpHandler;
import io.vrap.rmf.base.client.http.InternalLogger;
import io.vrap.rmf.base.client.http.InternalLoggerFactory;
import io.vrap.rmf.base.client.http.Middleware;
import io.vrap.rmf.base.client.oauth2.TokenSupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class ClientFactory {
    public static final String COMMERCETOOLS = "commercetools";

    public static ApiHttpClient create(String apiBaseUrl, VrapHttpClient httpClient, TokenSupplier tokenSupplier) {
        return ClientFactory.create(apiBaseUrl, httpClient, tokenSupplier, (ApiHttpRequest request, String topic) -> InternalLogger.getLogger("commercetools." + topic), new ArrayList<Middleware>(), null);
    }

    public static ApiHttpClient create(String apiBaseUrl, VrapHttpClient httpClient, TokenSupplier tokenSupplier, Supplier<String> userAgentSupplier) {
        return ClientFactory.create(apiBaseUrl, httpClient, tokenSupplier, (request, topic) -> InternalLogger.getLogger("commercetools." + topic), userAgentSupplier, new ArrayList<Middleware>(), null);
    }

    public static ApiHttpClient create(String apiBaseUrl, VrapHttpClient httpClient, TokenSupplier tokenSupplier, List<Middleware> middlewares) {
        return ClientFactory.create(apiBaseUrl, httpClient, tokenSupplier, (ApiHttpRequest request, String topic) -> InternalLogger.getLogger("commercetools." + topic), middlewares, null);
    }

    public static ApiHttpClient create(String apiBaseUrl, VrapHttpClient httpClient, TokenSupplier tokenSupplier, Supplier<String> userAgentSupplier, List<Middleware> middlewares) {
        return ClientFactory.create(apiBaseUrl, httpClient, tokenSupplier, (request, topic) -> InternalLogger.getLogger("commercetools." + topic), userAgentSupplier, middlewares, null);
    }

    public static ApiHttpClient create(String apiBaseUrl, VrapHttpClient httpClient, TokenSupplier tokenSupplier, List<Middleware> middlewares, CorrelationIdProvider correlationIdProvider) {
        return ClientFactory.create(apiBaseUrl, httpClient, tokenSupplier, (ApiHttpRequest request, String topic) -> InternalLogger.getLogger("commercetools." + topic), middlewares, correlationIdProvider);
    }

    public static ApiHttpClient create(String apiBaseUrl, VrapHttpClient httpClient, TokenSupplier tokenSupplier, Supplier<String> userAgentSupplier, List<Middleware> middlewares, CorrelationIdProvider correlationIdProvider) {
        return ClientFactory.create(apiBaseUrl, httpClient, tokenSupplier, (request, topic) -> InternalLogger.getLogger("commercetools." + topic), userAgentSupplier, middlewares, correlationIdProvider);
    }

    public static ApiHttpClient create(String apiBaseUrl, VrapHttpClient httpClient, TokenSupplier tokenSupplier, InternalLoggerFactory internalLoggerFactory, List<Middleware> middlewares) {
        return ClientFactory.create(apiBaseUrl, httpClient, tokenSupplier, internalLoggerFactory, middlewares, null);
    }

    public static ApiHttpClient create(String apiBaseUrl, VrapHttpClient httpClient, TokenSupplier tokenSupplier, InternalLoggerFactory internalLoggerFactory, Supplier<String> userAgentSupplier, List<Middleware> middlewares) {
        return ClientFactory.create(apiBaseUrl, httpClient, tokenSupplier, internalLoggerFactory, userAgentSupplier, middlewares, null);
    }

    public static ApiHttpClient create(String apiBaseUrl, VrapHttpClient httpClient, TokenSupplier tokenSupplier, InternalLoggerFactory internalLoggerFactory, List<Middleware> middlewares, @Nullable CorrelationIdProvider correlationIdProvider) {
        return ClientFactory.create(apiBaseUrl, httpClient, tokenSupplier, internalLoggerFactory, MiddlewareFactory::buildUserAgent, middlewares, correlationIdProvider);
    }

    public static ApiHttpClient create(String apiBaseUrl, VrapHttpClient httpClient, TokenSupplier tokenSupplier, InternalLoggerFactory internalLoggerFactory, Supplier<String> userAgentSupplier, List<Middleware> middlewares, @Nullable CorrelationIdProvider correlationIdProvider) {
        ArrayList<Middleware> middlewareStack = new ArrayList<Middleware>(MiddlewareFactory.createDefault(tokenSupplier, internalLoggerFactory, userAgentSupplier));
        if (correlationIdProvider != null) {
            middlewareStack.add((request, next) -> (CompletableFuture)next.apply(request.withHeader("X-Correlation-ID", correlationIdProvider.getCorrelationId())));
        }
        middlewareStack.addAll(middlewares);
        HandlerStack stack = HandlerStack.create(HttpHandler.create(httpClient), middlewareStack);
        return ApiHttpClient.of(apiBaseUrl, stack);
    }
}

