/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.http;

import io.vrap.rmf.base.client.AuthenticationToken;
import io.vrap.rmf.base.client.AutoCloseableService;
import io.vrap.rmf.base.client.oauth2.TokenSupplier;
import java.util.concurrent.CompletableFuture;

public class OAuthHandler
extends AutoCloseableService {
    private final TokenSupplier supplier;
    private AuthenticationToken token;

    public OAuthHandler(TokenSupplier supplier) {
        this.supplier = supplier;
    }

    static String authHeader(AuthenticationToken token) {
        return "Bearer " + token.getAccessToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationToken getToken() {
        if (this.token == null || this.token.isExpired()) {
            OAuthHandler oAuthHandler = this;
            synchronized (oAuthHandler) {
                if (this.token == null || this.token.isExpired()) {
                    ((CompletableFuture)this.supplier.getToken().thenApply(authenticationToken -> {
                        this.token = authenticationToken;
                        return this.token;
                    })).join();
                }
            }
        }
        return this.token;
    }

    public AuthenticationToken refreshToken() {
        this.token = null;
        return this.getToken();
    }

    @Override
    protected void internalClose() {
        if (this.supplier instanceof AutoCloseable) {
            OAuthHandler.closeQuietly((AutoCloseable)((Object)this.supplier));
        }
    }
}

