/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.http;

import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.AuthenticationToken;
import io.vrap.rmf.base.client.error.UnauthorizedException;
import io.vrap.rmf.base.client.http.Middleware;
import io.vrap.rmf.base.client.http.OAuthHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.FailsafeExecutor;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthMiddleware
implements Middleware,
AutoCloseable {
    private final OAuthHandler authHandler;
    private static final Logger logger = LoggerFactory.getLogger((String)"commercetools.auth");
    private final FailsafeExecutor<ApiHttpResponse<byte[]>> failsafeExecutor;

    public OAuthMiddleware(OAuthHandler oAuthHandler) {
        this(oAuthHandler, 1);
    }

    public OAuthMiddleware(OAuthHandler oauthHandler, Integer maxRetries) {
        RetryPolicy retry = ((RetryPolicy)new RetryPolicy().handleIf((response, throwable) -> {
            if (throwable != null) {
                return throwable instanceof UnauthorizedException;
            }
            return response.getStatusCode() == 401;
        })).onRetry(event -> {
            logger.debug("Refresh Bearer token #" + event.getAttemptCount());
            oauthHandler.refreshToken();
        }).withMaxRetries(maxRetries.intValue());
        this.authHandler = oauthHandler;
        this.failsafeExecutor = Failsafe.with((Policy[])new RetryPolicy[]{retry});
    }

    @Override
    public CompletableFuture<ApiHttpResponse<byte[]>> invoke(ApiHttpRequest request, Function<ApiHttpRequest, CompletableFuture<ApiHttpResponse<byte[]>>> next) {
        return this.failsafeExecutor.getStageAsync(() -> {
            AuthenticationToken token = this.authHandler.getToken();
            return (CompletionStage)next.apply(request.addHeader("Authorization", OAuthHandler.authHeader(token)));
        });
    }

    @Override
    public void close() {
        this.authHandler.close();
    }
}

