/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.http;

import io.vrap.rmf.base.client.ApiHttpException;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.http.Middleware;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.FailsafeExecutor;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryMiddleware
implements Middleware,
AutoCloseable {
    @Deprecated
    public static final int DEFAULT_MAX_PARALLEL_REQUESTS = 2;
    public static final int DEFAULT_MAX_DELAY = 60000;
    public static final int DEFAULT_INITIAL_DELAY = 200;
    public static final List<Integer> DEFAULT_RETRY_STATUS_CODES = Collections.singletonList(503);
    private static final Logger logger = LoggerFactory.getLogger((String)"commercetools");
    private final FailsafeExecutor<ApiHttpResponse<byte[]>> failsafeExecutor;

    public RetryMiddleware(int maxRetries) {
        this(maxRetries, DEFAULT_RETRY_STATUS_CODES);
    }

    public RetryMiddleware(int maxRetries, List<Integer> statusCodes) {
        this(maxRetries, 200L, 60000L, statusCodes);
    }

    public RetryMiddleware(int maxRetries, long delay, long maxDelay) {
        this(maxRetries, delay, maxDelay, DEFAULT_RETRY_STATUS_CODES);
    }

    public RetryMiddleware(int maxRetries, long delay, long maxDelay, List<Integer> statusCodes) {
        RetryPolicy retryPolicy = ((RetryPolicy)new RetryPolicy().handleIf((response, throwable) -> {
            if (throwable instanceof ApiHttpException) {
                return statusCodes.contains(((ApiHttpException)throwable).getStatusCode());
            }
            return statusCodes.contains(response.getStatusCode());
        })).withBackoff(delay, maxDelay, ChronoUnit.MILLIS).withJitter(0.25).onRetry(event -> logger.info("Retry #" + event.getAttemptCount())).withMaxRetries(maxRetries);
        this.failsafeExecutor = Failsafe.with((Policy[])new RetryPolicy[]{retryPolicy});
    }

    @Deprecated
    public RetryMiddleware(int maxParallelRequests, int maxRetries) {
        this(maxRetries, DEFAULT_RETRY_STATUS_CODES);
    }

    @Deprecated
    public RetryMiddleware(int maxParallelRequests, int maxRetries, List<Integer> statusCodes) {
        this(maxRetries, 200L, 60000L, statusCodes);
    }

    @Deprecated
    public RetryMiddleware(int maxParallelRequests, int maxRetries, long delay, long maxDelay) {
        this(maxRetries, delay, maxDelay, DEFAULT_RETRY_STATUS_CODES);
    }

    @Deprecated
    public RetryMiddleware(int maxParallelRequests, int maxRetries, long delay, long maxDelay, List<Integer> statusCodes) {
        this(maxRetries, delay, maxDelay, statusCodes);
    }

    @Override
    public CompletableFuture<ApiHttpResponse<byte[]>> invoke(ApiHttpRequest request, Function<ApiHttpRequest, CompletableFuture<ApiHttpResponse<byte[]>>> next) {
        return this.failsafeExecutor.getStageAsync(() -> (CompletableFuture)next.apply(request));
    }

    @Override
    public void close() {
    }
}

