/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.oauth2;

import io.vrap.rmf.base.client.ApiHttpHeaders;
import io.vrap.rmf.base.client.ApiHttpMethod;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.AuthenticationToken;
import io.vrap.rmf.base.client.AutoCloseableService;
import io.vrap.rmf.base.client.VrapHttpClient;
import io.vrap.rmf.base.client.http.InternalLogger;
import io.vrap.rmf.base.client.oauth2.TokenSupplier;
import io.vrap.rmf.base.client.utils.Utils;
import io.vrap.rmf.base.client.utils.json.JsonUtils;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class GlobalCustomerPasswordTokenSupplier
extends AutoCloseableService
implements TokenSupplier {
    private final InternalLogger logger = InternalLogger.getLogger("commercetools.auth");
    private final VrapHttpClient vrapHttpClient;
    private final ApiHttpRequest apiHttpRequest;

    public GlobalCustomerPasswordTokenSupplier(String clientId, String clientSecret, String email, String password, String scope, String tokenEndpoint, VrapHttpClient vrapHttpClient) {
        this.vrapHttpClient = vrapHttpClient;
        this.apiHttpRequest = GlobalCustomerPasswordTokenSupplier.constructApiHttpRequest(clientId, clientSecret, email, password, scope, tokenEndpoint);
    }

    @Override
    public CompletableFuture<AuthenticationToken> getToken() {
        return ((CompletableFuture)((CompletableFuture)this.vrapHttpClient.execute(this.apiHttpRequest).whenComplete((response, throwable) -> {
            if (throwable != null) {
                this.logger.error(() -> response, (Throwable)throwable);
            } else {
                this.logger.debug(() -> response);
            }
        })).thenApply(apiHttpResponse -> {
            if (apiHttpResponse.getStatusCode() < 200 || apiHttpResponse.getStatusCode() > 299) {
                throw new CompletionException(new Throwable(new String((byte[])apiHttpResponse.getBody())));
            }
            return apiHttpResponse;
        })).thenApply(Utils.wrapToCompletionException(response -> JsonUtils.fromJsonByteArray((byte[])response.getBody(), AuthenticationToken.class)));
    }

    private static ApiHttpRequest constructApiHttpRequest(String clientId, String clientSecret, String email, String password, String scope, String tokenEndpoint) {
        String auth = Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes(StandardCharsets.UTF_8));
        String body = scope == null || scope.isEmpty() ? "grant_type=password&username=" + email + "&password=" + password : "grant_type=password&username=" + email + "&password=" + password + "&scope=" + scope;
        ApiHttpHeaders apiHttpHeaders = new ApiHttpHeaders().withHeader("Authorization", "Basic " + auth).withHeader("Content-Type", "application/x-www-form-urlencoded");
        return new ApiHttpRequest(ApiHttpMethod.POST, URI.create(tokenEndpoint), apiHttpHeaders, body.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    protected void internalClose() {
        if (this.vrapHttpClient instanceof AutoCloseable) {
            GlobalCustomerPasswordTokenSupplier.closeQuietly((AutoCloseable)((Object)this.vrapHttpClient));
        }
    }
}

