/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.utils.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.vrap.rmf.base.client.utils.json.JsonException;
import io.vrap.rmf.base.client.utils.json.modules.ZonedDateTimeDeserializationModule;
import io.vrap.rmf.base.client.utils.json.modules.ZonedDateTimeSerializationModule;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public class JsonUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static byte[] toJsonByteArray(Object value) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsBytes(value);
    }

    public static String toJsonString(Object value) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString(value);
    }

    public static <T> T fromJsonString(String content, Class<T> clazz) throws IOException {
        return (T)OBJECT_MAPPER.readValue(content, clazz);
    }

    public static <T> T fromJsonByteArray(byte[] content, Class<T> clazz) throws IOException {
        return (T)OBJECT_MAPPER.readValue(content, clazz);
    }

    public static <T> T fromInputStream(InputStream content, Class<T> clazz) throws IOException {
        return (T)OBJECT_MAPPER.readValue(content, clazz);
    }

    public static ObjectMapper getConfiguredObjectMapper() {
        return OBJECT_MAPPER;
    }

    private static JsonNode secure(JsonNode node) {
        if (node.isObject()) {
            ObjectNode objectNode = (ObjectNode)node;
            Iterator fields = node.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                if (((JsonNode)field.getValue()).isTextual() && (((String)field.getKey()).toLowerCase().contains("pass") || ((String)field.getKey()).toLowerCase().contains("access_token"))) {
                    objectNode.put((String)field.getKey(), "**removed from output**");
                    continue;
                }
                JsonUtils.secure((JsonNode)field.getValue());
            }
            return objectNode;
        }
        if (node.isArray()) {
            ArrayNode arrayNode = (ArrayNode)node;
            Iterator elements = arrayNode.elements();
            while (elements.hasNext()) {
                JsonUtils.secure((JsonNode)elements.next());
            }
            return arrayNode;
        }
        return node;
    }

    public static String prettyPrint(String json) {
        return JsonUtils.executing(() -> {
            ObjectMapper jsonParser = new ObjectMapper();
            JsonNode jsonTree = (JsonNode)jsonParser.readValue(json, JsonNode.class);
            JsonUtils.secure(jsonTree);
            ObjectWriter writer = jsonParser.writerWithDefaultPrettyPrinter();
            return writer.writeValueAsString((Object)jsonTree);
        });
    }

    private static <T> T executing(SupplierThrowingIOException<T> supplier) {
        try {
            return supplier.get();
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    static {
        ServiceLoader<SimpleModule> loader = ServiceLoader.load(SimpleModule.class, SimpleModule.class.getClassLoader());
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule()).registerModule((Module)new ZonedDateTimeSerializationModule()).registerModule((Module)new ZonedDateTimeDeserializationModule()).registerModules(loader).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }

    @FunctionalInterface
    private static interface SupplierThrowingIOException<T> {
        public T get() throws IOException;
    }
}

