/*
 * Decompiled with CFR 0.152.
 */
package com.commsen.em.maven.extension;

import com.commsen.em.maven.extension.Constants;
import com.commsen.em.maven.plugins.BndExportPlugin;
import com.commsen.em.maven.plugins.BndIndexerPlugin;
import com.commsen.em.maven.plugins.BndPlugin;
import com.commsen.em.maven.plugins.DistroPlugin;
import com.commsen.em.maven.plugins.EmRegisterContractPlugin;
import java.util.LinkedList;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.execution.AbstractExecutionListener;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=ExecutionListener.class, hint="em")
public class EccentricModularityExecutionListener
extends AbstractExecutionListener {
    @Requirement
    private BndPlugin bndPlugin;
    @Requirement
    private BndIndexerPlugin bndIndexerPlugin;
    @Requirement
    private BndExportPlugin bndExportPlugin;
    @Requirement
    private DistroPlugin distroPlugin;
    @Requirement
    private EmRegisterContractPlugin contractExporterPlugin;
    @Requirement(role=ArtifactRepositoryLayout.class, hint="default")
    private ArtifactRepositoryLayout defaultLayout;
    private ExecutionListener delegate;
    private Logger logger = LoggerFactory.getLogger(EccentricModularityExecutionListener.class);

    public void setDelegate(ExecutionListener executionListener) {
        this.delegate = executionListener;
    }

    public void projectStarted(ExecutionEvent event) {
        boolean hasOld;
        this.delegate.projectStarted(event);
        MavenProject project = event.getProject();
        boolean bl = hasOld = project.getProperties().keySet().stream().filter(p -> p.toString().startsWith("_.eccentric.modularity.")).peek(p -> this.logger.error("Property '{}' uses old prefix! Use '{}' instead!", p, (Object)p.toString().replace("_.eccentric.modularity.", "em:"))).count() > 0L;
        if (hasOld) {
            throw new RuntimeException("Can't build project using old properties!");
        }
        boolean bl2 = hasOld = project.getProperties().keySet().stream().filter(p -> p.toString().startsWith("em:metadata")).peek(p -> this.logger.error("Property '{}' uses old syntax! Use '{}' instead!", p, (Object)p.toString().replace("em:metadata", "em:module"))).count() > 0L;
        if (hasOld) {
            throw new RuntimeException("Can't build project using old properties!");
        }
        if (Constants.VAL_BND_VERSION.toLowerCase().contains("snapshot")) {
            this.addBndSnapshotRepo(project);
        }
        boolean generateIndex = project.getProperties().containsKey("em:config.createIndex");
        boolean actionFound = false;
        this.addAnnotationProcessorsAsDependency(project);
        this.logger.info("Adding plugins and adapting project configuration based on provided 'em:*' properties!");
        if (project.getProperties().containsKey("em:module")) {
            actionFound = true;
            try {
                this.contractExporterPlugin.addToPom(project);
                this.bndPlugin.addToBuild(project);
            }
            catch (MavenExecutionException e) {
                throw new RuntimeException("Failed to add bnd-maven-plugin!", e);
            }
        }
        if (project.getProperties().containsKey("em:augment")) {
            actionFound = true;
            try {
                this.bndPlugin.addToBuildForAugment(project);
            }
            catch (MavenExecutionException e) {
                throw new RuntimeException("Failed to add bnd-maven-plugin!", e);
            }
        }
        if ("index".equals(project.getPackaging())) {
            actionFound = true;
            try {
                this.bndIndexerPlugin.configureForIndexGeneration(project);
            }
            catch (MavenExecutionException e) {
                throw new RuntimeException("Failed to configure bnd-indexer-maven-plugin!", e);
            }
        }
        if (project.getProperties().containsKey("em:resolve")) {
            actionFound = true;
            String resolveTarget = project.getProperties().getProperty("em:resolve", "");
            if (!resolveTarget.trim().isEmpty()) {
                try {
                    this.distroPlugin.createDistroJar(project, resolveTarget);
                }
                catch (MavenExecutionException e) {
                    throw new RuntimeException("Failed to extract metadata from the target runtime '" + resolveTarget + "'!", e);
                }
            }
            try {
                this.contractExporterPlugin.addToPom(project);
                this.bndExportPlugin.addToPomForExport(project);
                if (generateIndex) {
                    this.bndIndexerPlugin.addToPomForIndexingTmpBundles(project);
                }
                this.bndPlugin.addToBuild(project);
            }
            catch (MavenExecutionException e) {
                throw new RuntimeException("Failed to add one of the required bnd plugins!", e);
            }
        }
        if (project.getProperties().containsKey("em:executable")) {
            actionFound = true;
            try {
                this.contractExporterPlugin.addToPom(project);
                this.bndExportPlugin.addToPomForExecutable(project);
                if (generateIndex) {
                    this.bndIndexerPlugin.addToPomForIndexingTmpBundles(project);
                }
                this.bndPlugin.addToBuild(project);
            }
            catch (MavenExecutionException e) {
                throw new RuntimeException("Failed to add one of the required bnd plugins!", e);
            }
        }
        if (!actionFound) {
            this.logger.info("No 'em:*' action found! Project will be executed AS IS!");
        }
    }

    public void projectDiscoveryStarted(ExecutionEvent event) {
        this.delegate.projectDiscoveryStarted(event);
    }

    public void sessionStarted(ExecutionEvent event) {
        this.delegate.sessionStarted(event);
    }

    public void sessionEnded(ExecutionEvent event) {
        this.delegate.sessionEnded(event);
    }

    public void projectSkipped(ExecutionEvent event) {
        this.delegate.projectSkipped(event);
    }

    public void projectSucceeded(ExecutionEvent event) {
        this.delegate.projectSucceeded(event);
        this.bndExportPlugin.cleanup();
    }

    public void projectFailed(ExecutionEvent event) {
        this.delegate.projectFailed(event);
        this.bndExportPlugin.cleanup();
    }

    public void forkStarted(ExecutionEvent event) {
        this.delegate.forkStarted(event);
    }

    public void forkSucceeded(ExecutionEvent event) {
        this.delegate.forkSucceeded(event);
    }

    public void forkFailed(ExecutionEvent event) {
        this.delegate.forkFailed(event);
    }

    public void mojoSkipped(ExecutionEvent event) {
        this.delegate.mojoSkipped(event);
    }

    public void mojoStarted(ExecutionEvent event) {
        this.delegate.mojoStarted(event);
    }

    public void mojoSucceeded(ExecutionEvent event) {
        this.delegate.mojoSucceeded(event);
    }

    public void mojoFailed(ExecutionEvent event) {
        this.delegate.mojoFailed(event);
    }

    public void forkedProjectStarted(ExecutionEvent event) {
        this.delegate.forkedProjectStarted(event);
    }

    public void forkedProjectSucceeded(ExecutionEvent event) {
        this.delegate.forkedProjectSucceeded(event);
    }

    public void forkedProjectFailed(ExecutionEvent event) {
        this.delegate.forkedProjectFailed(event);
    }

    private void addAnnotationProcessorsAsDependency(MavenProject project) {
        Dependency dep = new Dependency();
        dep.setGroupId("com.commsen.em");
        dep.setArtifactId("em.annotation.processors");
        dep.setVersion("(0.1.0,)");
        project.getModel().getDependencies().add(dep);
    }

    private void addBndSnapshotRepo(MavenProject project) {
        MavenArtifactRepository ar = new MavenArtifactRepository();
        ar.setId("bnd-snapshots");
        ar.setUrl("https://bndtools.ci.cloudbees.com/job/bnd.master/lastSuccessfulBuild/artifact/dist/bundles/");
        ar.setLayout(this.defaultLayout);
        LinkedList<MavenArtifactRepository> pluginRepos = new LinkedList<MavenArtifactRepository>();
        pluginRepos.addAll(project.getPluginArtifactRepositories());
        pluginRepos.add(ar);
        project.setPluginArtifactRepositories(pluginRepos);
        LinkedList<MavenArtifactRepository> repos = new LinkedList<MavenArtifactRepository>();
        repos.addAll(project.getRemoteArtifactRepositories());
        repos.add(ar);
        project.setRemoteArtifactRepositories(repos);
    }
}

