/*
 * Decompiled with CFR 0.152.
 */
package com.commsen.em.maven.plugins;

import com.commsen.em.maven.extension.Constants;
import com.commsen.em.maven.plugins.DynamicMavenPlugin;
import com.commsen.em.maven.util.Dependencies;
import com.commsen.em.maven.util.Flag;
import com.commsen.em.maven.util.Templates;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=BndExportPlugin.class)
public class BndExportPlugin
extends DynamicMavenPlugin {
    private Logger logger = LoggerFactory.getLogger(BndExportPlugin.class);
    @Requirement
    private Dependencies dependencies;
    @Requirement
    private Templates templates;
    private List<File> filesToCleanup = new LinkedList<File>();

    public void addToPomForExport(MavenProject project) throws MavenExecutionException {
        String bndrunName = this.getBndrunName(project);
        this.addToPom(project, true, bndrunName);
        project.getProperties().setProperty("em:resolve.output", "${project.build.directory}/export/" + bndrunName);
        this.logger.info("Added `bnd-export-maven-plugin` to genrate list of modules needed at runtume!");
    }

    public void addToPomForExecutable(MavenProject project) throws MavenExecutionException {
        this.addToPom(project, false, this.getBndrunName(project));
        this.logger.info("Added `bnd-export-maven-plugin` to genrate list of modules incuded in executable jar!");
    }

    public void addToPom(MavenProject project, boolean bundlesOnly, String bndrun) throws MavenExecutionException {
        Set<File> bundles = this.prepareDependencies(project);
        File thisArtifact = new File(project.getBuild().getDirectory(), project.getBuild().getFinalName() + "." + project.getPackaging());
        bundles.add(thisArtifact);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("bundlesOnly", bundlesOnly);
        model.put("bndrun", bndrun);
        model.put("bundles", bundles);
        String configuration = null;
        try {
            configuration = this.templates.process("META-INF/templates/bnd-export-maven-plugin-configuration.fmt", model);
        }
        catch (TemplateException | IOException e) {
            throw new MavenExecutionException("Failed to process template file!", e);
        }
        Plugin plugin = this.createPlugin("com.commsen.em", "em-maven-plugin", Constants.VAL_EXTENSION_VERSION, configuration, "export", "export", "package");
        project.getBuild().getPlugins().add(0, plugin);
        this.createBndrunIfNotExists(project, bndrun);
    }

    public void cleanup() {
        for (File file : this.filesToCleanup) {
            FileUtils.deleteQuietly((File)file);
        }
    }

    private String getBndrunName(MavenProject project) throws MavenExecutionException {
        String bndrunName = project.getProperties().getProperty("em:resolve.bndrun", "");
        if (bndrunName.trim().isEmpty()) {
            bndrunName = project.getName();
        }
        if (bndrunName.endsWith(".bndrun")) {
            bndrunName = bndrunName.substring(0, bndrunName.length() - ".bndrun".length());
        }
        int count = 0;
        while (new File(project.getBasedir(), bndrunName + ".bndrun").isFile()) {
            bndrunName = bndrunName + "." + ++count;
        }
        return bndrunName;
    }

    private void createBndrunIfNotExists(MavenProject project, String bndrunName) throws MavenExecutionException {
        if (bndrunName == null || bndrunName.trim().isEmpty()) {
            throw new MavenExecutionException("Invalid bndrun name: " + bndrunName, project.getFile());
        }
        File bndrunFile = new File(project.getBasedir(), bndrunName + ".bndrun");
        if (bndrunFile.exists() && !bndrunFile.isFile()) {
            throw new MavenExecutionException("'" + bndrunFile + "' is not a file!", project.getFile());
        }
        String distro = project.getProperties().getProperty("em:internal.distro", "");
        this.generateBndrun(project, distro, bndrunFile);
        this.filesToCleanup.add(bndrunFile);
    }

    private void generateBndrun(MavenProject project, String distro, File bndFile) throws MavenExecutionException {
        HashSet<String> requirements = new HashSet<String>();
        requirements.add("osgi.identity;filter:='(osgi.identity=" + project.getArtifactId() + ")'");
        String contracts = project.getProperties().getProperty("em:contracts");
        if (contracts != null && !contracts.trim().isEmpty()) {
            String[] contractsArray;
            for (String contract : contractsArray = contracts.split("[\\s]*,[\\s]*")) {
                requirements.add("em.contract;filter:='(em.contract=" + contract + ")';effective:=assemble");
            }
        }
        HashSet<String> runProperties = new HashSet<String>();
        String runPropertiesText = project.getProperties().getProperty("em:executableproperties");
        if (runPropertiesText != null && !runPropertiesText.trim().isEmpty()) {
            String[] propertiesArray = runPropertiesText.split("[\\s]*\\n[\\s]*");
            runProperties.addAll(Arrays.asList(propertiesArray));
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("requirements", requirements);
        model.put("runProperties", runProperties);
        model.put("distro", distro);
        String bndrunContent = null;
        try {
            bndrunContent = this.templates.process("META-INF/templates/bndrun.fmt", model);
        }
        catch (TemplateException | IOException e) {
            throw new MavenExecutionException("Failed to process template file!", e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Generated bndrun file: \n{}", (Object)bndrunContent);
        }
        this.writeBndrun(bndFile, bndrunContent);
        if (Flag.keepBndrun()) {
            this.writeBndrun(new File(project.getBasedir(), "_em.generated.bndrun"), bndrunContent);
        }
    }

    private void writeBndrun(File generatedBndrunFile, String content) throws MavenExecutionException {
        try {
            generatedBndrunFile.createNewFile();
            generatedBndrunFile.deleteOnExit();
            PrintWriter writer = new PrintWriter(generatedBndrunFile, "UTF-8");
            writer.print(content.replaceAll("\\t", "    "));
            writer.close();
        }
        catch (IOException e) {
            throw new MavenExecutionException("Failed to create temprary bndrun file!", (Throwable)e);
        }
    }

    private Set<File> prepareDependencies(MavenProject project) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Analysing project's BOMs!");
        } else if (Flag.verbose()) {
            this.logger.info("Analysing project's BOMs!");
        }
        File tmpBundleFolder = new File(project.getBasedir(), project.getProperties().getProperty("em:config..tempBundlesDirectory", ".bundles"));
        try {
            FileUtils.forceMkdir((File)tmpBundleFolder);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temprary directory: " + tmpBundleFolder, e);
        }
        this.filesToCleanup.add(tmpBundleFolder);
        HashSet<File> bundleSet = new HashSet<File>();
        boolean generateIndex = project.getProperties().containsKey("em:config.createIndex");
        this.processModules(project);
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        try {
            artifacts.addAll(this.dependencies.asArtifacts(project));
            artifacts.addAll(this.dependencies.managedAsArtifacts(project));
        }
        catch (MavenExecutionException e) {
            throw new RuntimeException("Failed to analyze dependencies", e);
        }
        artifacts.stream().forEach(a -> this.addToBundleSet((Artifact)a, tmpBundleFolder, (Set<File>)bundleSet, generateIndex));
        return bundleSet;
    }

    public void processModules(MavenProject project) {
        String modulesText = project.getProperties().getProperty("em:contractors");
        if (modulesText == null || modulesText.trim().isEmpty()) {
            if (Flag.verbose()) {
                this.logger.info("No available modules in '{}'", (Object)"em:contractors");
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("No available modules in '{}'", (Object)"em:contractors");
            }
            return;
        }
        String[] modulesArray = modulesText.split("[\\s]*[,\\n][\\s]*");
        Set modulesSet = Arrays.stream(modulesArray).collect(Collectors.toSet());
        modulesSet.add("com.commsen.em.contractors:em.contractors.runtime:" + Constants.VAL_EXTENSION_VERSION);
        for (String moduleText : modulesSet) {
            String[] coordinates = moduleText.split(":");
            if (coordinates.length != 3) {
                this.logger.warn("Invalid maven coordinates for module '{}'! It will be ignored!", (Object)moduleText);
                continue;
            }
            Dependency dependency = new Dependency();
            dependency.setGroupId(coordinates[0]);
            dependency.setArtifactId(coordinates[1]);
            dependency.setVersion(coordinates[2]);
            dependency.setScope("runtime");
            dependency.setType("pom");
            try {
                Artifact pomArtifact = this.dependencies.asArtifact(project, dependency);
                dependency.setType("jar");
                MavenXpp3Reader reader = new MavenXpp3Reader();
                Model model = reader.read((InputStream)new FileInputStream(pomArtifact.getFile()));
                DependencyManagement dm = model.getDependencyManagement();
                if (dm == null) {
                    this.dependencies.addToDependencyManagement(project, dependency);
                    continue;
                }
                for (Dependency d : dm.getDependencies()) {
                    if (d.getArtifactId().startsWith("${")) {
                        this.dependencies.addToDependencyManagement(project, dependency);
                        continue;
                    }
                    this.dependencies.addToDependencyManagement(project, d);
                }
            }
            catch (Exception e) {
                this.logger.warn("Could not process modules from " + coordinates[0] + ":" + coordinates[1] + ":" + coordinates[2], (Throwable)e);
            }
        }
    }

    private void addToBundleSet(Artifact artifact, File bundlesDirectory, Set<File> bundlesSet, boolean indexGeneration) {
        File f;
        if (this.dependencies.isOSGiBundle(artifact)) {
            f = artifact.getFile();
            if (indexGeneration) {
                try {
                    FileUtils.copyFile((File)artifact.getFile(), (File)new File(bundlesDirectory, f.getName()));
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to copy file to temporary folder", e);
                }
            }
        } else {
            f = new File(bundlesDirectory, artifact.getArtifactId() + "-" + artifact.getVersion() + "-EM.jar");
            this.makeBundle(artifact, f);
        }
        bundlesSet.add(f);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Made '{}' module available to the resolver", (Object)artifact);
        } else if (Flag.verbose()) {
            this.logger.info("Made '{}' module available to the resolver", (Object)artifact);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean makeBundle(Artifact artifact, File targetFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

