/*
 * Decompiled with CFR 0.152.
 */
package com.commsen.em.maven.plugins;

import com.commsen.em.maven.extension.Constants;
import com.commsen.em.maven.plugins.DynamicMavenPlugin;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=BndIndexerPlugin.class)
public class BndIndexerPlugin
extends DynamicMavenPlugin {
    private Logger logger = LoggerFactory.getLogger(BndIndexerPlugin.class);

    public void addToPom(MavenProject project) throws MavenExecutionException {
        String configuration = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><configuration>\t\t<localURLs>ALLOWED</localURLs>\t\t<includeJar>true</includeJar>\t\t<outputFile>${project.build.directory}/index/index.xml</outputFile></configuration>";
        Plugin plugin = this.createPlugin("biz.aQute.bnd", "bnd-indexer-maven-plugin", Constants.VAL_BND_VERSION, configuration, "index", "index", null);
        project.getBuild().getPlugins().add(0, plugin);
    }

    public void addToPomForIndexingTmpBundles(MavenProject project) throws MavenExecutionException {
        String configuration = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><configuration>\t\t<inputDir>" + project.getProperties().getProperty("em:config..tempBundlesDirectory", ".bundles") + "</inputDir>" + "\t\t<outputFile>${project.build.directory}/index/index.xml</outputFile>" + "</configuration>";
        Plugin plugin = this.createPlugin("biz.aQute.bnd", "bnd-indexer-maven-plugin", Constants.VAL_BND_VERSION, configuration, "index", "local-index", null);
        project.getBuild().getPlugins().add(0, plugin);
        this.logger.info("Added `bnd-indexer-maven-plugin` to genrate an index of detected modules!");
    }

    public void configureForIndexGeneration(MavenProject project) throws MavenExecutionException {
        Plugin plugin = this.getPlugin(project, "biz.aQute.bnd:bnd-indexer-maven-plugin");
        if (plugin != null) {
            String configuration = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><configuration>\t\t<localURLs>ALLOWED</localURLs>\t\t<includeJar>false</includeJar>\t\t<outputFile>${project.build.directory}/index.xml</outputFile></configuration>";
            this.configurePlugin(plugin, "default-index", configuration);
            this.logger.info("Configuring `bnd-indexer-maven-plugin` to genrate an index from project's dependencies!");
        }
    }
}

