/*
 * Decompiled with CFR 0.152.
 */
package com.commsen.em.maven.plugins;

import com.commsen.em.maven.extension.Constants;
import com.commsen.em.maven.plugins.DynamicMavenPlugin;
import com.commsen.em.maven.util.Templates;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=BndPlugin.class)
public class BndPlugin
extends DynamicMavenPlugin {
    private Logger logger = LoggerFactory.getLogger(BndPlugin.class);
    @Requirement
    private Templates templates;

    public void addToBuild(MavenProject project) throws MavenExecutionException {
        String includePackages = project.getProperties().getProperty("em:module.includePackages", "");
        String importPackages = project.getProperties().getProperty("em:module.importPackages", "");
        String ignorePackages = project.getProperties().getProperty("em:module.ignorePackages", "");
        StringBuilder importStatement = new StringBuilder();
        if (!ignorePackages.isEmpty()) {
            Arrays.stream(ignorePackages.split(",")).forEach(p -> importStatement.append("!").append((String)p).append(","));
        }
        if (!importPackages.isEmpty()) {
            importStatement.append(importPackages).append(",");
        }
        importStatement.append("*");
        HashMap<String, CharSequence> model = new HashMap<String, CharSequence>();
        model.put("includePackages", includePackages);
        model.put("importStatement", importStatement);
        String bndContent = null;
        try {
            bndContent = this.templates.process("META-INF/templates/bnd.fmt", model);
        }
        catch (TemplateException | IOException e) {
            throw new MavenExecutionException("Failed to process template file!", e);
        }
        StringBuilder configuration = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n").append("<configuration><bnd><![CDATA[ \n").append(bndContent).append("]]></bnd></configuration>");
        this.logger.debug("Generated bnd-maven-plugin confgiguration: \n {}", (Object)configuration);
        project.getBuild().getPlugins().add(0, this.preparePlugin(configuration.toString()));
        this.configureJarPlugin(project);
        this.logger.info("Added `bnd-maven-plugin` to generate metadata");
    }

    public void addToBuildForAugment(MavenProject project) throws MavenExecutionException {
        String path = project.getProperties().getProperty("em:augment.file", "META-INF/augments.bnd");
        StringBuilder configuration = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n").append("<configuration><bnd><![CDATA[ \n").append("\tProvide-Capability: bnd.augment; path='").append(path).append("'\n").append("]]></bnd></configuration>");
        this.logger.debug("Generated bnd-maven-plugin confgiguration: \n {}", (Object)configuration);
        project.getBuild().getPlugins().add(0, this.preparePlugin(configuration.toString()));
        this.configureJarPlugin(project);
        this.logger.info("Added 'bnd-maven-plugin' to genrate jar that augments (provides metadata for) other jars!");
    }

    private Plugin preparePlugin(String configuration) throws MavenExecutionException {
        Plugin plugin = this.createPlugin("biz.aQute.bnd", "bnd-maven-plugin", Constants.VAL_BND_VERSION, configuration, "bnd-process", "bnd-process", null);
        return plugin;
    }

    private void configureJarPlugin(MavenProject project) throws MavenExecutionException {
        Plugin jarPlugin = this.getPlugin(project, "org.apache.maven.plugins:maven-jar-plugin");
        if (jarPlugin != null) {
            StringBuilder jarConfig = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n").append("<configuration><archive>\n").append("\t<manifestFile>${project.build.outputDirectory}/META-INF/MANIFEST.MF</manifestFile>\n").append("</archive></configuration>");
            this.configurePlugin(jarPlugin, "default-jar", jarConfig.toString());
        }
    }
}

