/*
 * Decompiled with CFR 0.152.
 */
package com.commsen.em.maven.plugins;

import aQute.bnd.main.bnd;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.LinkedList;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=DistroPlugin.class)
public class DistroPlugin {
    private Logger logger = LoggerFactory.getLogger(DistroPlugin.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDistroJar(MavenProject project, String remote) throws MavenExecutionException {
        String distrosFolder = project.getProperties().getProperty("em:resolve.distro", ".distros");
        bnd bnd2 = new bnd();
        try {
            String[] params = remote.split(":");
            if (params.length != 4) {
                throw new MavenExecutionException("Invalid remote. The format is `host:port:name:version` ", project.getFile());
            }
            File output = new File(project.getBasedir(), distrosFolder);
            if (output.exists()) {
                if (!output.isDirectory()) {
                    throw new MavenExecutionException("Need to create folder " + output + " but file with that name already exists!", project.getFile());
                }
            } else if (output.mkdirs()) {
                this.logger.info("Created {} folder", (Object)output);
            } else {
                throw new MavenExecutionException("Failed to create folder " + output, project.getFile());
            }
            File distroFile = new File(output, params[2] + "-" + params[3] + ".jar");
            LinkedList<String> args = new LinkedList<String>();
            args.add("remote");
            args.add("-h");
            args.add(params[0]);
            args.add("-p");
            args.add(params[1]);
            args.add("distro");
            args.add("-o");
            args.add(distroFile.getAbsolutePath());
            args.add(params[2]);
            args.add(params[3]);
            this.logger.info("  - Building a distro jar (matadata only) for provided target runtime " + remote);
            this.logger.debug("    Running bnd with the following args : " + args);
            try {
                bnd2.start(args.toArray(new String[args.size()]));
            }
            catch (Exception e) {
                throw new MavenExecutionException("Failed to build distro jar", (Throwable)e);
            }
            this.logger.info("  - Saved distro jar in " + distroFile);
            project.getProperties().setProperty("em:internal.distro", distroFile.getAbsolutePath());
        }
        finally {
            try {
                bnd2.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to properly close bnd!", (Throwable)e);
            }
        }
    }

    public void clean(MavenProject project) throws MavenExecutionException, IOException {
        String distrosFolder = project.getProperties().getProperty("em:resolve.distro", ".distros");
        File f = new File(project.getBasedir(), distrosFolder);
        if (f.exists() && f.isDirectory()) {
            this.logger.info("Deleting " + f);
            Files.walk(f.toPath(), new FileVisitOption[0]).map(Path::toFile).sorted((o1, o2) -> -o1.compareTo((File)o2)).forEach(File::delete);
        }
    }
}

