/*
 * Decompiled with CFR 0.152.
 */
package com.commsen.em.maven.plugins.shade;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.codehaus.plexus.util.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendArtifactsTrnasformer
implements ResourceTransformer {
    private static final Logger logger = LoggerFactory.getLogger(AppendArtifactsTrnasformer.class);
    private File location;
    private boolean done = false;

    public boolean canTransformResource(String resource) {
        return !this.done && "META-INF".equals(resource);
    }

    public void processResource(String resource, InputStream is, List<Relocator> relocators) throws IOException {
    }

    public boolean hasTransformedResource() {
        return !this.done;
    }

    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        if (this.location == null) {
            logger.warn("Can not append artifacts! Artifacts location not provided!");
            return;
        }
        if (!this.location.exists() || !this.location.isDirectory()) {
            logger.warn("Can not append artifacts! `{}` is not a valid directory!", (Object)this.location);
            return;
        }
        File[] files = this.location.listFiles();
        if (files != null) {
            for (File file : files) {
                JarFile jarFile = new JarFile(file);
                jarFile.stream().forEach(entry -> {
                    if (!entry.getName().startsWith("META-INF/MANIFEST.MF")) {
                        try {
                            jos.putNextEntry(new JarEntry(entry.getName()));
                            IOUtil.copy((InputStream)jarFile.getInputStream((ZipEntry)entry), (OutputStream)jos);
                        }
                        catch (IOException e) {
                            if (e instanceof ZipException && e.getMessage().startsWith("duplicate entry")) {
                                logger.debug("Skipped existing file " + entry.getName());
                            }
                            logger.warn("Could not copy file '" + entry.getName() + "' from '" + jarFile.getName() + "' to the generated jar", (Throwable)e);
                        }
                    }
                });
                jarFile.close();
            }
        }
        this.done = true;
    }
}

