/*
 * Decompiled with CFR 0.152.
 */
package com.commsen.em.maven.util;

import com.commsen.em.maven.util.Flag;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExclusionSetFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.apache.maven.shared.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.artifact.resolve.ArtifactResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=Dependencies.class)
public class Dependencies {
    private Logger logger = LoggerFactory.getLogger(Dependencies.class);
    @Requirement
    private ArtifactResolver artifactResolver;
    @Requirement
    private RepositorySystem mavenRepoSystem;

    public Set<Artifact> asArtifacts(MavenProject project) throws MavenExecutionException {
        return this.asArtifacts(project, project.getDependencies());
    }

    public Set<Artifact> managedAsArtifacts(MavenProject project) throws MavenExecutionException {
        if (project.getDependencyManagement() != null) {
            return this.asArtifacts(project, project.getDependencyManagement().getDependencies());
        }
        return Collections.emptySet();
    }

    public Set<Artifact> resolve(MavenProject project, Artifact artifact) throws MavenExecutionException {
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        ArtifactResolutionRequest artifactResolutionRequest = new ArtifactResolutionRequest();
        artifactResolutionRequest.setResolveTransitively(true);
        artifactResolutionRequest.setRemoteRepositories(project.getRemoteArtifactRepositories());
        artifactResolutionRequest.setLocalRepository(project.getProjectBuildingRequest().getLocalRepository());
        artifactResolutionRequest.setArtifact(artifact);
        ArtifactResolutionResult artifactResolutionResult = this.mavenRepoSystem.resolve(artifactResolutionRequest);
        artifactResolutionResult.getArtifacts().stream().peek(d -> {
            if (Flag.verbose()) {
                this.logger.info("RESOLVED '{}' FROM '{}'", d, (Object)artifact);
            }
        }).filter(d -> "jar".equals(d.getType())).filter(d -> "compile".equals(d.getScope()) || "provided".equals(d.getScope()) || "runtime".equals(d.getScope())).forEach(d -> artifacts.add((Artifact)d));
        return artifacts;
    }

    public Set<Artifact> asArtifacts(MavenProject project, Collection<Dependency> initial) throws MavenExecutionException {
        ArtifactResolutionRequest artifactResolutionRequest = new ArtifactResolutionRequest();
        artifactResolutionRequest.setResolveTransitively(true);
        artifactResolutionRequest.setRemoteRepositories(project.getRemoteArtifactRepositories());
        artifactResolutionRequest.setLocalRepository(project.getProjectBuildingRequest().getLocalRepository());
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        List jarDependencies = initial.stream().filter(d -> "jar".equals(d.getType())).filter(d -> "compile".equals(d.getScope()) || "provided".equals(d.getScope()) || "runtime".equals(d.getScope())).collect(Collectors.toList());
        for (Dependency dependency : jarDependencies) {
            if (Flag.verbose()) {
                this.logger.info("Processing: " + dependency);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("Processing: " + dependency);
            }
            HashSet tmpArtifacts = new HashSet();
            HashSet<String> excludes = new HashSet<String>();
            for (Exclusion exclusion : dependency.getExclusions()) {
                if (exclusion.getGroupId() != null) {
                    excludes.add(exclusion.getGroupId() + ":" + exclusion.getArtifactId());
                    continue;
                }
                excludes.add(exclusion.getArtifactId());
            }
            ExclusionSetFilter filter = new ExclusionSetFilter(excludes);
            Artifact artifact = this.asArtifact(project, dependency);
            artifacts.add(artifact);
            artifactResolutionRequest.setArtifact(artifact);
            artifactResolutionRequest.setCollectionFilter((ArtifactFilter)filter);
            ArtifactResolutionResult artifactResolutionResult = this.mavenRepoSystem.resolve(artifactResolutionRequest);
            artifactResolutionResult.getArtifacts().stream().peek(d -> {
                if (Flag.verbose()) {
                    this.logger.info("Processing '{}' from '{}'", d, (Object)this.toId(dependency));
                }
            }).filter(d -> "jar".equals(d.getType())).filter(d -> "compile".equals(d.getScope()) || "provided".equals(d.getScope()) || "runtime".equals(d.getScope())).forEach(d -> tmpArtifacts.add(d));
            if (Flag.verbose()) {
                tmpArtifacts.stream().sorted().forEach(a -> this.logger.info("   Found: " + a));
            } else if (this.logger.isDebugEnabled()) {
                tmpArtifacts.stream().sorted().forEach(a -> this.logger.debug("   Found: " + a));
            }
            artifacts.addAll(tmpArtifacts);
        }
        return artifacts;
    }

    public Artifact asArtifact(MavenProject project, Dependency dependency) throws MavenExecutionException {
        ArtifactResult ar;
        DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
        coordinate.setGroupId(dependency.getGroupId());
        coordinate.setArtifactId(dependency.getArtifactId());
        coordinate.setVersion(dependency.getVersion());
        coordinate.setExtension(dependency.getType());
        coordinate.setClassifier(dependency.getClassifier());
        try {
            ar = this.artifactResolver.resolveArtifact(project.getProjectBuildingRequest(), (ArtifactCoordinate)coordinate);
        }
        catch (ArtifactResolverException e) {
            throw new MavenExecutionException("Failed to resolve artifact " + coordinate, (Throwable)e);
        }
        return ar.getArtifact();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isOSGiBundle(Artifact artifact) {
        try (JarFile jarFile = new JarFile(artifact.getFile());){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                boolean bl2 = false;
                return bl2;
            }
            boolean bl = manifest.getMainAttributes().getValue("Bundle-SymbolicName") != null;
            return bl;
        }
        catch (IOException e) {
            this.logger.warn("Failed to check if " + artifact.getFile() + " is OSGi bundle!", (Throwable)e);
            return false;
        }
    }

    public void addToDependencyManagement(MavenProject project, Dependency dependency) {
        if (project.getModel().getDependencyManagement() == null) {
            project.getModel().setDependencyManagement(new DependencyManagement());
        }
        project.getModel().getDependencyManagement().addDependency(dependency);
    }

    private String toId(Dependency dependency) {
        return dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion();
    }
}

