/*
 * Decompiled with CFR 0.152.
 */
package org.em.maven.plugin;

import aQute.libg.tuple.Pair;
import com.commsen.em.contract.storage.NitriteContractStorage;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.beryx.textio.InputReader;
import org.beryx.textio.StringInputReader;
import org.beryx.textio.TextIO;
import org.beryx.textio.TextIoFactory;
import org.codehaus.plexus.component.annotations.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="addContractors", requiresProject=false)
public class AddContractorsMojo
extends AbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger(AddContractorsMojo.class);
    private TextIO textIO = TextIoFactory.getTextIO();
    @Requirement
    private ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;

    public void execute() throws MojoExecutionException {
        String gav = (String)((StringInputReader)((StringInputReader)this.textIO.newStringInputReader().withDefaultValue((Object)"com.commsen.em.contractors")).withValueChecker((InputReader.ValueChecker)new InputReader.ValueChecker<String>(){

            public List<String> getErrorMessages(String val, String itemName) {
                String[] vals;
                if (val != null && (vals = val.split(":")).length > 0 && vals.length <= 3) {
                    return null;
                }
                return Arrays.asList("Please provide valid Maven coordinates. It could be 'group' or 'group:artifact' or 'group:artifact:version'!");
            }
        })).read(new String[]{"Maven group / group:artifact / group:artifact:version "});
        String[] vals = gav.split(":");
        String searchString = null;
        switch (vals.length) {
            case 1: {
                searchString = "g:\"" + vals[0] + "\"+AND+p:\"jar\"";
                break;
            }
            case 2: {
                searchString = "g:\"" + vals[0] + "\"+AND+a:\"" + vals[1] + "\"+AND+p:\"jar\"";
            }
        }
        LinkedList<Pair<String, URL>> artifacts = new LinkedList<Pair<String, URL>>();
        try {
            if (vals.length < 3) {
                URL u = new URL("http://search.maven.org/solrsearch/select?q=" + searchString + "&core=gav&rows=50&wt=json");
                try (BufferedReader br = new BufferedReader(new InputStreamReader(u.openStream(), StandardCharsets.UTF_8));){
                    Gson gson = new Gson();
                    JsonReader jsonReader = gson.newJsonReader((Reader)br);
                    JsonParser parser = new JsonParser();
                    JsonObject jsonObj = (JsonObject)parser.parse(jsonReader);
                    int resultCount = jsonObj.getAsJsonObject("response").getAsJsonPrimitive("numFound").getAsInt();
                    if (resultCount > 100) {
                        throw new MojoExecutionException("Found " + resultCount + " matches! Please refine your search.");
                    }
                    if (resultCount > 20) {
                        logger.warn("Found " + resultCount + " matches! It may take very long time to process them.");
                    }
                    JsonArray docs = jsonObj.getAsJsonObject("response").getAsJsonArray("docs");
                    for (JsonElement jsonElement : docs) {
                        JsonObject entry = jsonElement.getAsJsonObject();
                        artifacts.add(this.toPair(entry.get("id").getAsString(), entry.get("g").getAsString(), entry.get("a").getAsString(), entry.get("v").getAsString()));
                    }
                }
            } else {
                artifacts.add(this.toPair(gav, vals[0], vals[1], vals[2]));
            }
            try (NitriteContractStorage contractStorage = new NitriteContractStorage();){
                File f = new File("/tmp/.em");
                f.mkdirs();
                f = new File(f, "tmp.jar");
                f.deleteOnExit();
                for (Pair pair : artifacts) {
                    logger.debug("Downloading " + pair.getSecond());
                    try {
                        FileOutputStream fos = new FileOutputStream(f);
                        Throwable throwable = null;
                        try {
                            ReadableByteChannel rbc = Channels.newChannel(((URL)pair.getSecond()).openStream());
                            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                            boolean added = contractStorage.saveContractor(f, (String)pair.getFirst());
                            logger.info((added ? "[\u221a] " : "[X] ") + (String)pair.getFirst());
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (fos == null) continue;
                            if (throwable != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            fos.close();
                        }
                    }
                    catch (IOException e) {
                        logger.warn("Error while processing " + (String)pair.getFirst() + "!", (Throwable)e);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while trying to register contractors!", (Exception)e);
        }
    }

    private Pair<String, URL> toPair(String id, String group, String artifact, String version) throws MalformedURLException {
        URL url = new URL("http://repo1.maven.org/maven2/" + group.replace(".", "/") + "/" + artifact + "/" + version + "/" + artifact + "-" + version + ".jar");
        return new Pair((Object)id, (Object)url);
    }
}

