/*
 * Decompiled with CFR 0.152.
 */
package org.em.maven.plugin;

import aQute.bnd.build.Workspace;
import aQute.bnd.maven.lib.resolve.DependencyResolver;
import aQute.bnd.repository.fileset.FileSetRepository;
import aQute.bnd.service.RepositoryPlugin;
import aQute.lib.io.IO;
import aQute.service.reporter.Reporter;
import biz.aQute.resolve.Bndrun;
import biz.aQute.resolve.ResolveProcess;
import com.commsen.em.contract.storage.NitriteContractStorage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.em.maven.plugin.UnsatisfiedRequirementsException;
import org.osgi.resource.Requirement;
import org.osgi.service.resolver.ResolutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="export", defaultPhase=LifecyclePhase.PACKAGE)
public class ExportMojo
extends aQute.bnd.maven.export.plugin.ExportMojo {
    private static final Logger logger = LoggerFactory.getLogger(ExportMojo.class);
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession repositorySession;
    @Parameter(readonly=true, required=true)
    private List<File> bndruns;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File targetDir;
    @Parameter(readonly=true, required=false)
    private List<File> bundles;
    @Parameter(defaultValue="true")
    private boolean useMavenDependencies;
    @Parameter(defaultValue="false")
    private boolean resolve;
    @Parameter(defaultValue="true")
    private boolean failOnChanges;
    @Parameter(defaultValue="false")
    private boolean bundlesOnly;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    private int errors = 0;
    @Component
    private RepositorySystem system;
    @Component
    private ProjectDependenciesResolver resolver;

    public void execute() throws MojoExecutionException {
        try {
            DependencyResolver dependencyResolver = new DependencyResolver(this.project, this.repositorySession, this.resolver, this.system);
            FileSetRepository fileSetRepository = dependencyResolver.getFileSetRepository(this.project.getName(), this.bundles, this.useMavenDependencies);
            for (File runFile : this.bndruns) {
                this.export(runFile, fileSetRepository);
            }
        }
        catch (Exception e) {
            Throwable t = e;
            do {
                System.out.println("exception: " + t.getClass());
            } while (!t.getClass().isAssignableFrom(ResolutionException.class) && (t = t.getCause()).getCause() != null);
            ResolutionException rex = (ResolutionException)t;
            System.out.println("ResolutionException:" + rex);
            UnsatisfiedRequirementsException.Builder exBuilder = new UnsatisfiedRequirementsException.Builder();
            try (NitriteContractStorage contractStorage = new NitriteContractStorage();){
                for (Requirement requirement : rex.getUnresolvedRequirements()) {
                    if (!rex.getMessage().contains(requirement.toString())) continue;
                    Set found = contractStorage.getContractors(requirement);
                    if (found != null && !found.isEmpty()) {
                        found.forEach(contractor -> exBuilder.add(requirement.toString(), (String)contractor));
                        continue;
                    }
                    exBuilder.add(requirement.toString());
                }
            }
            catch (IOException ioex) {
                logger.warn("Can not find hits in local storage!", (Throwable)e);
                for (Requirement requirement : rex.getUnresolvedRequirements()) {
                    if (!rex.getMessage().contains(requirement.toString())) continue;
                    exBuilder.add(requirement.toString());
                }
            }
            UnsatisfiedRequirementsException ure = exBuilder.build();
            throw new MojoExecutionException(ure.getMessage(), (Exception)ure);
        }
        if (this.errors > 0) {
            throw new MojoExecutionException(this.errors + " errors found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export(File runFile, FileSetRepository fileSetRepository) throws Exception {
        if (!runFile.exists()) {
            logger.error("Could not find bnd run file {}", (Object)runFile);
            ++this.errors;
            return;
        }
        String bndrun = this.getNamePart(runFile);
        File temporaryDir = new File(this.targetDir, "tmp/export/" + bndrun);
        File cnf = new File(temporaryDir, "cnf");
        IO.mkdirs((File)cnf);
        try (Bndrun run = Bndrun.createBndrun(null, (File)runFile);){
            run.setBase(temporaryDir);
            Workspace workspace = run.getWorkspace();
            workspace.setBuildDir(cnf);
            workspace.setOffline(this.session.getSettings().isOffline());
            workspace.addBasicPlugin((Object)fileSetRepository);
            for (RepositoryPlugin repo : workspace.getRepositories()) {
                repo.list(null);
            }
            run.getInfo((Reporter)workspace);
            this.report(run);
            if (!run.isOk()) {
                return;
            }
            if (this.resolve) {
                try {
                    String runBundles = run.resolve(this.failOnChanges, false);
                    if (!run.isOk()) {
                        return;
                    }
                    run.setProperty("-runbundles", runBundles);
                }
                catch (ResolutionException re) {
                    logger.error("Unresolved requirements: {}", (Object)ResolveProcess.format((Collection)re.getUnresolvedRequirements()));
                    throw re;
                }
                finally {
                    this.report(run);
                }
            }
            try {
                if (this.bundlesOnly) {
                    File runbundlesDir = new File(this.targetDir, "export/" + bndrun);
                    IO.mkdirs((File)runbundlesDir);
                    run.exportRunbundles(null, runbundlesDir);
                } else {
                    File executableJar = new File(this.targetDir, bndrun + ".jar");
                    run.export(null, false, executableJar);
                }
            }
            finally {
                this.report(run);
            }
        }
    }

    private String getNamePart(File runFile) {
        String nameExt = runFile.getName();
        int pos = nameExt.lastIndexOf(46);
        return pos > 0 ? nameExt.substring(0, pos) : nameExt;
    }

    private void report(Bndrun run) {
        for (String warning : run.getWarnings()) {
            logger.warn("Warning : {}", (Object)warning);
        }
        for (String error : run.getErrors()) {
            logger.error("Error   : {}", (Object)error);
            ++this.errors;
        }
    }
}

