/*
 * Decompiled with CFR 0.152.
 */
package com.commsen.maven.plugin.bomhelper;

import com.commsen.maven.plugin.bomhelper.Gav;
import com.commsen.maven.plugin.bomhelper.PomChangingAbstractMojo;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Mojo(name="fromJars", requiresProject=true, defaultPhase=LifecyclePhase.VALIDATE)
public class BomFromJarsMojo
extends PomChangingAbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger(BomFromJarsMojo.class);
    @Parameter(defaultValue="${project.basedir}/lib", property="bom-helper.jarsFolder")
    private File librariesFolder;
    @Parameter(defaultValue="false", property="bom-helper.allOrNothing")
    protected boolean allOrNothing;
    @Parameter(defaultValue="false", property="bom-helper.recursive")
    protected boolean recursive;
    @Parameter(defaultValue="100", property="bom-helper.recursiveDepth")
    protected int folderDepth;

    public void execute() throws MojoExecutionException {
        LinkedList<Properties> mavenCoordinates = new LinkedList<Properties>();
        TreeSet<String> missingMavenData = new TreeSet<String>();
        try {
            logger.debug("Scanning `" + this.librariesFolder.getAbsolutePath() + "` for jars!");
            this.parseFolder(this.librariesFolder, mavenCoordinates, missingMavenData);
            if (!missingMavenData.isEmpty()) {
                missingMavenData.forEach(f -> logger.warn("File `" + f + "` does not contain Maven metadata and can not be automatically added to dependency management entries!"));
                if (this.allOrNothing) {
                    throw new MojoExecutionException("Property `allOrNoting` is `true` but some jars could not be converted to dependency management entires!");
                }
            }
            if (!mavenCoordinates.isEmpty()) {
                Node dependenciesNode;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(this.project.getFile());
                XPath xPath = XPathFactory.newInstance().newXPath();
                Node dependencyManagementNode = (Node)xPath.evaluate("//dependencyManagement", doc, XPathConstants.NODE);
                if (dependencyManagementNode == null) {
                    logger.debug("Creating dependencyManagement node!");
                    dependencyManagementNode = doc.createElement("dependencyManagement");
                    doc.getFirstChild().appendChild(dependencyManagementNode);
                }
                if ((dependenciesNode = (Node)xPath.evaluate("//dependencyManagement/dependencies", doc, XPathConstants.NODE)) == null) {
                    logger.debug("Creating dependencies node!");
                    dependenciesNode = doc.createElement("dependencies");
                    dependencyManagementNode.appendChild(dependenciesNode);
                }
                Set currentGavs = this.project.getDependencyManagement().getDependencies().stream().map(d -> new Gav(d.getGroupId(), d.getArtifactId(), d.getVersion())).collect(Collectors.toSet());
                boolean added = false;
                for (Properties p : mavenCoordinates) {
                    Gav gav = new Gav(p.getProperty("groupId"), p.getProperty("artifactId"), p.getProperty("version"));
                    if (!currentGavs.contains(gav)) {
                        Element dependency = doc.createElement("dependency");
                        dependency.appendChild(this.createNode(doc, "groupId", gav.g));
                        dependency.appendChild(this.createNode(doc, "artifactId", gav.a));
                        dependency.appendChild(this.createNode(doc, "version", gav.v));
                        dependenciesNode.appendChild(dependency);
                        added = true;
                        continue;
                    }
                    logger.debug("Skipping " + gav + " as it already is in dependency management!");
                }
                if (added) {
                    this.savePom(doc);
                } else {
                    logger.info("Pom will not be changed. All files with Maven matada alredy have dependency management entries");
                }
            } else {
                logger.info("No jar files with Maven matada were found!");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("An error occured while building BOM's dependency management!", e);
        }
    }

    private void parseFolder(File folder, List<Properties> mavenCoordinates, Set<String> missingMavenData) throws IOException {
        int maxDepth = 1;
        if (this.recursive) {
            maxDepth = this.folderDepth;
        }
        mavenCoordinates.addAll(Files.walk(folder.toPath(), maxDepth, FileVisitOption.FOLLOW_LINKS).map(Path::toFile).filter(f -> f.isFile()).filter(f -> f.getName().endsWith(".jar")).map(this::toJarFile).filter(Objects::nonNull).map(jar -> this.toMavenProperties((JarFile)jar, missingMavenData)).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private Properties toMavenProperties(JarFile jar, Set<String> missingMavenData) {
        Properties properties = null;
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            if (!jarEntry.getName().matches("^META-INF/maven/.*/pom\\.properties$")) continue;
            try {
                properties = new Properties();
                properties.load(jar.getInputStream(jarEntry));
                break;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (properties == null) {
            missingMavenData.add(jar.getName());
        }
        return properties;
    }

    private JarFile toJarFile(File f) {
        try {
            return new JarFile(f);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Node createNode(Document doc, String name, String text) {
        Element n = doc.createElement(name);
        n.setTextContent(text);
        return n;
    }
}

