/*
 * Decompiled with CFR 0.152.
 */
package com.commsen.maven.plugin.bomhelper;

import com.commsen.maven.plugin.bomhelper.BomHelperAbstractMojo;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="resolve", requiresProject=true, defaultPhase=LifecyclePhase.VALIDATE)
public class BomResolveMojo
extends BomHelperAbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger(BomResolveMojo.class);
    @Parameter
    protected Map<String, String> typeExtensions;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    protected List<ArtifactRepository> remoteRepositories;
    @Component
    private ArtifactResolver artifactResolver;

    public void execute() throws MojoExecutionException {
        DependencyManagement dependencyManagement = this.project.getDependencyManagement();
        if (dependencyManagement == null) {
            logger.info("No BOM dependencies found! Nothing to resolve!");
            return;
        }
        List bomDependencies = dependencyManagement.getDependencies();
        HashSet<String> failedArtifacts = new HashSet<String>();
        ProjectBuildingRequest projectBuildingRequest = this.newResolveArtifactProjectBuildingRequest();
        for (Dependency dependency : bomDependencies) {
            DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
            coordinate.setGroupId(dependency.getGroupId());
            coordinate.setArtifactId(dependency.getArtifactId());
            coordinate.setVersion(dependency.getVersion());
            coordinate.setExtension(this.typeToExtension(dependency.getType()));
            coordinate.setClassifier(dependency.getClassifier());
            try {
                this.artifactResolver.resolveArtifact(projectBuildingRequest, (ArtifactCoordinate)coordinate);
            }
            catch (ArtifactResolverException e) {
                failedArtifacts.add(coordinate.toString());
                logger.error("Failed to resolve artifact " + coordinate, (Throwable)e);
            }
        }
        if (!failedArtifacts.isEmpty()) {
            throw new MojoExecutionException("The following dependencies found in <dependencyManagement> can not be resolved: \n - " + String.join((CharSequence)"\n - ", failedArtifacts));
        }
    }

    private String typeToExtension(String type) {
        if (this.typeExtensions == null || !this.typeExtensions.containsKey(type)) {
            return type;
        }
        return this.typeExtensions.get(type);
    }

    private ProjectBuildingRequest newResolveArtifactProjectBuildingRequest() {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setRemoteRepositories(this.remoteRepositories);
        return buildingRequest;
    }
}

