/*
 * Decompiled with CFR 0.152.
 */
package com.composables.core;

import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.internal.StabilityInferred;
import com.composables.core.ScrollAreaKt;
import com.composables.core.ScrollAreaState;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0012\b!\u0018\u00002\u00020\u0001:\u0001$B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H$J\b\u0010\u0006\u001a\u00020\u0007H$J\b\u0010\b\u001a\u00020\u0007H$J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u00a4@\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u00a4@\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H$J\u0016\u0010!\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\"J\u0016\u0010#\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0013H\u0082@\u00a2\u0006\u0002\u0010\"R\u0012\u0010\u0014\u001a\u00020\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R!\u0010\u0012\u001a\u00020\u00138BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u0012\u0004\b\u0017\u0010\u0003\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R\u0014\u0010\f\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0019R\u0014\u0010\u001f\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0019\u00a8\u0006%"}, d2={"Lcom/composables/core/LazyLineContentScrollAreaState;", "Lcom/composables/core/ScrollAreaState;", "<init>", "()V", "firstVisibleLine", "Lcom/composables/core/LazyLineContentScrollAreaState$VisibleLine;", "totalLineCount", "", "contentPadding", "snapToLine", "", "lineIndex", "scrollOffset", "(IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "scrollBy", "value", "", "(FLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "averageVisibleLineSize", "", "lineSpacing", "getLineSpacing", "()I", "getAverageVisibleLineSize$annotations", "getAverageVisibleLineSize", "()D", "averageVisibleLineSize$delegate", "Landroidx/compose/runtime/State;", "averageVisibleLineSizeWithSpacing", "getAverageVisibleLineSizeWithSpacing", "getScrollOffset", "contentSize", "getContentSize", "scrollTo", "(DLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "snapTo", "VisibleLine", "core_release"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nScrollArea.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScrollArea.kt\ncom/composables/core/LazyLineContentScrollAreaState\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,1062:1\n81#2:1063\n*S KotlinDebug\n*F\n+ 1 ScrollArea.kt\ncom/composables/core/LazyLineContentScrollAreaState\n*L\n761#1:1063\n*E\n"})
public abstract class LazyLineContentScrollAreaState
implements ScrollAreaState {
    @NotNull
    private final State averageVisibleLineSize$delegate = SnapshotStateKt.derivedStateOf(() -> LazyLineContentScrollAreaState.averageVisibleLineSize_delegate$lambda$0(this));
    public static final int $stable;

    @Nullable
    protected abstract VisibleLine firstVisibleLine();

    protected abstract int totalLineCount();

    protected abstract int contentPadding();

    @Nullable
    protected abstract Object snapToLine(int var1, int var2, @NotNull Continuation<? super Unit> var3);

    @Nullable
    protected abstract Object scrollBy(float var1, @NotNull Continuation<? super Unit> var2);

    protected abstract double averageVisibleLineSize();

    protected abstract int getLineSpacing();

    /*
     * WARNING - void declaration
     */
    private final double getAverageVisibleLineSize() {
        void $this$getValue$iv;
        State state = this.averageVisibleLineSize$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).doubleValue();
    }

    private static /* synthetic */ void getAverageVisibleLineSize$annotations() {
    }

    private final double getAverageVisibleLineSizeWithSpacing() {
        return this.getAverageVisibleLineSize() + (double)this.getLineSpacing();
    }

    @Override
    public double getScrollOffset() {
        double d;
        VisibleLine firstVisibleLine = this.firstVisibleLine();
        if (firstVisibleLine == null) {
            d = 0.0;
        } else {
            int index = firstVisibleLine.getIndex();
            int offset = firstVisibleLine.getOffset();
            d = (double)index * this.getAverageVisibleLineSizeWithSpacing() - (double)offset;
        }
        return d;
    }

    @Override
    public double getContentSize() {
        int totalLineCount = this.totalLineCount();
        return this.getAverageVisibleLineSize() * (double)totalLineCount + (double)(this.getLineSpacing() * RangesKt.coerceAtLeast((int)(totalLineCount - 1), (int)0)) + (double)this.contentPadding();
    }

    @Override
    @Nullable
    public Object scrollTo(double scrollOffset, @NotNull Continuation<? super Unit> $completion) {
        return LazyLineContentScrollAreaState.scrollTo$suspendImpl(this, scrollOffset, $completion);
    }

    static /* synthetic */ Object scrollTo$suspendImpl(LazyLineContentScrollAreaState $this, double scrollOffset, Continuation<? super Unit> $completion) {
        double distance = scrollOffset - $this.getScrollOffset();
        if (Math.abs(distance) <= $this.getViewportSize()) {
            Object object = $this.scrollBy((float)distance, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        Object object = $this.snapTo(scrollOffset, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object snapTo(double scrollOffset, Continuation<? super Unit> $completion) {
        double scrollOffsetCoerced = RangesKt.coerceIn((double)scrollOffset, (double)0.0, (double)ScrollAreaKt.getMaxScrollOffset(this));
        int index = RangesKt.coerceAtMost((int)RangesKt.coerceAtLeast((int)((int)(scrollOffsetCoerced / this.getAverageVisibleLineSizeWithSpacing())), (int)0), (int)(this.totalLineCount() - 1));
        int offset = RangesKt.coerceAtLeast((int)((int)(scrollOffsetCoerced - (double)index * this.getAverageVisibleLineSizeWithSpacing())), (int)0);
        Object object = this.snapToLine(index, offset, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final double averageVisibleLineSize_delegate$lambda$0(LazyLineContentScrollAreaState this$0) {
        return this$0.totalLineCount() == 0 ? 0.0 : this$0.averageVisibleLineSize();
    }

    public static final /* synthetic */ Object access$snapTo(LazyLineContentScrollAreaState $this, double scrollOffset, Continuation $completion) {
        return $this.snapTo(scrollOffset, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lcom/composables/core/LazyLineContentScrollAreaState$VisibleLine;", "", "index", "", "offset", "<init>", "(II)V", "getIndex", "()I", "getOffset", "core_release"})
    @StabilityInferred(parameters=1)
    public static final class VisibleLine {
        private final int index;
        private final int offset;
        public static final int $stable;

        public VisibleLine(int index, int offset) {
            this.index = index;
            this.offset = offset;
        }

        public final int getIndex() {
            return this.index;
        }

        public final int getOffset() {
            return this.offset;
        }
    }
}

