/*
 * Decompiled with CFR 0.152.
 */
package com.composables.core.androidx.compose.foundation.gestures;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.input.pointer.PointerInputChange;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\b\u001a\u00020\t*\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0011\u0010\r\u001a\u00020\t*\u00020\n\u00a2\u0006\u0004\b\u000e\u0010\fJ\u001d\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t\u00a2\u0006\u0002\b\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u0017\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/composables/core/androidx/compose/foundation/gestures/TouchSlopDetector;", "", "orientation", "Landroidx/compose/foundation/gestures/Orientation;", "<init>", "(Landroidx/compose/foundation/gestures/Orientation;)V", "getOrientation", "()Landroidx/compose/foundation/gestures/Orientation;", "mainAxis", "", "Landroidx/compose/ui/geometry/Offset;", "mainAxis-k-4lQ0M", "(J)F", "crossAxis", "crossAxis-k-4lQ0M", "totalPositionChange", "J", "addPointerInputChange", "dragEvent", "Landroidx/compose/ui/input/pointer/PointerInputChange;", "touchSlop", "addPointerInputChange-GcwITfU", "reset", "", "calculatePostSlopOffset", "calculatePostSlopOffset-tuRUvjQ", "(F)J", "core"})
final class TouchSlopDetector {
    @Nullable
    private final Orientation orientation;
    private long totalPositionChange;

    public TouchSlopDetector(@Nullable Orientation orientation) {
        this.orientation = orientation;
        this.totalPositionChange = Offset.Companion.getZero-F1C5BW0();
    }

    public /* synthetic */ TouchSlopDetector(Orientation orientation, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            orientation = null;
        }
        this(orientation);
    }

    @Nullable
    public final Orientation getOrientation() {
        return this.orientation;
    }

    public final float mainAxis-k-4lQ0M(long $this$mainAxis_u2dk_u2d4lQ0M) {
        return this.orientation == Orientation.Horizontal ? Offset.getX-impl((long)$this$mainAxis_u2dk_u2d4lQ0M) : Offset.getY-impl((long)$this$mainAxis_u2dk_u2d4lQ0M);
    }

    public final float crossAxis-k-4lQ0M(long $this$crossAxis_u2dk_u2d4lQ0M) {
        return this.orientation == Orientation.Horizontal ? Offset.getY-impl((long)$this$crossAxis_u2dk_u2d4lQ0M) : Offset.getX-impl((long)$this$crossAxis_u2dk_u2d4lQ0M);
    }

    @Nullable
    public final Offset addPointerInputChange-GcwITfU(@NotNull PointerInputChange dragEvent, float touchSlop) {
        Intrinsics.checkNotNullParameter((Object)dragEvent, (String)"dragEvent");
        long currentPosition = dragEvent.getPosition-F1C5BW0();
        long previousPosition = dragEvent.getPreviousPosition-F1C5BW0();
        long positionChange = Offset.minus-MK-Hz9U((long)currentPosition, (long)previousPosition);
        this.totalPositionChange = Offset.plus-MK-Hz9U((long)this.totalPositionChange, (long)positionChange);
        float inDirection = this.orientation == null ? Offset.getDistance-impl((long)this.totalPositionChange) : Math.abs(this.mainAxis-k-4lQ0M(this.totalPositionChange));
        boolean hasCrossedSlop = inDirection >= touchSlop;
        return hasCrossedSlop ? Offset.box-impl((long)this.calculatePostSlopOffset-tuRUvjQ(touchSlop)) : null;
    }

    public final void reset() {
        this.totalPositionChange = Offset.Companion.getZero-F1C5BW0();
    }

    private final long calculatePostSlopOffset-tuRUvjQ(float touchSlop) {
        long l;
        if (this.orientation == null) {
            long touchSlopOffset = Offset.times-tuRUvjQ((long)Offset.div-tuRUvjQ((long)this.totalPositionChange, (float)Offset.getDistance-impl((long)this.totalPositionChange)), (float)touchSlop);
            l = Offset.minus-MK-Hz9U((long)this.totalPositionChange, (long)touchSlopOffset);
        } else {
            float finalMainAxisChange = this.mainAxis-k-4lQ0M(this.totalPositionChange) - Math.signum(this.mainAxis-k-4lQ0M(this.totalPositionChange)) * touchSlop;
            float finalCrossAxisChange = this.crossAxis-k-4lQ0M(this.totalPositionChange);
            l = this.orientation == Orientation.Horizontal ? OffsetKt.Offset((float)finalMainAxisChange, (float)finalCrossAxisChange) : OffsetKt.Offset((float)finalCrossAxisChange, (float)finalMainAxisChange);
        }
        return l;
    }

    public TouchSlopDetector() {
        this(null, 1, null);
    }
}

