/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.processor;

import com.composum.sling.clientlibs.handle.ClientlibElement;
import com.composum.sling.clientlibs.handle.ClientlibLink;
import com.composum.sling.clientlibs.processor.RendererContext;
import com.composum.sling.clientlibs.processor.RenderingVisitor;
import com.composum.sling.clientlibs.service.ClientlibRenderer;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientlibRenderer
implements ClientlibRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClientlibRenderer.class);

    protected abstract String getLinkTemplate();

    @Override
    public void renderClientlibLinks(ClientlibElement clientlib, Writer writer, SlingHttpServletRequest request, RendererContext context) throws IOException, RepositoryException {
        this.renderClientlibLinks(clientlib, writer, request, context, this.getLinkTemplate());
    }

    protected void renderClientlibLinks(ClientlibElement clientlib, Writer writer, SlingHttpServletRequest request, RendererContext context, String template) throws IOException, RepositoryException {
        RenderingVisitor visitor = new RenderingVisitor(clientlib, context).execute();
        List<ClientlibLink> links = visitor.getLinksToRender();
        LOG.debug("Links to render: {}", links);
        int i = 0;
        while (i < links.size()) {
            ClientlibLink link = links.get(i);
            String rel = link.properties.get("rel");
            String renderedLink = MessageFormat.format(template, link.getUrl(request, context), rel != null ? rel : "");
            LOG.trace("Rendered link {}", (Object)renderedLink);
            writer.append(renderedLink);
            if (++i >= links.size()) continue;
            writer.append('\n');
        }
    }
}

