/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.processor;

import com.composum.sling.clientlibs.handle.Clientlib;
import com.composum.sling.clientlibs.handle.ClientlibCategory;
import com.composum.sling.clientlibs.handle.ClientlibElement;
import com.composum.sling.clientlibs.handle.ClientlibExternalUri;
import com.composum.sling.clientlibs.handle.ClientlibFile;
import com.composum.sling.clientlibs.handle.ClientlibLink;
import com.composum.sling.clientlibs.handle.ClientlibRef;
import com.composum.sling.clientlibs.handle.ClientlibResourceFolder;
import com.composum.sling.clientlibs.handle.ClientlibVisitor;
import com.composum.sling.clientlibs.service.ClientlibService;
import com.composum.sling.core.ResourceHandle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import org.apache.commons.codec.binary.Base64;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientlibVisitor
implements ClientlibVisitor {
    public static final Pattern HASH_PATTERN = Pattern.compile("[0-9a-zA-Z_-]{11}");
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractClientlibVisitor.class);
    protected final ClientlibService service;
    protected final ResourceResolver resolver;
    protected final LinkedHashSet<ClientlibLink> processedElements;
    protected final ClientlibElement owner;
    protected long embeddedHash = 0L;
    protected boolean hasEmbeddedFiles = false;

    @Override
    public ClientlibElement getOwner() {
        return this.owner;
    }

    @Override
    public ClientlibVisitor execute() throws IOException, RepositoryException {
        this.owner.accept(this, ClientlibVisitor.VisitorMode.DEPENDS, null);
        return this;
    }

    protected AbstractClientlibVisitor(ClientlibElement owner, ClientlibService service, ResourceResolver resolver, LinkedHashSet<ClientlibLink> processedElements) {
        this.service = service;
        this.resolver = resolver;
        this.owner = owner;
        this.processedElements = null != processedElements ? processedElements : new LinkedHashSet();
    }

    protected ClientlibVisitor getVisitorFor(ClientlibVisitor.VisitorMode mode, ClientlibElement element) {
        if (ClientlibVisitor.VisitorMode.EMBEDDED == mode) {
            return this;
        }
        if (element instanceof ClientlibCategory || element instanceof Clientlib) {
            return this.createVisitorFor(element);
        }
        return this;
    }

    protected abstract ClientlibVisitor createVisitorFor(ClientlibElement var1);

    @Override
    public void visit(ClientlibCategory category, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) throws IOException, RepositoryException {
        LOG.trace(">>> {} {}", (Object)mode, (Object)category);
        if (this.isNotProcessed(category.getRef())) {
            for (Clientlib clientlib : category.clientlibs) {
                clientlib.accept(this, ClientlibVisitor.VisitorMode.EMBEDDED, null);
            }
            this.action(category, mode, parent);
            this.markAsProcessed(category.makeLink(), parent, mode);
        } else {
            this.alreadyProcessed(category.getRef(), mode, parent);
        }
        LOG.trace("<<< {} => {}", (Object)category, (Object)this.hasEmbeddedFiles);
    }

    @Override
    public void visit(Clientlib clientlib, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) throws IOException, RepositoryException {
        LOG.trace(">>> {} {}", (Object)mode, (Object)clientlib);
        if (this.isNotProcessed(clientlib.getRef())) {
            this.updateHash(clientlib.resource.getPath(), clientlib.resource.getLastModified());
            ClientlibResourceFolder folder = clientlib.getResourceFolder();
            if (null != folder) {
                folder.accept(this, mode, null);
            }
            this.action(clientlib, mode, parent);
            this.markAsProcessed(clientlib.makeLink(), parent, mode);
        } else {
            this.alreadyProcessed(clientlib.getRef(), mode, parent);
        }
        LOG.trace("<<< {} => {}", (Object)clientlib, (Object)this.hasEmbeddedFiles);
    }

    @Override
    public void visit(ClientlibResourceFolder folder, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) throws IOException, RepositoryException {
        LOG.trace(">>> {} {}", (Object)mode, (Object)folder);
        this.updateHash(folder.resource.getPath(), folder.resource.getLastModified());
        for (ClientlibRef dependency : folder.getDependencies()) {
            this.resolveAndAccept(dependency, ClientlibVisitor.VisitorMode.DEPENDS, folder);
        }
        boolean embedding = this.supportsEmbedding(folder.getType()) && !folder.getExpanded();
        ClientlibVisitor.VisitorMode embeddingMode = embedding ? ClientlibVisitor.VisitorMode.EMBEDDED : ClientlibVisitor.VisitorMode.DEPENDS;
        for (ClientlibRef embedded : folder.getEmbedded()) {
            this.resolveAndAccept(embedded, embeddingMode, folder);
        }
        for (ClientlibElement child : this.removeMinificationDuplicates(folder.getChildren())) {
            child.accept(this.getVisitorFor(mode, child), embeddingMode, folder);
        }
        this.action(folder, mode, parent);
        LOG.trace("<<< {} => {}", (Object)folder, (Object)this.hasEmbeddedFiles);
    }

    protected List<ClientlibElement> removeMinificationDuplicates(List<ClientlibElement> children) {
        HashSet<String> duplicatesToRemove = new HashSet<String>();
        for (ClientlibElement child : children) {
            if (!(child instanceof ClientlibFile)) continue;
            ClientlibFile file = (ClientlibFile)child;
            ResourceHandle resource = file.handle.getResource();
            Resource minified = this.service.getMinifiedSibling((Resource)resource);
            if (minified.getPath().equals(resource.getPath())) continue;
            if (this.service.getClientlibConfig().clientlibs_minified_use() && !this.service.getClientlibConfig().debug()) {
                duplicatesToRemove.add(resource.getPath());
                continue;
            }
            duplicatesToRemove.add(minified.getPath());
        }
        ArrayList<ClientlibElement> result = new ArrayList<ClientlibElement>();
        for (ClientlibElement child : children) {
            if (child instanceof ClientlibFile) {
                ClientlibFile file = (ClientlibFile)child;
                if (duplicatesToRemove.contains(file.handle.getPath())) continue;
                result.add(child);
                continue;
            }
            result.add(child);
        }
        return result;
    }

    @Override
    public void visit(ClientlibFile file, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) throws RepositoryException, IOException {
        LOG.trace(">>> {} {}", (Object)mode, (Object)file);
        if (this.isNotProcessed(file.getRef())) {
            if (ClientlibVisitor.VisitorMode.EMBEDDED == mode) {
                this.updateHash(file.handle.getPath(), file.handle.getLastModified());
                this.hasEmbeddedFiles = true;
            }
            this.action(file, mode, parent);
            this.markAsProcessed(file.makeLink(), parent, mode);
        } else {
            this.alreadyProcessed(file.getRef(), mode, parent);
        }
        LOG.trace("<<< {} {}", (Object)mode, (Object)file);
    }

    @Override
    public void visit(ClientlibExternalUri externalUri, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) {
        LOG.trace(">>> {} {}", (Object)mode, (Object)externalUri);
        if (this.isNotProcessed(externalUri.getRef())) {
            this.action(externalUri, mode, parent);
            this.markAsProcessed(externalUri.makeLink(), parent, mode);
        } else {
            this.alreadyProcessed(externalUri.getRef(), mode, parent);
        }
        LOG.trace("<<< {} {}", (Object)mode, (Object)externalUri);
    }

    protected void resolveAndAccept(ClientlibRef ref, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder folder) throws IOException, RepositoryException {
        if (this.isNotProcessed(ref)) {
            ClientlibElement element = this.service.resolve(ref, this.resolver);
            if (null != element) {
                element.accept(this.getVisitorFor(mode, element), mode, folder);
            } else {
                this.notPresent(ref, mode, folder);
            }
        } else {
            this.alreadyProcessed(ref, mode, folder);
        }
    }

    protected void alreadyProcessed(ClientlibRef ref, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder folder) {
        LOG.trace("Already processed: {} referenced from {}", (Object)ref, (Object)folder);
    }

    protected void notPresent(ClientlibRef ref, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Not present: {} {} referenced {} from {}", new Object[]{ref.optional ? " opt. " : " mand. ", ref, mode, parent});
        }
    }

    protected void updateHash(String path, Calendar updatetime) {
        LOG.trace("Hashing {} with {}", (Object)path, (Object)(null != updatetime ? updatetime.getTime() : null));
        for (char character : path.toCharArray()) {
            this.embeddedHash = this.embeddedHash * 92821L + (long)character;
        }
        if (null != updatetime) {
            this.embeddedHash = this.embeddedHash * 92821L + updatetime.getTimeInMillis();
        }
    }

    public String getHash() {
        long h = this.embeddedHash;
        byte[] b = new byte[8];
        for (int i = 0; i < 8; ++i) {
            b[i] = (byte)h;
            h >>= 8;
        }
        return Base64.encodeBase64URLSafeString((byte[])b);
    }

    protected boolean isNotProcessed(ClientlibRef ref) {
        return !ref.isSatisfiedby(this.processedElements);
    }

    protected void markAsProcessed(ClientlibLink link, ClientlibResourceFolder parent, ClientlibVisitor.VisitorMode visitorMode) {
        if (this.processedElements.contains(link)) {
            LOG.error("Bug: processed duplicate clientlib link: {} mode {} from {}", new Object[]{link, visitorMode, parent});
        } else {
            this.processedElements.add(link);
            LOG.debug("processed: {} mode {} parent {}", new Object[]{link, visitorMode, parent});
        }
    }

    public Set<ClientlibLink> getProcessedElements() {
        return this.processedElements;
    }

    protected boolean supportsEmbedding(Clientlib.Type type) {
        return Clientlib.Type.js == type || Clientlib.Type.css == type;
    }

    protected void action(ClientlibCategory clientlibCategory, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) {
    }

    protected void action(Clientlib clientlib, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) {
    }

    protected void action(ClientlibResourceFolder folder, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) {
    }

    protected void action(ClientlibFile file, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) throws RepositoryException, IOException {
    }

    protected void action(ClientlibExternalUri externalUri, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) {
    }
}

