/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core;

import com.composum.sling.core.ResourceHandle;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Composum Nodes (Core) Library Adapters :  Adapts Resources to ResourceHandles", "adaptables=org.apache.sling.api.resource.Resource", "adapters=com.composum.sling.core.ResourceHandle"})
public class CoreAdapterFactory
implements AdapterFactory {
    private static final Logger log = LoggerFactory.getLogger(CoreAdapterFactory.class);

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        if (adaptable instanceof ResourceHandle) {
            return CoreAdapterFactory.getAdapter((ResourceHandle)adaptable, type);
        }
        if (adaptable instanceof Resource) {
            return CoreAdapterFactory.getAdapter((Resource)adaptable, type);
        }
        log.warn("Unable to handle adaptable {}", (Object)adaptable.getClass().getName());
        return null;
    }

    protected static <AdapterType> AdapterType getAdapter(ResourceHandle resourceHandle, Class<AdapterType> type) {
        if (type == ResourceHandle.class) {
            return type.cast(resourceHandle);
        }
        log.info("Unable to adapt resource on {} to type {}", (Object)resourceHandle.getPath(), (Object)type.getName());
        return null;
    }

    protected static <AdapterType> AdapterType getAdapter(Resource resource, Class<AdapterType> type) {
        if (type == ResourceHandle.class) {
            return type.cast(new ResourceHandle(resource));
        }
        log.info("Unable to adapt resource on {} to type {}", (Object)resource.getPath(), (Object)type.getName());
        return null;
    }
}

