/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core;

import com.composum.sling.core.CoreConfiguration;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Objects;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={CoreConfiguration.class}, property={"service.description=Composum Nodes Core Configuration Service: the configuration service for all servlets in the core bundle"}, immediate=true)
@Designate(ocd=Configuration.class)
public class CoreConfigImpl
implements CoreConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(CoreConfigImpl.class);
    protected static final String DEFAULT_LOGOUTURL = "/system/sling/logout.html?logout=true&GLO=true";
    protected static final String DEFAULT_LOGGEDOUTURL = "/system/sling/form/login.html";
    protected static final String DEFAULT_LOGINURL = "/system/sling/form/login.html";
    private volatile Configuration config;
    private volatile Dictionary<String, Object> properties;

    @Override
    public String getComposumBase() {
        return this.getConfig().composum_base();
    }

    @NotNull
    private Configuration getConfig() {
        return Objects.requireNonNull(this.config, "CoreConfigImpl is not active");
    }

    @Override
    public Resource getErrorpage(SlingHttpServletRequest request, int status) {
        Resource errorpage = null;
        try {
            RequestPathInfo pathInfo;
            ResourceResolver resolver = request.getResourceResolver();
            String errorpagesPath = StringUtils.removeEnd((String)this.getConfig().errorpages_path(), (String)"/");
            if (StringUtils.isNotBlank((CharSequence)errorpagesPath) && "html".equalsIgnoreCase((pathInfo = request.getRequestPathInfo()).getExtension())) {
                if (errorpagesPath.startsWith("/")) {
                    errorpage = resolver.getResource(errorpagesPath + "/" + status);
                } else {
                    int lastSlash;
                    String path = pathInfo.getResourcePath();
                    Resource resource = resolver.resolve((HttpServletRequest)request, path);
                    path = resource.getPath();
                    while ((resource = resolver.getResource(path)) == null && (lastSlash = path.lastIndexOf(47)) > 2) {
                        path = path.substring(0, lastSlash);
                    }
                    while (errorpage == null && resource != null && !"/".equals(path = resource.getPath())) {
                        errorpage = resolver.getResource(path + "/" + errorpagesPath + "/" + status);
                        if (errorpage != null) continue;
                        resource = resource.getParent();
                    }
                }
            }
            String defaultErrorpages = StringUtils.removeEnd((String)this.getConfig().errorpages_default(), (String)"/");
            if (errorpage == null && StringUtils.isNotBlank((CharSequence)defaultErrorpages)) {
                errorpage = resolver.getResource(defaultErrorpages + "/" + status);
            }
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        return errorpage;
    }

    @Override
    public boolean forwardToErrorpage(SlingHttpServletRequest request, SlingHttpServletResponse response, int status) throws ServletException, IOException {
        Resource errorpage = this.getErrorpage(request, status);
        if (errorpage != null) {
            request.setAttribute("errorpage.status", (Object)status);
            RequestDispatcher dispatcher = request.getRequestDispatcher(errorpage);
            if (dispatcher != null) {
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public Dictionary<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    @NotNull
    public String getLoginUrl(@Nullable String targetUri) {
        String loginUrl = (String)StringUtils.defaultIfBlank((CharSequence)this.getConfig().loginurl(), (CharSequence)"/system/sling/form/login.html");
        if (StringUtils.isNotBlank((CharSequence)targetUri)) {
            loginUrl = loginUrl + (loginUrl.indexOf(63) < 0 ? (char)'?' : '&') + "resource" + "=" + targetUri;
        }
        return loginUrl;
    }

    @Override
    @NotNull
    public String getLogoutUrl(@Nullable String targetUri) {
        String logoutUrl = (String)StringUtils.defaultIfBlank((CharSequence)this.getConfig().logouturl(), (CharSequence)DEFAULT_LOGOUTURL);
        if (StringUtils.isNotBlank((CharSequence)targetUri)) {
            logoutUrl = logoutUrl + (logoutUrl.indexOf(63) < 0 ? (char)'?' : '&') + "resource" + "=" + targetUri;
        }
        return logoutUrl;
    }

    @Override
    @NotNull
    public String getLoggedoutUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.getConfig().loggedouturl(), (CharSequence)"/system/sling/form/login.html");
    }

    @Activate
    @Modified
    protected void activate(ComponentContext context, Configuration configuration) {
        this.properties = context.getProperties();
        this.config = configuration;
    }

    @Deactivate
    protected void deactivate() {
        this.properties = null;
    }

    @ObjectClassDefinition(name="Composum Nodes (Core) Configuration", description="the configuration service for all servlets in the core bundle")
    public static @interface Configuration {
        @AttributeDefinition(name="Composum Base", description="the resolver root of the Composum modules (default: '/libs/')")
        public String composum_base() default "/libs/";

        @AttributeDefinition(name="Errorpages", description="the path to the errorpages; e.g. 'meta/errorpages' for searching errorpages along the requested path")
        public String errorpages_path();

        @AttributeDefinition(name="Default Errorpages", description="the path to the systems default error pages")
        public String errorpages_default();

        @AttributeDefinition(name="Logout URL", description="logout URL for the system")
        public String logouturl() default "/system/sling/logout.html?logout=true&GLO=true";

        @AttributeDefinition(name="Logged out URL", description="URL for the system to redirect to when the user was logged out")
        public String loggedouturl() default "/system/sling/form/login.html";

        @AttributeDefinition(name="Login URL", description="URL for the system to redirect / link to when the user should be logged in")
        public String loginurl() default "/system/sling/form/login.html";
    }
}

