/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.event;

import com.composum.sling.core.filter.ResourceFilter;
import com.composum.sling.core.filter.StringFilter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.jackrabbit.api.observation.JackrabbitEvent;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class AbstractChangeObserver
implements EventListener {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    public static final int EVENT_TYPES = 63;
    public static final String PROP_LAST_MODIFIED_BY = "jcr:lastModifiedBy";
    public static final String LOG_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final StringFilter PROPERTY_PATH_FILTER = new StringFilter.FilterSet(StringFilter.FilterSet.Rule.or, new StringFilter.BlackList("/(jcr|sling):[^/]*$"), new StringFilter.WhiteList("/jcr:(title|description|data)[^/]*$"));
    protected BundleContext bundleContext;

    protected abstract String getServiceUserId();

    protected abstract String getObservedPath();

    protected abstract void doOnChange(ResourceResolver var1, ChangedResource var2) throws RepositoryException, PersistenceException;

    protected abstract boolean isTargetNode(Node var1) throws RepositoryException;

    protected String getTargetPath(Node node) throws RepositoryException {
        String path = node.getPath();
        return "/".equals(path) ? null : path;
    }

    protected StringFilter getPropertyPathFilter() {
        return PROPERTY_PATH_FILTER;
    }

    protected StringFilter getNodePathFilter() {
        return StringFilter.ALL;
    }

    protected ResourceFilter getResourceFilter() {
        return ResourceFilter.ALL;
    }

    protected abstract ResourceResolver getResolver() throws LoginException;

    protected abstract Session getSession() throws RepositoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(EventIterator events) {
        block18: {
            try {
                ResourceResolver resolver = this.getResolver();
                if (resolver != null) {
                    try {
                        Session session = (Session)resolver.adaptTo(Session.class);
                        String serviceUserId = this.getServiceUserId();
                        ChangeCollection changedNodes = new ChangeCollection();
                        while (events.hasNext()) {
                            Event event = events.nextEvent();
                            if (this.ignoreEvent(event)) continue;
                            try {
                                String path = event.getPath();
                                String user = event.getUserID();
                                if (serviceUserId.equals(user)) continue;
                                Calendar time = Calendar.getInstance();
                                time.setTime(new Date(event.getDate()));
                                int type = event.getType();
                                if (this.isPropertyEvent(type)) {
                                    if (this.getPropertyPathFilter().accept(path)) {
                                        changedNodes.registerChange(session, resolver, path, time, user);
                                        continue;
                                    }
                                    this.LOG.debug("property change {} ignored {}", (Object)type, (Object)path);
                                    continue;
                                }
                                if (this.getNodePathFilter().accept(path)) {
                                    changedNodes.registerChange(session, resolver, path, time, user);
                                    continue;
                                }
                                this.LOG.debug("node change {} ignored {}", (Object)type, (Object)path);
                            }
                            catch (RepositoryException rex) {
                                this.LOG.error(rex.getMessage(), (Throwable)rex);
                            }
                        }
                        if (changedNodes.size() > 0) {
                            for (ChangedResource change : changedNodes.values()) {
                                try {
                                    this.doOnChange(resolver, change);
                                }
                                catch (RepositoryException ex) {
                                    this.LOG.error(ex.getMessage(), (Throwable)ex);
                                }
                            }
                            changedNodes.clear();
                            resolver.commit();
                        }
                        break block18;
                    }
                    catch (PersistenceException ex) {
                        this.LOG.error(ex.getMessage(), (Throwable)ex);
                        break block18;
                    }
                    finally {
                        resolver.close();
                    }
                }
                this.LOG.warn("Can't get resolver. {} ({})", (Object)this.getClass().getName(), (Object)System.identityHashCode(this));
            }
            catch (LoginException ex) {
                this.LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    protected boolean ignoreEvent(Event event) {
        return event instanceof JackrabbitEvent && ((JackrabbitEvent)event).isExternal();
    }

    protected Node getContentNode(Session session, String path) throws RepositoryException {
        Node node = null;
        try {
            Item item = session.getItem(path);
            for (node = item.isNode() ? (Node)item : item.getParent(); node != null && !this.isTargetNode(node) && (path = this.getTargetPath(node)) != null; node = node.getParent()) {
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        return path != null ? node : null;
    }

    protected boolean isPropertyEvent(int type) {
        return (type & 0x1C) != 0;
    }

    @Activate
    @Modified
    public void activate(ComponentContext context) {
        this.bundleContext = context.getBundleContext();
        try {
            Session session = this.getSession();
            session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 63, this.getObservedPath(), true, null, null, true);
        }
        catch (RepositoryException ex) {
            this.LOG.error(ex.getMessage(), (Throwable)ex);
        }
        this.LOG.info("{} activated ({})", (Object)this.getClass().getName(), (Object)System.identityHashCode(this));
    }

    @Deactivate
    public void deactivate() {
        this.bundleContext = null;
        try {
            Session session = this.getSession();
            session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
        }
        catch (RepositoryException ex) {
            this.LOG.error(ex.getMessage(), (Throwable)ex);
        }
        this.LOG.info("{} deactivated ({})", (Object)this.getClass().getName(), (Object)System.identityHashCode(this));
    }

    protected class ChangedResource {
        protected final Resource resource;
        protected Calendar time;
        protected String user;

        public ChangedResource(Resource resource, Calendar time, String user) {
            this.resource = resource;
            this.time = time;
            this.user = user;
        }

        public void mergeChange(Calendar time, String user) {
            if (time.after(this.time)) {
                this.time = time;
                this.user = user;
            }
        }

        public Resource getResource() {
            return this.resource;
        }

        public Calendar getTime() {
            return this.time;
        }

        public String getUser() {
            return this.user;
        }
    }

    protected class ChangeCollection
    extends HashMap<String, ChangedResource> {
        protected ChangeCollection() {
        }

        public void registerChange(Session session, ResourceResolver resolver, String path, Calendar time, String user) throws RepositoryException {
            Node contentNode = AbstractChangeObserver.this.getContentNode(session, path);
            if (contentNode != null) {
                path = contentNode.getPath();
                ChangedResource change = (ChangedResource)this.get(path);
                if (change != null) {
                    change.mergeChange(time, user);
                } else {
                    Resource resource;
                    if (AbstractChangeObserver.this.LOG.isDebugEnabled()) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat(AbstractChangeObserver.LOG_DATE_FORMAT);
                        AbstractChangeObserver.this.LOG.debug("registered: " + path + ", " + dateFormat.format(time.getTime()) + ", " + user);
                    }
                    if ((resource = resolver.getResource(path)) != null && AbstractChangeObserver.this.getResourceFilter().accept(resource)) {
                        this.put(path, new ChangedResource(resource, time, user));
                    }
                }
            }
        }
    }
}

