/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.logging;

import com.composum.sling.core.logging.MessageTypeAdapterFactory;
import com.composum.sling.core.util.I18N;
import com.composum.sling.core.util.LoggerFormat;
import com.google.gson.annotations.JsonAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

@JsonAdapter(value=MessageTypeAdapterFactory.class)
public class Message
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(Message.class);
    protected Level level;
    @Nullable
    protected Level logLevel;
    @Nullable
    protected String context;
    @Nullable
    protected String label;
    protected String text;
    protected String rawText;
    @Nullable
    protected String path;
    @Nullable
    protected Object[] arguments;
    @Nullable
    protected String category;
    @Nullable
    protected List<Message> details;
    protected Long timestamp;

    @Deprecated
    public Message() {
    }

    public Message(@Nullable Level level, @NotNull String rawText, Object ... arguments) {
        this.rawText = rawText;
        this.level = level;
        this.category = this.category;
        this.arguments = arguments != null && arguments.length > 0 ? arguments : null;
        this.timestamp = System.currentTimeMillis();
    }

    @NotNull
    public static Message error(@NotNull String text, Object ... arguments) {
        return new Message(Level.error, text, arguments);
    }

    public static Message validationError(@Nullable String context, @Nullable String label, @NotNull String text, Object ... args) {
        return Message.error(text, args).setContext(context).setLabel(label).setLogLevel(Level.debug);
    }

    @NotNull
    public static Message warn(@NotNull String text, Object ... arguments) {
        return new Message(Level.warn, text, arguments);
    }

    public static Message validationWarn(@Nullable String context, @Nullable String label, @NotNull String text, Object ... args) {
        return Message.warn(text, args).setContext(context).setLabel(label).setLogLevel(Level.debug);
    }

    @NotNull
    public static Message info(@NotNull String text, Object ... arguments) {
        return new Message(Level.info, text, arguments);
    }

    public static Message validationInfo(@Nullable String context, @Nullable String label, @NotNull String text, Object ... args) {
        return Message.info(text, args).setContext(context).setLabel(label).setLogLevel(Level.debug);
    }

    @NotNull
    public static Message debug(@NotNull String text, Object ... arguments) {
        return new Message(Level.debug, text, arguments);
    }

    @NotNull
    public Message addDetail(@NotNull Message detailMessage) {
        if (this.details == null) {
            this.details = new ArrayList<Message>();
        }
        this.details.add(detailMessage);
        return this;
    }

    @Nullable
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public Date getTimestampAsDate() {
        return this.timestamp != null ? new Date(this.timestamp) : null;
    }

    @NotNull
    public Level getLevel() {
        return this.level != null ? this.level : Level.info;
    }

    @Nullable
    public Level getLogLevel() {
        return this.logLevel;
    }

    @NotNull
    public Message setLogLevel(@Nullable Level logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    @NotNull
    public String getRawText() {
        return this.rawText;
    }

    @NotNull
    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        if (this.rawText == null) {
            return "";
        }
        this.text = this.rawText;
        if (this.arguments != null && this.arguments.length > 0) {
            this.text = LoggerFormat.format(this.text, this.arguments);
        }
        return this.text;
    }

    public String getMessage(@Nullable SlingHttpServletRequest request) {
        if (request == null) {
            return this.getText();
        }
        String i18nMessage = this.rawText;
        if (StringUtils.isNotBlank((CharSequence)i18nMessage)) {
            String newMessage = I18N.get(request, i18nMessage);
            if (StringUtils.isNotBlank((CharSequence)newMessage)) {
                i18nMessage = newMessage;
            }
            if (this.arguments != null && this.arguments.length > 0) {
                i18nMessage = LoggerFormat.format(i18nMessage, this.arguments);
            }
        } else {
            i18nMessage = "";
        }
        return i18nMessage;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    @NotNull
    public Message setPath(@Nullable String path) {
        this.path = path;
        return this;
    }

    @NotNull
    public List<Object> getArguments() {
        return this.arguments != null ? Arrays.asList(this.arguments) : Collections.emptyList();
    }

    @Nullable
    public String getCategory() {
        return this.category;
    }

    @NotNull
    public Message setCategory(@Nullable String category) {
        this.category = category;
        return this;
    }

    @Nullable
    public String getLabel() {
        return this.label;
    }

    @NotNull
    public Message setLabel(@Nullable String label) {
        this.label = label;
        return this;
    }

    @Nullable
    public String getContext() {
        return this.context;
    }

    @NotNull
    public Message setContext(@Nullable String context) {
        this.context = context;
        return this;
    }

    @NotNull
    public List<Message> getDetails() {
        return this.details != null ? Collections.unmodifiableList(this.details) : Collections.emptyList();
    }

    public Message clone() throws CloneNotSupportedException {
        return (Message)super.clone();
    }

    protected Message prepareForJsonSerialization(SlingHttpServletRequest request) throws CloneNotSupportedException {
        Message i18nMessage = this.clone();
        i18nMessage.text = this.getMessage(request);
        if (this.arguments != null) {
            i18nMessage.arguments = new Object[this.arguments.length];
            for (int i = 0; i < this.arguments.length; ++i) {
                Object arg = this.arguments[i];
                i18nMessage.arguments[i] = arg instanceof String || arg instanceof Number ? arg : LoggerFormat.format("{}", arg);
            }
        }
        return i18nMessage;
    }

    @NotNull
    public Message logInto(@Nullable Logger log) {
        return this.logInto(log, null);
    }

    @NotNull
    public Message logInto(@Nullable Logger log, @Nullable Throwable cause) {
        Throwable loggedCause = cause != null ? cause : this.getThrowableArgument();
        Level thelevel = this.getLogLevel();
        Level level = thelevel = thelevel != null ? thelevel : this.getLevel();
        if (log != null) {
            switch (thelevel) {
                case error: {
                    if (!log.isErrorEnabled()) break;
                    log.error(this.toFormattedMessage(), loggedCause);
                    break;
                }
                case warn: {
                    if (!log.isWarnEnabled()) break;
                    log.warn(this.toFormattedMessage(), loggedCause);
                    break;
                }
                case debug: {
                    if (!log.isDebugEnabled()) break;
                    log.debug(this.toFormattedMessage(), loggedCause);
                    break;
                }
                case none: {
                    break;
                }
                default: {
                    if (!log.isInfoEnabled()) break;
                    log.info(this.toFormattedMessage(), loggedCause);
                }
            }
        }
        return this;
    }

    @Nullable
    protected Throwable getThrowableArgument() {
        Object possibleThrowable;
        Throwable throwable = null;
        if (this.arguments != null && this.arguments.length > 0 && (possibleThrowable = this.arguments[this.arguments.length - 1]) instanceof Throwable) {
            throwable = (Throwable)possibleThrowable;
        }
        return throwable;
    }

    public String toFormattedMessage() {
        StringBuilder buf = new StringBuilder();
        this.appendFormattedTo(buf, "", this.level);
        return buf.toString();
    }

    protected void appendFormattedTo(StringBuilder buf, String indent, Level baseLevel) {
        boolean differingLoglevel;
        buf.append(indent);
        boolean bl = differingLoglevel = this.logLevel != null && this.logLevel != this.level;
        if (this.level != null && baseLevel != null && this.level != baseLevel || differingLoglevel) {
            if (this.level != null) {
                buf.append(this.level.name());
            }
            if (differingLoglevel) {
                buf.append("(").append(this.logLevel.name()).append(")");
            }
            buf.append(": ");
        }
        if (this.arguments != null) {
            FormattingTuple formatted = MessageFormatter.arrayFormat((String)this.rawText, (Object[])this.arguments);
            buf.append(formatted.getMessage());
        } else {
            buf.append(this.rawText);
        }
        if (this.details != null) {
            String addIndent = indent + "    ";
            buf.append("\n").append(addIndent).append("Details:");
            for (Message detail : this.details) {
                buf.append("\n");
                detail.appendFormattedTo(buf, addIndent, baseLevel);
            }
        }
    }

    public static enum Level {
        error,
        warn,
        info,
        debug,
        none;


        public boolean isError() {
            return this == error;
        }
    }
}

