/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.resource;

import com.composum.sling.core.filter.ResourceFilter;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceNodeIterator
implements Iterator<Resource> {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceNodeIterator.class);
    protected final ResourceResolver resolver;
    protected final NodeIterator nodeIterator;
    protected final ResourceFilter filter;

    public ResourceNodeIterator(@NotNull ResourceResolver resolver, @NotNull NodeIterator nodeIterator) {
        this(resolver, nodeIterator, null);
    }

    public ResourceNodeIterator(@NotNull ResourceResolver resolver, @NotNull NodeIterator nodeIterator, @Nullable ResourceFilter filter) {
        this.resolver = resolver;
        this.nodeIterator = nodeIterator;
        this.filter = filter != null ? filter : ResourceFilter.ALL;
    }

    @Override
    public boolean hasNext() {
        return this.nodeIterator.hasNext();
    }

    @Override
    public Resource next() {
        try {
            Node node = this.nodeIterator.nextNode();
            return this.resolver.getResource(node.getPath());
        }
        catch (RepositoryException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    @Override
    public void remove() {
    }
}

