/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.security;

import com.composum.sling.core.ResourceHandle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;

public class ConfigurationSet
implements Serializable {
    public static final String SA_INSTANCE = ConfigurationSet.class.getName() + "#instance";
    public static final String PN_SCRIPT = "script";
    public static final String PN_AUTO_SETUP = "autoSetup";
    public static final String PN_RANK = "rank";
    public static final String QUERY = "/jcr:root/conf//config[@sling:resourceType='composum/nodes/commons/components/security/config']";
    protected final Map<String, Configuration> configurations = new TreeMap<String, Configuration>();
    protected final Map<String, List<Configuration>> configCategories = new TreeMap<String, List<Configuration>>();
    protected final Map<String, List<ConfigScript>> scriptCategories = new TreeMap<String, List<ConfigScript>>();

    public ConfigurationSet(@NotNull ResourceResolver resolver) {
        Iterator configIterator = resolver.findResources(QUERY, "xpath");
        while (configIterator.hasNext()) {
            this.addConfiguration(new Configuration(ResourceHandle.use((Resource)configIterator.next())));
        }
    }

    public Map<String, List<Configuration>> getConfigCategories() {
        return this.configCategories;
    }

    public Map<String, List<ConfigScript>> getScriptCategories() {
        return this.scriptCategories;
    }

    public Map<String, Configuration> getConfigurations() {
        return this.configurations;
    }

    public void addConfiguration(@NotNull Configuration configuration) {
        this.configurations.put(configuration.getLabel(), configuration);
        for (String category : configuration.getCategory()) {
            List categoryConfigurations = this.configCategories.computeIfAbsent(category, k -> new ArrayList());
            if (categoryConfigurations.contains(configuration)) continue;
            categoryConfigurations.add(configuration);
            Collections.sort(categoryConfigurations);
        }
    }

    @NotNull
    public static ConfigurationSet instance(@NotNull SlingHttpServletRequest request) {
        ConfigurationSet instance = null;
        HttpSession session = request.getSession(false);
        if (session != null) {
            try {
                instance = (ConfigurationSet)session.getAttribute(SA_INSTANCE);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (instance == null) {
            instance = new ConfigurationSet(request.getResourceResolver());
            if (session != null) {
                session.setAttribute(SA_INSTANCE, (Object)instance);
            }
        }
        return instance;
    }

    public static void clear(@NotNull SlingHttpServletRequest request) {
        Object instance = null;
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.removeAttribute(SA_INSTANCE);
        }
    }

    public class Configuration
    implements Comparable<Configuration>,
    Serializable {
        private final List<String> category;
        private final String label;
        private final String name;
        private final String path;
        private final String description;
        private final Map<String, ConfigScript> scripts = new TreeMap<String, ConfigScript>();
        private final Long rank;

        public Configuration(ResourceHandle handle) {
            this.category = Arrays.asList((Object[])handle.getProperty("category", new String[0]));
            this.label = handle.getTitle();
            this.name = handle.getName();
            this.path = handle.getPath();
            this.description = handle.getProperty("jcr:description", "");
            this.rank = handle.getProperty(ConfigurationSet.PN_RANK, Long.class);
            for (Resource scriptRes : handle.getChildren()) {
                this.addScript(new ConfigScript(this, ResourceHandle.use(scriptRes)));
            }
        }

        public boolean matches(@NotNull Collection<String> category) {
            for (String ownCategory : this.getCategory()) {
                if (!category.contains(ownCategory)) continue;
                return true;
            }
            return false;
        }

        @NotNull
        public List<String> getCategory() {
            return this.category;
        }

        @NotNull
        public String getCategories() {
            return StringUtils.join(this.getCategory(), (String)",");
        }

        public String getRank() {
            return this.rank != null ? Long.toString(this.rank) : null;
        }

        @NotNull
        public String getLabel() {
            return this.label;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public String getPath() {
            return this.path;
        }

        @NotNull
        public String getDescription() {
            return this.description;
        }

        @NotNull
        public Map<String, ConfigScript> getScripts() {
            return this.scripts;
        }

        public void addScript(@NotNull ConfigScript script) {
            List categoryScripts;
            this.scripts.put(script.getLabel(), script);
            for (String category : this.getCategory()) {
                categoryScripts = ConfigurationSet.this.scriptCategories.computeIfAbsent(category, k -> new ArrayList());
                if (categoryScripts.contains(script)) continue;
                categoryScripts.add(script);
                Collections.sort(categoryScripts);
            }
            for (String category : script.getCategory()) {
                List categoryConfigurations;
                categoryScripts = ConfigurationSet.this.scriptCategories.computeIfAbsent(category, k -> new ArrayList());
                if (!categoryScripts.contains(script)) {
                    categoryScripts.add(script);
                    Collections.sort(categoryScripts);
                }
                if ((categoryConfigurations = ConfigurationSet.this.configCategories.computeIfAbsent(category, k -> new ArrayList())).contains(this)) continue;
                categoryConfigurations.add(this);
                Collections.sort(categoryConfigurations);
            }
        }

        @Override
        public int compareTo(Configuration other) {
            CompareToBuilder builder = new CompareToBuilder();
            builder.append((Object)(this.rank != null ? String.format("%04d", this.rank) : "0050"), (Object)(other.rank != null ? String.format("%04d", other.rank) : "0050"));
            builder.append((Object)this.getLabel(), (Object)other.getLabel());
            return builder.toComparison();
        }
    }

    public class ConfigScript
    implements Comparable<ConfigScript>,
    Serializable {
        private final Configuration configuration;
        private final List<String> category;
        private final String label;
        private final String name;
        private final String path;
        private final String description;
        private final boolean autoSetup;
        private final String scriptPath;
        private final Long rank;

        public ConfigScript(@NotNull Configuration configuration, ResourceHandle handle) {
            this.configuration = configuration;
            this.category = Arrays.asList((Object[])handle.getProperty("category", new String[0]));
            this.label = handle.getTitle();
            this.name = handle.getName();
            this.path = handle.getPath();
            this.description = handle.getProperty("jcr:description", "");
            this.scriptPath = handle.getProperty(ConfigurationSet.PN_SCRIPT, "");
            this.autoSetup = handle.getProperty(ConfigurationSet.PN_AUTO_SETUP, Boolean.FALSE);
            this.rank = handle.getProperty(ConfigurationSet.PN_RANK, Long.class);
        }

        @NotNull
        public Configuration getConfiguration() {
            return this.configuration;
        }

        public boolean matches(@NotNull Collection<String> category) {
            for (String ownCategory : this.getCategory()) {
                if (!category.contains(ownCategory)) continue;
                return true;
            }
            return false;
        }

        @NotNull
        public List<String> getCategory() {
            return this.category;
        }

        @NotNull
        public String getCategories() {
            return StringUtils.join(this.getCategory(), (String)",");
        }

        public String getRank() {
            return this.rank != null ? Long.toString(this.rank) : null;
        }

        @NotNull
        public String getLabel() {
            return this.label;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public String getPath() {
            return this.path;
        }

        @NotNull
        public String getDescription() {
            return this.description;
        }

        public boolean isAutoSetup() {
            return this.autoSetup;
        }

        @NotNull
        public String getScriptPath() {
            return this.scriptPath;
        }

        @Override
        public int compareTo(ConfigScript other) {
            CompareToBuilder builder = new CompareToBuilder();
            builder.append((Object)(this.rank != null ? String.format("%04d", this.rank) : "0050"), (Object)(other.rank != null ? String.format("%04d", other.rank) : "0050"));
            builder.append((Object)this.getLabel(), (Object)other.getLabel());
            return builder.toComparison();
        }
    }
}

