/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.service;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface ServiceRestrictions {
    public static final String SA_PERMISSION = ServiceRestrictions.class.getName() + "#permission";

    public boolean isUserOptionAllowed(@NotNull SlingHttpServletRequest var1, @NotNull Permission var2);

    public Permission getDefaultPermisson();

    public boolean isPermissible(@Nullable SlingHttpServletRequest var1, @Nullable Key var2, @NotNull Permission var3);

    @NotNull
    public Permission getPermission(@Nullable Key var1);

    @Nullable
    public String getRestrictions(@Nullable Key var1);

    public static class Restriction {
        public static final String SEPARATOR = ":";
        public final Permission permission;
        public final String restrictions;

        public Restriction(@NotNull String rule) {
            String[] splitted = rule.split(SEPARATOR, 2);
            Permission perm = null;
            if (StringUtils.isNotBlank((CharSequence)splitted[0])) {
                try {
                    perm = Permission.valueOf(splitted[0]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            this.permission = perm;
            this.restrictions = splitted.length > 1 ? splitted[1] : null;
        }

        public Restriction() {
            this.permission = null;
            this.restrictions = null;
        }

        public String toString() {
            return (this.permission != null ? this.permission.name() : "") + (StringUtils.isNotBlank((CharSequence)this.restrictions) ? SEPARATOR + this.restrictions : "");
        }
    }

    public static class Key {
        public static final char SEPARATOR = '/';
        public final List<String> identifier;

        public Key(@NotNull String rule) {
            while (rule.startsWith("/")) {
                rule = rule.substring(1);
            }
            this.identifier = StringUtils.isNotBlank((CharSequence)rule) ? Arrays.asList(StringUtils.split((String)rule, (char)'/')) : Collections.emptyList();
        }

        public boolean isEmpty() {
            return this.identifier.size() == 0;
        }

        public String toString() {
            return StringUtils.join(this.identifier, (char)'/');
        }

        public boolean equals(Object other) {
            return other instanceof Key && this.toString().equals(other.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    public static enum Permission {
        none,
        read,
        write;


        public boolean matches(Permission required) {
            return this.compareTo(required) >= 0;
        }
    }
}

