/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.servlet;

import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.Restricted;
import com.composum.sling.core.mapping.MappingRules;
import com.composum.sling.core.service.RestrictedService;
import com.composum.sling.core.service.ServiceRestrictions;
import com.composum.sling.core.servlet.ServletOperationSet;
import com.composum.sling.core.util.I18N;
import com.composum.sling.core.util.JsonUtil;
import com.composum.sling.core.util.LinkUtil;
import com.composum.sling.core.util.ResourceUtil;
import com.composum.sling.core.util.ResponseUtil;
import com.composum.sling.core.util.XSS;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Deactivate;

public abstract class AbstractServiceServlet
extends SlingAllMethodsServlet
implements RestrictedService {
    public static final String PARAM_FILE = "file";
    public static final String PARAM_CMD = "cmd";
    public static final String PARAM_FILTER = "filter";
    public static final String PARAM_ID = "id";
    public static final String PARAM_INDEX = "index";
    public static final String PARAM_JCR_CONTENT = "jcrContent";
    public static final String PARAM_LABEL = "label";
    public static final String PARAM_MIME_TYPE = "mimeType";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_PATH = "path";
    public static final String PARAM_BEFORE = "before";
    public static final String PARAM_QUERY = "query";
    public static final String PARAM_RESOURCE_TYPE = "resourceType";
    public static final String PARAM_TITLE = "title";
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_URL = "url";
    public static final String PARAM_VALUE = "value";
    public static final String PARAM_VERSION = "version";
    public static final String DATE_FORMAT = "yyyy-MM-DD HH:mm:ss";
    private ServiceRestrictions restrictionsService;

    @Deactivate
    protected void deactivate() {
        this.restrictionsService = null;
    }

    protected ServiceRestrictions getRestrictions() {
        if (this.restrictionsService == null) {
            BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            ServiceReference reference = bundleContext.getServiceReference(ServiceRestrictions.class.getName());
            this.restrictionsService = (ServiceRestrictions)bundleContext.getService(reference);
        }
        return this.restrictionsService;
    }

    @Override
    public ServiceRestrictions.Key getServiceKey() {
        Restricted restricted = this.getClass().getAnnotation(Restricted.class);
        return restricted != null ? new ServiceRestrictions.Key(restricted.key()) : null;
    }

    protected boolean isEnabled(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @NotNull ServiceRestrictions.Permission needed) {
        return this.getRestrictions().isPermissible(request, this.getServiceKey(), needed);
    }

    @NotNull
    protected ServiceRestrictions.Permission methodGetPermission(@NotNull SlingHttpServletRequest request) {
        return ServiceRestrictions.Permission.read;
    }

    @NotNull
    protected ServiceRestrictions.Permission methodPostPermission(@NotNull SlingHttpServletRequest request) {
        return ServiceRestrictions.Permission.write;
    }

    @NotNull
    protected ServiceRestrictions.Permission methodPutPermission(@NotNull SlingHttpServletRequest request) {
        return ServiceRestrictions.Permission.write;
    }

    @NotNull
    protected ServiceRestrictions.Permission methodDeletePermission(@NotNull SlingHttpServletRequest request) {
        return ServiceRestrictions.Permission.write;
    }

    @NotNull
    protected abstract ServletOperationSet<?, ?> getOperations();

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        if (this.isEnabled(request, response, this.methodGetPermission(request))) {
            AbstractServiceServlet.setNoCacheHeaders(response);
            this.getOperations().doGet(request, response);
        } else {
            response.sendError(405);
        }
    }

    protected void doPost(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        if (this.isEnabled(request, response, this.methodPostPermission(request))) {
            AbstractServiceServlet.setNoCacheHeaders(response);
            this.getOperations().doPost(request, response);
        } else {
            response.sendError(405);
        }
    }

    protected void doPut(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        if (this.isEnabled(request, response, this.methodPutPermission(request))) {
            AbstractServiceServlet.setNoCacheHeaders(response);
            this.getOperations().doPut(request, response);
        } else {
            response.sendError(405);
        }
    }

    protected void doDelete(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        if (this.isEnabled(request, response, this.methodDeletePermission(request))) {
            AbstractServiceServlet.setNoCacheHeaders(response);
            this.getOperations().doDelete(request, response);
        } else {
            response.sendError(405);
        }
    }

    public static void setNoCacheHeaders(@NotNull SlingHttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache");
        response.addHeader("Cache-Control", "no-store");
        response.addHeader("Cache-Control", "must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    @NotNull
    public static ResourceHandle getResource(SlingHttpServletRequest request) {
        String path;
        ResourceResolver resolver = request.getResourceResolver();
        Resource resource = resolver.resolve(path = AbstractServiceServlet.getPath(request));
        if (ResourceUtil.isNonExistingResource((Resource)resource)) {
            String decoded = LinkUtil.decodePath(path);
            resource = resolver.resolve(decoded);
        }
        return ResourceHandle.use(resource);
    }

    public static String getPath(SlingHttpServletRequest request) {
        RequestPathInfo reqPathInfo = request.getRequestPathInfo();
        String path = reqPathInfo.getSuffix();
        if (StringUtils.isBlank((CharSequence)path)) {
            path = request.getParameter(PARAM_PATH);
        }
        path = XSS.filter(path);
        path = path.replaceAll("&amp;", "&");
        return path;
    }

    @NotNull
    public static ResourceHandle tryToUseRawSuffix(@NotNull SlingHttpServletRequest request, @NotNull ResourceHandle resource) {
        if (!resource.isValid()) {
            String resourcePath = request.getRequestPathInfo().getSuffix();
            Resource requested = null;
            if (StringUtils.isNotBlank((CharSequence)resourcePath)) {
                requested = request.getResourceResolver().getResource(resourcePath);
            }
            if (requested != null) {
                resource = ResourceHandle.use(requested);
            }
        }
        return resource;
    }

    protected void jsonAnswerItemExists(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        response.setStatus(409);
        JsonWriter jsonWriter = ResponseUtil.getJsonWriter(response);
        jsonWriter.beginObject();
        jsonWriter.name("success").value(false);
        jsonWriter.name("messages").beginArray();
        jsonWriter.beginObject();
        jsonWriter.name("level").value("warn");
        jsonWriter.name("text").value(I18N.get(request, "An element with the same name exists already - use a different name!"));
        jsonWriter.endObject();
        jsonWriter.endArray();
        jsonWriter.endObject();
    }

    public static void jsonValue(JsonWriter writer, Object value) throws IOException {
        if (value instanceof String) {
            writer.value((String)value);
        } else if (value instanceof Map) {
            Map map = (Map)value;
            writer.beginObject();
            for (Object key : map.keySet()) {
                writer.name(key.toString());
                AbstractServiceServlet.jsonValue(writer, map.get(key));
            }
            writer.endObject();
        } else if (value instanceof Object[]) {
            writer.beginArray();
            for (Object v : (Object[])value) {
                AbstractServiceServlet.jsonValue(writer, v);
            }
            writer.endArray();
        } else if (value instanceof Iterable) {
            writer.beginArray();
            for (Object v : (Iterable)value) {
                AbstractServiceServlet.jsonValue(writer, v);
            }
            writer.endArray();
        } else if (value instanceof Iterator) {
            Iterator iterator = (Iterator)value;
            writer.beginArray();
            while (iterator.hasNext()) {
                AbstractServiceServlet.jsonValue(writer, iterator.next());
            }
            writer.endArray();
        } else if (value instanceof Calendar) {
            writer.value(new SimpleDateFormat(DATE_FORMAT).format(((Calendar)value).getTime()));
        } else {
            writer.value(value != null ? value.toString() : null);
        }
    }

    public static <T> T getJsonObject(SlingHttpServletRequest request, Class<T> type) throws IOException {
        ServletInputStream inputStream = request.getInputStream();
        InputStreamReader inputReader = new InputStreamReader((InputStream)inputStream, MappingRules.CHARSET.name());
        Gson gson = JsonUtil.GSON_BUILDER.create();
        return gson.fromJson((Reader)inputReader, type);
    }

    public static <T> T getJsonObject(SlingHttpServletRequest request, Class<T> type, InstanceCreator<T> instanceCreator) throws IOException {
        ServletInputStream inputStream = request.getInputStream();
        InputStreamReader inputReader = new InputStreamReader((InputStream)inputStream, MappingRules.CHARSET.name());
        Gson gson = new GsonBuilder().registerTypeAdapter(type, instanceCreator).create();
        return gson.fromJson((Reader)inputReader, type);
    }

    public static <T> T getJsonObject(String input, Class<T> type) {
        StringReader inputReader = new StringReader(input);
        Gson gson = JsonUtil.GSON_BUILDER.create();
        return gson.fromJson((Reader)inputReader, type);
    }
}

