/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.servlet;

import com.composum.sling.core.logging.Message;
import com.composum.sling.core.logging.MessageContainer;
import com.composum.sling.core.logging.MessageTypeAdapterFactory;
import com.composum.sling.core.util.I18N;
import com.composum.sling.core.util.ResponseUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Status {
    private static final Logger LOG = LoggerFactory.getLogger(Status.class);
    public static final String DATA = "data";
    protected final transient Gson gson;
    protected final transient SlingHttpServletRequest request;
    protected final transient SlingHttpServletResponse response;
    protected int status = 200;
    protected boolean success = true;
    protected boolean warning = false;
    @Nullable
    protected transient Logger messageLogger;
    @Nullable
    protected String title;
    @Nullable
    protected MessageContainer messages;
    @Nullable
    protected Map<String, Map<String, Object>> data;
    @Nullable
    protected Map<String, List<Map<String, Object>>> list;

    public Status(@Nullable SlingHttpServletRequest request, @Nullable SlingHttpServletResponse response, @Nullable Logger messageLogger) {
        this(new GsonBuilder(), request, response, messageLogger);
    }

    public Status(@Nullable SlingHttpServletRequest request, @Nullable SlingHttpServletResponse response) {
        this(new GsonBuilder(), request, response, null);
    }

    public Status(@NotNull GsonBuilder gsonBuilder, @Nullable SlingHttpServletRequest request, @Nullable SlingHttpServletResponse response, @Nullable Logger messageLogger) {
        this.gson = Status.initGson(Objects.requireNonNull(gsonBuilder), () -> request).create();
        this.request = request;
        this.response = response;
        this.messageLogger = messageLogger;
    }

    @Deprecated
    public Status(@NotNull Gson gson, @Nullable SlingHttpServletRequest request, @Nullable SlingHttpServletResponse response) {
        this.gson = Objects.requireNonNull(gson);
        this.request = request;
        this.response = response;
    }

    @Deprecated
    public Status() {
        this(new GsonBuilder().create(), null, null);
    }

    @NotNull
    public static GsonBuilder initGson(@NotNull GsonBuilder gsonBuilder, @NotNull Supplier<SlingHttpServletRequest> requestProvider) {
        if (requestProvider != null) {
            return gsonBuilder.registerTypeAdapterFactory(new MessageTypeAdapterFactory(requestProvider));
        }
        return gsonBuilder;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
        if (status < 200 || status >= 300) {
            this.success = false;
        }
    }

    @Nullable
    public String getRequiredParameter(@NotNull String paramName, @Nullable Pattern pattern, @NotNull String errorMessage) {
        RequestParameter requestParameter = this.request.getRequestParameter(paramName);
        String value = null;
        if (requestParameter != null) {
            value = requestParameter.getString();
            if (pattern == null || pattern.matcher(value).matches()) {
                return value;
            }
        }
        this.validationError(null, null, errorMessage, value);
        return null;
    }

    public List<String> getRequiredParameters(@NotNull String paramName, @Nullable Pattern pattern, @NotNull String errorMessage) {
        RequestParameter[] requestParameters = this.request.getRequestParameters(paramName);
        if (requestParameters == null || requestParameters.length < 1) {
            this.validationError(null, null, errorMessage, new Object[0]);
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        for (RequestParameter parameter : requestParameters) {
            String value = parameter.getString();
            if (pattern != null && !pattern.matcher(value).matches()) {
                this.validationError(null, null, errorMessage, value);
            }
            values.add(value);
        }
        return values;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean hasTitle() {
        return StringUtils.isNotBlank((CharSequence)this.title);
    }

    public void setTitle(String rawTitle) {
        if (StringUtils.isNotBlank((CharSequence)rawTitle)) {
            String string = this.title = this.request != null ? I18N.get(this.request, rawTitle) : rawTitle;
            if (StringUtils.isBlank((CharSequence)this.title)) {
                this.title = rawTitle;
            }
        } else {
            this.title = null;
        }
    }

    @NotNull
    public MessageContainer getMessages() {
        if (this.messages == null) {
            this.messages = new MessageContainer(this.messageLogger);
        }
        return this.messages;
    }

    public boolean isValid() {
        return this.isSuccess();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isWarning() {
        return this.warning;
    }

    public void setWarning(boolean value) {
        this.warning = value;
    }

    public boolean isError() {
        return !this.isSuccess();
    }

    public void info(@NotNull String text, Object ... args) {
        this.shortMessage(Message.Level.info, text, args);
    }

    public void validationInfo(@NotNull String context, @NotNull String label, @NotNull String text, Object ... args) {
        this.addValidationMessage(Message.Level.info, context, label, text, args);
    }

    public void warn(@NotNull String text, Object ... args) {
        this.shortMessage(Message.Level.warn, text, args);
    }

    public void validationWarn(@NotNull String context, @NotNull String label, @NotNull String text, Object ... args) {
        this.addValidationMessage(Message.Level.warn, context, label, text, args);
    }

    public void error(@NotNull String text, Object ... args) {
        this.shortMessage(Message.Level.error, text, args);
    }

    public void error(@NotNull String text, @NotNull Throwable exception) {
        this.getMessages().add(Message.error(text, exception.getLocalizedMessage()), exception);
        this.adjustToMessageLevel(Message.Level.error);
    }

    public void validationError(@NotNull String context, @NotNull String label, @NotNull String text, Object ... args) {
        this.addValidationMessage(Message.Level.error, context, label, text, args);
    }

    @NotNull
    public Map<String, Object> data(@NotNull String name) {
        if (this.data == null) {
            this.data = new LinkedHashMap<String, Map<String, Object>>();
        }
        Map object = this.data.computeIfAbsent(name, k -> new LinkedHashMap());
        return object;
    }

    public void reference(@NotNull String name, Resource resource) {
        Map<String, Object> object = this.data(name);
        this.reference(object, resource);
    }

    public void reference(Map<String, Object> object, Resource resource) {
        object.put("name", resource.getName());
        object.put("path", resource.getPath());
        object.put("type", resource.getResourceType());
        object.put("prim", resource.getValueMap().get("jcr:primaryType", (Object)""));
        object.put("synthetic", ResourceUtil.isSyntheticResource((Resource)resource));
    }

    @NotNull
    public List<Map<String, Object>> list(@NotNull String name) {
        if (this.list == null) {
            this.list = new LinkedHashMap<String, List<Map<String, Object>>>();
        }
        List object = this.list.computeIfAbsent(name, k -> new ArrayList());
        return object;
    }

    public void list(@NotNull String name, Collection<Resource> items) {
        List<Map<String, Object>> object = this.list(name);
        for (Resource item : items) {
            HashMap<String, Object> ref = new HashMap<String, Object>();
            this.reference(ref, item);
            object.add(ref);
        }
    }

    public Message shortMessage(@NotNull Message.Level level, @NotNull String text, Object ... args) {
        return this.addMessage(new Message(level, text, args));
    }

    @NotNull
    public Message addValidationMessage(@NotNull Message.Level level, @Nullable String context, @Nullable String label, @NotNull String text, Object ... args) {
        return this.addMessage(new Message(level, text, args).setContext(context).setLabel(label).setLogLevel(Message.Level.debug));
    }

    @NotNull
    public Message addMessage(@NotNull Message message) {
        if (this.messages == null) {
            this.messages = new MessageContainer(this.messageLogger);
        }
        this.adjustToMessageLevel(message.getLevel());
        this.messages.add(message);
        return message;
    }

    protected void adjustToMessageLevel(Message.Level level) {
        if (level == Message.Level.error) {
            this.status = 400;
            this.success = false;
            if (!this.hasTitle()) {
                this.setTitle("Error");
            }
        } else if (level == Message.Level.warn && this.status == 200) {
            this.status = 202;
            this.warning = true;
            if (!this.hasTitle()) {
                this.setTitle("Warning");
            }
        }
    }

    public void toJson(@NotNull JsonWriter writer) throws IOException {
        try {
            this.gson.toJson((Object)this, this.getClass(), writer);
        }
        catch (JsonIOException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String getJsonString() {
        try (StringWriter statusString = new StringWriter();){
            this.toJson(new JsonWriter(statusString));
            String string = statusString.toString();
            return string;
        }
        catch (IOException | RuntimeException e) {
            LOG.error("Could not create JSON", (Throwable)e);
            try {
                return ReflectionToStringBuilder.reflectionToString((Object)this);
            }
            catch (RuntimeException e1) {
                LOG.error("Could not even create some representation via reflection. Giving up.", (Throwable)e1);
                return super.toString();
            }
        }
    }

    public void sendJson() throws IOException {
        this.sendJson(this.getStatus());
    }

    public void sendJson(int status) throws IOException {
        JsonWriter writer = ResponseUtil.getJsonWriter(this.response);
        this.response.setStatus(status);
        this.response.setContentType("application/json; charset=UTF-8");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending status {} {} {} : {}", new Object[]{status, this.success ? "success" : "failed", this.warning ? " with warning" : "", StringUtils.abbreviate((String)this.title, (int)256)});
        }
        this.toJson(writer);
    }

    @NotNull
    public Gson getGson() {
        return this.gson;
    }

    @NotNull
    public Status setMessageLogger(@Nullable Logger messageLogger) {
        this.messageLogger = messageLogger;
        return this;
    }

    @Deprecated
    @NotNull
    public Status withLogging(@NotNull Logger logger) {
        return this.setMessageLogger(logger);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Status{");
        sb.append("status=").append(this.status);
        if (this.success) {
            sb.append(", success=").append(this.success);
        }
        if (this.warning) {
            sb.append(", warning=").append(this.warning);
        }
        if (StringUtils.isNotBlank((CharSequence)this.title)) {
            sb.append(", title='").append(this.title).append('\'');
        }
        sb.append('}');
        return sb.toString();
    }
}

