/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.servlet;

import com.composum.sling.core.CoreConfiguration;
import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.Restricted;
import com.composum.sling.core.logging.Message;
import com.composum.sling.core.service.RestrictedService;
import com.composum.sling.core.service.ServiceRestrictions;
import com.composum.sling.core.service.TranslationService;
import com.composum.sling.core.servlet.AbstractServiceServlet;
import com.composum.sling.core.servlet.ServletOperation;
import com.composum.sling.core.servlet.ServletOperationSet;
import com.composum.sling.core.servlet.Status;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(key="core/commons/translation")
@Component(service={Servlet.class, RestrictedService.class}, property={"service.description=Composum Nodes Translation Servlet", "sling.servlet.paths=/bin/cpm/core/translate", "sling.servlet.methods=PUT", "sling.auth.requirements=/bin/cpm/core/translate"})
public class TranslationServlet
extends AbstractServiceServlet {
    private static final Logger LOG = LoggerFactory.getLogger(TranslationServlet.class);
    public static final String SERVICE_KEY = "core/commons/translation";
    public static final String SERVLET_PATH = "/bin/cpm/core/translate";
    public static final String STATUS = "status";
    public static final String SUCCESS = "success";
    public static final String WARNING = "warning";
    public static final String TITLE = "title";
    public static final String MESSAGES = "messages";
    public static final String LEVEL = "level";
    public static final String CONTEXT = "context";
    public static final String LABEL = "label";
    public static final String TEXT = "text";
    public static final String HINT = "hint";
    public static final String DATA = "data";
    public static final String BOOTSTRAP_ERROR = "danger";
    protected ServletOperationSet<Extension, Operation> operations = new ServletOperationSet(Extension.json);
    @Reference
    private ServiceRestrictions restrictions;
    @Reference
    private CoreConfiguration coreConfig;
    @Reference
    private TranslationService translationService;

    @NotNull
    protected ServletOperationSet<Extension, Operation> getOperations() {
        return this.operations;
    }

    @Override
    @NotNull
    public ServiceRestrictions.Key getServiceKey() {
        return new ServiceRestrictions.Key(SERVICE_KEY);
    }

    @Override
    @NotNull
    protected ServiceRestrictions.Permission methodPutPermission(@NotNull SlingHttpServletRequest request) {
        return ServiceRestrictions.Permission.read;
    }

    public void init() throws ServletException {
        super.init();
        this.operations.setOperation(ServletOperationSet.Method.PUT, Extension.json, Operation.object, new TranslateObject());
        this.operations.setOperation(ServletOperationSet.Method.PUT, Extension.json, Operation.status, new TranslateStatus());
    }

    protected class TranslateStatus
    implements ServletOperation {
        public static final String BOOTSTRAP_ERROR = "danger";

        protected TranslateStatus() {
        }

        @Override
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @Nullable ResourceHandle resource) throws IOException {
            Status status = new Status(request, response);
            this.readFrom(request.getReader(), status);
            status.sendJson(200);
        }

        protected void readFrom(BufferedReader reader, Status status) {
            Map data = status.getGson().fromJson((Reader)reader, Map.class);
            Object value = data.get(TranslationServlet.TITLE);
            if (value != null) {
                status.setTitle(value.toString());
            }
            boolean success = false;
            value = data.get(TranslationServlet.SUCCESS);
            if (value instanceof Boolean) {
                success = (Boolean)value;
                if (success) {
                    status.setStatus(200);
                } else {
                    status.setStatus(400);
                    if (!status.hasTitle()) {
                        status.setTitle("Error");
                    }
                }
            }
            if ((value = data.get(TranslationServlet.WARNING)) instanceof Boolean) {
                status.setWarning((Boolean)value);
                if (success) {
                    status.setStatus(202);
                }
                if (!status.hasTitle()) {
                    status.setTitle("Warning");
                }
            }
            if ((value = data.get(TranslationServlet.STATUS)) != null) {
                status.setStatus(value instanceof Integer ? (Integer)value : Integer.parseInt(value.toString()));
            }
            if ((value = data.get(TranslationServlet.MESSAGES)) instanceof Collection) {
                for (Object val : (Collection)value) {
                    if (!(val instanceof Map)) continue;
                    status.addMessage(this.parseMessage((Map)val));
                }
            }
        }

        protected Message parseMessage(Map<String, Object> data) {
            Object hint = data.get(TranslationServlet.HINT);
            Object value = data.get(TranslationServlet.LEVEL);
            Message.Level level = value != null ? this.levelOf(value.toString()) : Message.Level.info;
            value = data.get(TranslationServlet.CONTEXT);
            String context = value != null ? value.toString() : null;
            value = data.get(TranslationServlet.LABEL);
            String label = value != null ? value.toString() : null;
            value = data.get(TranslationServlet.TEXT);
            String text = value != null ? value.toString() : "";
            return new Message(level, text, hint).setContext(context).setLabel(label);
        }

        @NotNull
        public Message.Level levelOf(@NotNull String name) {
            if ("danger".equalsIgnoreCase(name)) {
                name = Message.Level.error.name();
            }
            return Message.Level.valueOf(name);
        }
    }

    protected class TranslateObject
    implements ServletOperation {
        protected TranslateObject() {
        }

        @Override
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @Nullable ResourceHandle resource) throws IOException {
            response.setStatus(200);
            response.setContentType("application/json; charset=UTF-8");
            TranslationServlet.this.translationService.translate(request, request.getReader(), response.getWriter());
        }
    }

    public static enum Operation {
        object,
        status;

    }

    public static enum Extension {
        json;

    }
}

