/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.util;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceHandle<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceHandle.class);
    public static final long WAIT_TIMEOUT = 5000L;
    protected final Class<T> type;
    protected transient T service;
    protected transient InstanceTracker serviceTracker;

    @NotNull
    public T getService() {
        if (this.service == null) {
            BundleContext bundleContext;
            ServiceReference serviceReference;
            Bundle serviceBundle;
            if (this.serviceTracker == null && (serviceBundle = FrameworkUtil.getBundle(this.type)) != null && (serviceReference = (bundleContext = serviceBundle.getBundleContext()).getServiceReference(this.type)) != null) {
                this.serviceTracker = new InstanceTracker(bundleContext, serviceReference);
                this.serviceTracker.open();
            }
            if (this.serviceTracker != null) {
                this.service = this.serviceTracker.waitForService();
            }
            Objects.requireNonNull(this.service, "No service for type " + this.type);
        }
        return this.service;
    }

    public ServiceHandle(@NotNull Class<T> type) {
        this.type = type;
    }

    protected class InstanceTracker
    extends ServiceTracker<T, T> {
        public InstanceTracker(BundleContext context, ServiceReference<T> reference) {
            super(context, reference, null);
        }

        public T addingService(ServiceReference<T> reference) {
            ServiceHandle.this.service = super.addingService(reference);
            return ServiceHandle.this.service;
        }

        public void removedService(ServiceReference<T> reference, T service) {
            super.removedService(reference, service);
            ServiceHandle.this.service = null;
            ServiceHandle.this.serviceTracker = null;
            this.close();
        }

        public T waitForService() {
            try {
                return this.waitForService(5000L);
            }
            catch (InterruptedException tmex) {
                LOG.error("timeout on wait for service '{}' ({})", (Object)ServiceHandle.this.type.getName(), (Object)tmex.toString());
                ServiceHandle.this.serviceTracker = null;
                this.close();
                return null;
            }
        }
    }
}

