/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.util;

import com.composum.sling.core.util.LinkMapper;
import com.composum.sling.core.util.LinkUtil;
import com.composum.sling.core.util.UrlCodec;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingUrl
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(SlingUrl.class);
    public static final String SCHEME_PROTOCOL_RELATIVE_URL = "";
    protected static final Pattern SCHEME_PATTERN = Pattern.compile("(?i:(?<scheme>[a-zA-Z0-9+.-]+):)");
    protected static final Pattern HTTP_SCHEME_PATTERN = Pattern.compile("(?i:(?<scheme>https?):)");
    protected static final Pattern FILE_SCHEME_PATTERN = Pattern.compile("(?i:(?<scheme>(file|ftp)):)");
    protected static final Pattern USERNAMEPASSWORD = Pattern.compile("((?<username>[^:@/?#]+)(:(?<password>[^:@/?#]+))?@)");
    protected static final Pattern HTTP_URL_PATTERN = Pattern.compile("^" + HTTP_SCHEME_PATTERN.pattern() + "?(?<hostandport>//" + USERNAMEPASSWORD + "?((?<host>[^/:?#]+)(:(?<port>[0-9]+))?)?)?(?<pathnoext>(/([^/.;?#]+|\\.\\.))*/)((?<filenoext>[^/.?#;]+)((?<extensions>(\\.[^./;?#]+)+)(?<suffix>/[^;?#]*)?)?)?(?<query>\\?[^#]*)?(?<fragment>#.*)?$");
    protected static final Pattern FILE_URL_PATTERN = Pattern.compile("^" + FILE_SCHEME_PATTERN.pattern() + "?(?<hostandport>//" + USERNAMEPASSWORD + "?((?<host>[^/:?#]+)(:(?<port>[0-9]+))?)?)?(?<pathnoext>(/([^/.;?#]+|\\.\\.))*/)((?<filenoext>[^/.;?#]+)((?<extensions>(\\.[^./;?#]+)+)(?<suffix>/[^;?#]*)?)?)?(?<query>)(?<fragment>)$");
    protected static final Pattern ABSOLUTE_PATH_PATTERN = Pattern.compile("^(?<pathnoext>(/([^/.?]+|\\.\\.))*/)((?<filenoext>[^/.;?#]+)((?<extensions>(\\.[^./;?#]+)+)(?<suffix>/[^;?#]*)?)?)?(?<query>\\?[^#]*)?(?<fragment>#.*)?$");
    protected static final Pattern RELATIVE_PATH_PATTERN = Pattern.compile("^(?<pathnoext>([^/.;?#]+|\\.\\.)*/)?((?<filenoext>[^/.;?#]+)((?<extensions>(\\.[^./;?#]+)+)(?<suffix>/[^;?#]*)?)?)?(?<query>\\?[^#]*)?(?<fragment>#.*)?$");
    protected static final Pattern HTTP_SCHEME = Pattern.compile("^https?$", 2);
    protected static final Pattern FILE_SCHEME = Pattern.compile("^(file|ftp)$", 2);
    protected static final Pattern SPECIAL_SCHEME = Pattern.compile("^(mailto|tel|fax)$", 2);
    protected UrlType type;
    protected String scheme;
    protected String username;
    protected String password;
    protected String host;
    protected Integer port;
    protected String contextPath;
    protected String path;
    protected String name;
    protected final List<String> selectors = new ArrayList<String>();
    protected String extension;
    protected String suffix;
    protected final LinkedHashMap<String, List<String>> parameters = new LinkedHashMap();
    protected String fragment;
    private transient String url;
    protected transient String resourcePath;
    protected transient Resource resource;
    protected final SlingHttpServletRequest request;
    protected final LinkMapper linkMapper;

    public SlingUrl(@NotNull SlingHttpServletRequest request, @NotNull Resource resource) {
        this(request, resource, null, null);
    }

    public SlingUrl(@NotNull SlingHttpServletRequest request, @NotNull Resource resource, @Nullable String extension) {
        this(request, resource, null, extension, null, null, true, SlingUrl.getLinkMapper(request, null));
    }

    public SlingUrl(@NotNull SlingHttpServletRequest request, @NotNull Resource resource, @Nullable String selectors, @Nullable String extension) {
        this(request, resource, selectors, extension, null, null, true, SlingUrl.getLinkMapper(request, null));
    }

    public SlingUrl(@NotNull SlingHttpServletRequest request, @NotNull Resource resource, @Nullable String selectors, @Nullable String extension, @Nullable String suffix) {
        this(request, resource, selectors, extension, suffix, null, true, SlingUrl.getLinkMapper(request, null));
    }

    public SlingUrl(@NotNull SlingHttpServletRequest request, @NotNull Resource resource, @Nullable String selectors, @Nullable String extension, @Nullable String suffix, @Nullable String parameterString) {
        this(request, resource, selectors, extension, suffix, parameterString, true, SlingUrl.getLinkMapper(request, null));
    }

    public SlingUrl(@NotNull SlingHttpServletRequest request, @NotNull Resource resource, @Nullable String selectors, @Nullable String extension, @Nullable String suffix, @Nullable String parameterString, boolean decodeParameters, @Nullable LinkMapper linkMapper) {
        this.request = Objects.requireNonNull(request, "request required");
        this.linkMapper = linkMapper;
        this.resource = resource;
        this.resourcePath = resource.getPath();
        String escapedResourcePath = LinkUtil.namespacePrefixEscape(this.resourcePath);
        this.name = StringUtils.substringAfterLast((String)escapedResourcePath, (String)"/");
        this.path = escapedResourcePath.substring(0, escapedResourcePath.length() - this.name.length());
        this.type = UrlType.HTTP;
        this.setSelectors(selectors);
        this.setExtension(extension);
        this.setSuffix(suffix);
        this.setParameters(parameterString, decodeParameters);
    }

    public SlingUrl(@NotNull SlingHttpServletRequest request, @Nullable LinkMapper linkMapper) {
        this.request = Objects.requireNonNull(request, "request required");
        this.linkMapper = linkMapper;
    }

    public SlingUrl(@NotNull SlingHttpServletRequest request) {
        this(request, SlingUrl.getLinkMapper(request, null));
    }

    @Deprecated
    public SlingUrl(@NotNull SlingHttpServletRequest request, String url) {
        this(request);
        this.fromUrl(url);
    }

    @NotNull
    public SlingUrl fromUrl(@NotNull String url) {
        return this.fromUrl(url, true);
    }

    @NotNull
    public SlingUrl fromUrl(@NotNull String url, boolean decode) {
        this.parseUrl(url, decode);
        return this;
    }

    public SlingUrl fromUri(@NotNull URI uri) {
        boolean isSpecial;
        this.reset();
        boolean isHttp = uri.getScheme() != null && HTTP_SCHEME.matcher(uri.getScheme()).matches();
        boolean isFile = uri.getScheme() != null && FILE_SCHEME.matcher(uri.getScheme()).matches();
        boolean bl = isSpecial = uri.getScheme() != null && SPECIAL_SCHEME.matcher(uri.getScheme()).matches();
        if (isSpecial) {
            this.type = UrlType.SPECIAL;
            this.scheme = uri.getScheme();
            this.name = uri.getSchemeSpecificPart();
            if (uri.getFragment() != null) {
                this.name = this.name + "#" + uri.getFragment();
            }
        } else if (uri.isOpaque() || StringUtils.isNotBlank((CharSequence)uri.getScheme()) && !isFile && !isHttp) {
            this.type = UrlType.OTHER;
            this.scheme = uri.getScheme();
            this.name = uri.getRawSchemeSpecificPart();
            if (uri.getRawFragment() != null) {
                this.name = this.name + "#" + uri.getRawFragment();
            }
        } else {
            Matcher matcher = ABSOLUTE_PATH_PATTERN.matcher(uri.getRawPath());
            if (matcher.matches()) {
                this.assignFromGroups(matcher, true, false);
            } else {
                matcher = RELATIVE_PATH_PATTERN.matcher(uri.getRawPath());
                if (matcher.matches()) {
                    this.assignFromGroups(matcher, true, false);
                } else {
                    this.reset();
                    this.type = UrlType.OTHER;
                    this.name = uri.getRawSchemeSpecificPart();
                    this.fragment = (String)StringUtils.defaultIfBlank((CharSequence)uri.getRawFragment(), null);
                }
            }
            this.scheme = uri.getScheme();
            if (this.scheme == null && StringUtils.isNotBlank((CharSequence)uri.getHost())) {
                this.scheme = SCHEME_PROTOCOL_RELATIVE_URL;
            }
            if (this.type != UrlType.OTHER) {
                this.host = uri.getHost();
                if (uri.getPort() >= 0) {
                    this.port = uri.getPort();
                }
                if (this.scheme == null && !StringUtils.startsWith((CharSequence)uri.getSchemeSpecificPart(), (CharSequence)"/")) {
                    this.type = UrlType.RELATIVE;
                } else {
                    UrlType urlType = this.type = isFile ? UrlType.FILE : UrlType.HTTP;
                }
                if (uri.getUserInfo() != null) {
                    this.username = (String)StringUtils.defaultIfBlank((CharSequence)StringUtils.substringBefore((String)uri.getUserInfo(), (String)":"), null);
                    this.password = (String)StringUtils.defaultIfBlank((CharSequence)StringUtils.substringAfter((String)uri.getUserInfo(), (String)":"), null);
                }
                this.fragment = uri.getFragment();
                if (uri.getRawQuery() != null) {
                    this.parseParameters(uri.getRawQuery(), true);
                }
            }
        }
        return this;
    }

    public SlingUrl fromPathOrUrl(@NotNull String pathOrUrl, boolean decode) {
        if (this.isAbsolutePath(pathOrUrl)) {
            return this.fromPath(pathOrUrl);
        }
        return this.fromUrl(pathOrUrl, true);
    }

    public SlingUrl fromPathOrUrl(@NotNull String pathOrUrl) {
        if (this.isAbsolutePath(pathOrUrl)) {
            return this.fromPath(pathOrUrl);
        }
        return this.fromUrl(pathOrUrl, true);
    }

    protected boolean isAbsolutePath(String pathOrUrl) {
        return StringUtils.startsWith((CharSequence)pathOrUrl, (CharSequence)"/") && !StringUtils.startsWith((CharSequence)pathOrUrl, (CharSequence)"//");
    }

    @NotNull
    public SlingUrl fromPath(@NotNull String resourcePath) {
        this.reset();
        this.type = resourcePath.startsWith("/") ? UrlType.HTTP : UrlType.RELATIVE;
        this.setResourcePath(resourcePath);
        return this;
    }

    @NotNull
    public SlingUrl fromRequest(HttpServletRequest request) {
        StringBuffer url = request.getRequestURL();
        String query = request.getQueryString();
        if (StringUtils.isNotBlank((CharSequence)query)) {
            url.append('?').append(query);
        }
        return this.fromUrl(url.toString(), true);
    }

    @NotNull
    public SlingHttpServletRequest getRequest() {
        return this.request;
    }

    public boolean isExternal() {
        return this.scheme != null;
    }

    @Nullable
    public String getResourcePath() {
        if (this.resourcePath == null && !this.isExternal() && this.type == UrlType.HTTP) {
            String candidateResourcePath;
            ResourceResolver resolver = this.request.getResourceResolver();
            this.resourcePath = candidateResourcePath = LinkUtil.namespacePrefixUnescape(StringUtils.defaultString((String)this.path) + StringUtils.defaultString((String)this.name));
            if (StringUtils.isNotBlank((CharSequence)this.extension)) {
                this.resourcePath = this.resourcePath + '.' + this.extension;
            }
            this.resource = resolver.getResource(this.resourcePath);
            if (this.resource == null) {
                this.resourcePath = candidateResourcePath;
                this.resource = resolver.getResource(this.resourcePath);
            }
        }
        return this.resourcePath;
    }

    @Nullable
    public Resource getResource() {
        this.getResourcePath();
        return this.resource;
    }

    @Nullable
    public String getContextPath() {
        return StringUtils.isNotBlank((CharSequence)this.contextPath) ? this.contextPath : this.request.getContextPath();
    }

    @NotNull
    public String getPathAndName() {
        return StringUtils.defaultString((String)this.path) + StringUtils.defaultString((String)this.name);
    }

    @NotNull
    public String getPathAndNameExt() {
        return StringUtils.defaultString((String)this.path) + StringUtils.defaultString((String)this.name) + (StringUtils.isNotBlank((CharSequence)this.extension) ? "." + this.extension : SCHEME_PROTOCOL_RELATIVE_URL);
    }

    public SlingUrl setPathAndNameExt(@Nullable String fullpath) {
        this.path = null;
        this.name = null;
        this.extension = null;
        this.clearTransients();
        if (StringUtils.isNotBlank((CharSequence)fullpath)) {
            int period;
            if (this.type == null) {
                this.type = fullpath.startsWith("/") ? UrlType.HTTP : UrlType.RELATIVE;
            }
            int endpath = fullpath.lastIndexOf(47);
            String newPath = null;
            String newName = null;
            String newExtension = null;
            if (endpath >= 0) {
                newPath = fullpath.substring(0, endpath + 1);
                fullpath = fullpath.substring(endpath + 1);
            }
            if ((period = fullpath.lastIndexOf(46)) >= 0) {
                newName = fullpath.substring(0, period);
                newExtension = fullpath.substring(period + 1);
            }
            this.path = newPath;
            this.name = newName;
            this.extension = newExtension;
        }
        return this;
    }

    public SlingUrl setPathAndName(@Nullable String fullpath) {
        return this.setResourcePath(this.resourcePath);
    }

    public SlingUrl setResourcePath(@Nullable String resourcePath) {
        this.path = null;
        this.name = null;
        this.clearTransients();
        if (StringUtils.isNotBlank((CharSequence)resourcePath)) {
            String escapedPath = LinkUtil.namespacePrefixEscape(resourcePath);
            int endpath = escapedPath.lastIndexOf(47);
            String newPath = null;
            String newName = escapedPath;
            if (endpath >= 0) {
                newPath = escapedPath.substring(0, endpath + 1);
                newName = escapedPath.substring(endpath + 1);
            }
            this.path = newPath;
            this.name = newName;
        }
        return this;
    }

    public SlingUrl resourcePath(@Nullable String resourcePath) {
        return this.setResourcePath(resourcePath);
    }

    @NotNull
    List<String> getSelectors() {
        return this.selectors;
    }

    public SlingUrl selector(String ... value) {
        return this.addSelector(value);
    }

    public SlingUrl addSelector(String ... value) {
        this.clearTransients();
        if (value != null) {
            this.selectors.addAll(Arrays.asList(value));
        }
        return this;
    }

    public SlingUrl setSelector(String ... value) {
        this.clearSelectors();
        this.addSelector(value);
        return this;
    }

    public SlingUrl selectors(@Nullable String selectors) {
        return this.setSelectors(selectors);
    }

    public SlingUrl setSelectors(@Nullable String selectors) {
        this.clearSelectors();
        if (selectors != null) {
            for (String sel : StringUtils.split((String)selectors, (char)'.')) {
                if (!StringUtils.isNotBlank((CharSequence)sel)) continue;
                this.selectors.add(sel);
            }
        }
        return this;
    }

    public SlingUrl removeSelector(String ... value) {
        this.clearTransients();
        if (value != null) {
            for (String val : value) {
                this.selectors.remove(val);
            }
        }
        return this;
    }

    public SlingUrl clearSelectors() {
        this.clearTransients();
        this.selectors.clear();
        return this;
    }

    @Nullable
    public String getExtension() {
        return this.extension;
    }

    public SlingUrl extension(@Nullable String extension) {
        return this.setExtension(extension);
    }

    public SlingUrl setExtension(@Nullable String extension) {
        int dot;
        if (extension != null && (dot = extension.lastIndexOf(".")) >= 0) {
            extension = extension.substring(dot + 1);
        }
        this.extension = extension;
        this.clearTransients();
        return this;
    }

    @Nullable
    public String getSuffix() {
        return this.suffix;
    }

    public SlingUrl suffix(@Nullable Resource resource) {
        return this.setSuffix(resource != null ? resource.getPath() : null);
    }

    public SlingUrl suffix(@Nullable Resource resource, @Nullable String extension) {
        return this.setSuffix(resource != null ? resource.getPath() + (StringUtils.isNotBlank((CharSequence)extension) ? "." + extension : SCHEME_PROTOCOL_RELATIVE_URL) : null);
    }

    public SlingUrl suffix(@Nullable String suffix) {
        return this.setSuffix(suffix);
    }

    public SlingUrl setSuffix(@Nullable String suffix) {
        this.suffix = suffix;
        this.clearTransients();
        return this;
    }

    @Nullable
    public String getParameter(@NotNull String name) {
        List<String> values = this.parameters.get(name);
        return values != null ? (values.size() > 0 ? values.get(0) : SCHEME_PROTOCOL_RELATIVE_URL) : null;
    }

    @Nullable
    public List<String> getParameterValues(@NotNull String name) {
        List<String> values = this.parameters.get(name);
        return values != null ? Collections.unmodifiableList(values) : null;
    }

    @NotNull
    public Map<String, List<String>> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public SlingUrl parameter(String name, String ... value) {
        return this.addParameter(name, value);
    }

    public SlingUrl addParameter(String name, String ... value) {
        this.clearTransients();
        List values = this.parameters.computeIfAbsent(name, k -> new ArrayList());
        if (value != null) {
            for (String val : value) {
                if (val == null) continue;
                values.add(val);
            }
        }
        return this;
    }

    public SlingUrl addParameters(String parameterString, boolean decode) {
        if (parameterString != null) {
            this.parseParameters(parameterString, decode);
        }
        return this;
    }

    public SlingUrl setParameter(String name, String ... value) {
        this.removeParameter(name);
        this.addParameter(name, value);
        return this;
    }

    public SlingUrl parameters(String parameterString) {
        return this.setParameters(parameterString, true);
    }

    public SlingUrl setParameters(String parameterString, boolean decode) {
        this.clearParameters();
        this.addParameters(parameterString, decode);
        return this;
    }

    public SlingUrl removeParameter(String name) {
        this.clearTransients();
        this.parameters.remove(name);
        return this;
    }

    public SlingUrl clearParameters() {
        this.clearTransients();
        this.parameters.clear();
        return this;
    }

    @Nullable
    public String getFragment() {
        return this.fragment;
    }

    @NotNull
    public SlingUrl setFragment(@Nullable String fragment) {
        return this.fragment(fragment);
    }

    @NotNull
    public SlingUrl fragment(@Nullable String fragment) {
        this.fragment = fragment;
        this.clearTransients();
        return this;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object other) {
        return other != null && this.toString().equals(other.toString());
    }

    public String toString() {
        return this.getUrl();
    }

    public String getUrl() {
        if (this.url == null) {
            this.url = this.buildUrl();
        }
        return this.url;
    }

    protected void clearTransients() {
        this.url = null;
        this.resource = null;
        this.resourcePath = null;
    }

    @Nullable
    public String getScheme() {
        return this.scheme;
    }

    @NotNull
    public SlingUrl setScheme(@Nullable String scheme) {
        return this.scheme(scheme);
    }

    @NotNull
    public SlingUrl scheme(@Nullable String scheme) {
        this.scheme = scheme;
        this.clearTransients();
        return this;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @NotNull
    public SlingUrl setUsername(@Nullable String username) {
        return this.username(username);
    }

    @NotNull
    public SlingUrl username(@Nullable String username) {
        this.username = username;
        this.clearTransients();
        return this;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @NotNull
    public SlingUrl setPassword(@Nullable String password) {
        return this.password(password);
    }

    @NotNull
    public SlingUrl password(@Nullable String password) {
        this.password = password;
        this.clearTransients();
        return this;
    }

    @Nullable
    public String getHost() {
        return this.host;
    }

    @NotNull
    public SlingUrl setHost(@Nullable String host) {
        return this.host(host);
    }

    @NotNull
    public SlingUrl host(@Nullable String host) {
        this.host = host;
        this.clearTransients();
        return this;
    }

    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @NotNull
    public SlingUrl setPort(@Nullable Integer port) {
        return this.port(port);
    }

    @NotNull
    public SlingUrl port(@Nullable Integer port) {
        this.port = port;
        this.clearTransients();
        return this;
    }

    @NotNull
    public UrlType getType() {
        return this.type;
    }

    @NotNull
    public SlingUrl setType(@NotNull UrlType type) {
        return this.type(type);
    }

    @NotNull
    public SlingUrl type(@NotNull UrlType type) {
        this.type = Objects.requireNonNull(type);
        this.clearTransients();
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @NotNull
    public SlingUrl setName(@Nullable String name) {
        return this.name(name);
    }

    @NotNull
    public SlingUrl name(@Nullable String name) {
        this.name = name;
        this.clearTransients();
        return this;
    }

    public SlingUrl clone() {
        try {
            return (SlingUrl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException("Bug: clone threw error for " + this.getClass().toString(), e);
        }
    }

    public void reset() {
        this.type = null;
        this.scheme = null;
        this.host = null;
        this.port = null;
        this.contextPath = null;
        this.path = null;
        this.name = null;
        this.selectors.clear();
        this.extension = null;
        this.suffix = null;
        this.parameters.clear();
        this.fragment = null;
        this.clearTransients();
        this.resourcePath = null;
        this.resource = null;
    }

    protected String buildUrl() {
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.scheme)) {
            builder.append(this.scheme).append(':');
        }
        if (this.type == null) {
            LOG.error("NO TYPE! {}", (Object)this.toDebugString());
        } else if (this.type == UrlType.OTHER) {
            builder.append(this.name);
        } else if (this.type == UrlType.SPECIAL) {
            builder.append(UrlCodec.OPAQUE.encode(this.name));
        } else {
            if (this.scheme != null) {
                builder.append("//");
            }
            if (StringUtils.isNotBlank((CharSequence)this.host)) {
                if (StringUtils.isNotBlank((CharSequence)this.username)) {
                    builder.append(UrlCodec.AUTHORITY.encode(this.username));
                    if (StringUtils.isNotBlank((CharSequence)this.password)) {
                        builder.append(":").append(UrlCodec.AUTHORITY.encode(this.password));
                    }
                    builder.append("@");
                }
                builder.append(UrlCodec.AUTHORITY.encode(this.host));
                if (this.port != null) {
                    builder.append(":").append(this.port);
                }
            }
            String pathAndName = StringUtils.defaultString((String)this.path) + StringUtils.defaultString((String)this.name);
            if (this.isExternal()) {
                pathAndName = UrlCodec.PATH.encode(pathAndName);
            } else if (this.linkMapper != null && this.type != UrlType.RELATIVE) {
                pathAndName = this.linkMapper.mapUri(this.request, LinkUtil.namespacePrefixUnescape(pathAndName));
                pathAndName = LinkUtil.adjustMappedUrl(this.request, pathAndName);
            } else {
                pathAndName = LinkUtil.encodePath(pathAndName);
            }
            builder.append(pathAndName);
            for (String value : this.selectors) {
                builder.append('.').append(UrlCodec.PATH.encode(value));
            }
            if (StringUtils.isNotBlank((CharSequence)this.extension)) {
                builder.append('.').append(UrlCodec.PATH.encode(this.extension));
            }
            if (StringUtils.isNotBlank((CharSequence)this.suffix)) {
                builder.append(this.isExternal() ? UrlCodec.PATH.encode(this.suffix) : LinkUtil.encodePath(this.suffix));
            }
            if (this.parameters.size() > 0) {
                int index = 0;
                for (Map.Entry<String, List<String>> param : this.parameters.entrySet()) {
                    String paramName = param.getKey();
                    List<String> values = param.getValue();
                    if (values.size() > 0) {
                        for (String val : values) {
                            builder.append(index == 0 ? (char)'?' : '&');
                            builder.append(UrlCodec.QUERYPART.encode(paramName));
                            if (val != null) {
                                builder.append("=").append(UrlCodec.QUERYPART.encode(val));
                            }
                            ++index;
                        }
                        continue;
                    }
                    builder.append(index == 0 ? (char)'?' : '&');
                    builder.append(UrlCodec.QUERYPART.encode(paramName));
                    ++index;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)this.fragment)) {
                builder.append('#').append(UrlCodec.FRAGMENT.encode(this.fragment));
            }
        }
        return builder.toString();
    }

    protected void parseUrl(@NotNull String url, boolean decode) throws IllegalArgumentException {
        this.reset();
        Matcher schemeMatcher = SCHEME_PATTERN.matcher(url);
        int schemeLength = 0;
        if (schemeMatcher.lookingAt()) {
            this.scheme = schemeMatcher.group("scheme");
            schemeLength = schemeMatcher.end();
        } else if (url.startsWith("//")) {
            this.scheme = SCHEME_PROTOCOL_RELATIVE_URL;
            schemeLength = 0;
        }
        boolean other = false;
        if (this.scheme != null) {
            if (HTTP_SCHEME.matcher(this.scheme).matches() || SCHEME_PROTOCOL_RELATIVE_URL.equals(this.scheme)) {
                Matcher matcher = HTTP_URL_PATTERN.matcher(url);
                if (matcher.matches()) {
                    this.type = UrlType.HTTP;
                    this.assignFromGroups(matcher, decode, true);
                } else {
                    other = true;
                }
            } else if (FILE_SCHEME.matcher(this.scheme).matches()) {
                Matcher matcher = FILE_URL_PATTERN.matcher(url);
                if (matcher.matches()) {
                    this.type = UrlType.FILE;
                    this.assignFromGroups(matcher, decode, true);
                } else {
                    other = true;
                }
            } else if (SPECIAL_SCHEME.matcher(this.scheme).matches()) {
                this.type = UrlType.SPECIAL;
                this.name = this.decode(url.substring(schemeMatcher.end()), decode);
            } else {
                other = true;
            }
        } else {
            Matcher matcher = ABSOLUTE_PATH_PATTERN.matcher(url);
            if (matcher.matches()) {
                this.type = UrlType.HTTP;
                this.assignFromGroups(matcher, decode, false);
            } else {
                matcher = RELATIVE_PATH_PATTERN.matcher(url);
                if (matcher.matches()) {
                    this.type = UrlType.RELATIVE;
                    this.assignFromGroups(matcher, decode, false);
                } else {
                    other = true;
                }
            }
        }
        if (other) {
            this.type = UrlType.OTHER;
            this.name = url.substring(schemeLength);
        }
    }

    protected void assignFromGroups(Matcher matcher, boolean decode, boolean hostAndPort) {
        String value;
        if (hostAndPort) {
            value = matcher.group("host");
            if (StringUtils.isNotBlank((CharSequence)value)) {
                this.host = value;
            }
            if (StringUtils.isNotBlank((CharSequence)(value = matcher.group("port")))) {
                this.port = Integer.parseInt(value);
            }
            if (StringUtils.isNotBlank((CharSequence)(value = matcher.group("username")))) {
                this.username = value;
            }
            if (StringUtils.isNotBlank((CharSequence)(value = matcher.group("password")))) {
                this.password = value;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(value = matcher.group("pathnoext")))) {
            this.path = this.decode(value, decode);
            String contextPath = this.request.getContextPath();
            if (StringUtils.isNotBlank((CharSequence)contextPath) && this.path.startsWith(contextPath + "/")) {
                this.contextPath = contextPath;
                this.path = this.path.substring(contextPath.length());
            }
        }
        this.name = StringUtils.isNotBlank((CharSequence)(value = matcher.group("filenoext"))) ? this.decode(value, decode) : null;
        value = matcher.group("extensions");
        if (StringUtils.isNotBlank((CharSequence)value)) {
            String[] selExt = StringUtils.split((String)value.substring(1), (char)'.');
            for (int i = 0; i < selExt.length - 1; ++i) {
                this.selectors.add(this.decode(selExt[i], decode));
            }
            this.extension = this.decode(selExt[selExt.length - 1], decode);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = matcher.group("suffix")))) {
            this.suffix = this.decode(value, decode);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = matcher.group("query")))) {
            this.parseParameters(value, decode);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = matcher.group("fragment")))) {
            this.fragment = this.decode(value, decode).substring(1);
        }
    }

    protected String decode(String value, boolean decode) {
        return decode ? UrlCodec.URLSAFE.decode(value) : value;
    }

    protected void parseParameters(@NotNull String parameterString, boolean decode) {
        parameterString = parameterString.trim();
        while (parameterString.startsWith("?")) {
            parameterString = parameterString.substring(1);
        }
        for (String param : StringUtils.split((String)parameterString, (char)'&')) {
            int delimiterPos = param.indexOf(61);
            String name = delimiterPos < 0 ? param : param.substring(0, delimiterPos);
            String value = delimiterPos < 0 ? null : param.substring(delimiterPos + 1);
            String[] stringArray = new String[1];
            stringArray[0] = value != null ? (decode ? UrlCodec.QUERYPART.decode(value) : value) : null;
            this.addParameter(decode ? UrlCodec.QUERYPART.decode(name) : name, stringArray);
        }
    }

    protected static LinkMapper getLinkMapper(@NotNull SlingHttpServletRequest request, @Nullable LinkMapper linkMapper) {
        if (linkMapper == null && (linkMapper = (LinkMapper)request.getAttribute(LinkMapper.LINK_MAPPER_REQUEST_ATTRIBUTE)) == null) {
            linkMapper = LinkMapper.RESOLVER;
        }
        return linkMapper;
    }

    public String toDebugString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        if (this.type != null) {
            builder.append("type", (Object)this.type);
        }
        if (this.scheme != null) {
            builder.append("scheme", (Object)this.scheme);
        }
        if (this.username != null) {
            builder.append("username", (Object)this.username);
        }
        if (this.password != null) {
            builder.append("password", (Object)this.password);
        }
        if (this.host != null) {
            builder.append("host", (Object)this.host);
        }
        if (this.port != null) {
            builder.append("port", (Object)this.port);
        }
        if (this.path != null) {
            builder.append("path", (Object)this.path);
        }
        if (this.name != null) {
            builder.append("name", (Object)this.name);
        }
        if (!this.selectors.isEmpty()) {
            builder.append("selectors", this.selectors);
        }
        if (this.extension != null) {
            builder.append("extension", (Object)this.extension);
        }
        if (this.suffix != null) {
            builder.append("suffix", (Object)this.suffix);
        }
        if (!this.parameters.isEmpty()) {
            builder.append("parameters", this.parameters);
        }
        if (this.fragment != null) {
            builder.append("fragment", (Object)this.fragment);
        }
        if (this.isExternal()) {
            builder.append("external", true);
        }
        if (this.getResourcePath() != null) {
            builder.append("resourcePath", (Object)this.resourcePath);
        }
        return builder.toString();
    }

    public static enum UrlType {
        HTTP,
        FILE,
        RELATIVE,
        SPECIAL,
        OTHER;

    }
}

