/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagFilteringWriter
extends FilterWriter {
    public static final String[] DEFAULT_TO_RENAME = new String[0];
    public static final String[] DEFAULT_TO_STRIP = new String[]{"html", "body"};
    public static final String[] DEFAULT_TO_DROP = new String[]{"head", "title", "meta", "link", "style", "script"};
    public static final String[] DEFAULT_TO_CLOSE = new String[]{"meta", "link", "input"};
    protected final Writer wrappedWriter;
    protected final Map<String, String> toRename;
    protected final List<String> toStrip;
    protected final List<String> toDrop;
    protected final List<String> autoClose;
    protected Stack<TagWriter> filterStack = new Stack();

    protected TagFilter createFilter(@Nullable TagFilter parent, @NotNull String tagName) throws IOException {
        String newTagName = this.toRename.get(tagName.toLowerCase());
        if (StringUtils.isNotBlank((CharSequence)newTagName)) {
            return new PassTagFilter(parent, newTagName);
        }
        if (this.toStrip.contains(tagName.toLowerCase())) {
            return new StripTagFilter(parent, tagName);
        }
        if (this.toDrop.contains(tagName.toLowerCase())) {
            return new DropTagFilter(parent, tagName);
        }
        return new PassTagFilter(parent, tagName);
    }

    public TagFilteringWriter(@NotNull Writer writer, @NotNull String[] toRename, @NotNull String[] toStrip, @NotNull String[] toDrop, @NotNull String[] autoClose) {
        super(writer);
        this.wrappedWriter = writer;
        this.toRename = new HashMap<String, String>();
        for (String rule : toRename) {
            if (!StringUtils.isNotBlank((CharSequence)rule)) continue;
            String[] split = StringUtils.split((String)rule, (String)":", (int)2);
            this.toRename.put(split[0], split[1]);
        }
        this.toStrip = Arrays.asList(toStrip);
        this.toDrop = Arrays.asList(toDrop);
        this.autoClose = Arrays.asList(autoClose);
        this.filterStack.push(new TextWriter(null));
    }

    public TagFilteringWriter(@NotNull OutputStream out, @NotNull String[] toRename, @NotNull String[] toStrip, @NotNull String[] toDrop, @NotNull String[] autoClose) {
        this(new OutputStreamWriter(out, StandardCharsets.UTF_8), toRename, toStrip, toDrop, autoClose);
    }

    public TagFilteringWriter(@NotNull OutputStream out) {
        this(out, DEFAULT_TO_RENAME, DEFAULT_TO_STRIP, DEFAULT_TO_DROP, DEFAULT_TO_CLOSE);
    }

    public TagFilteringWriter(@NotNull Writer writer) {
        this(writer, DEFAULT_TO_RENAME, DEFAULT_TO_STRIP, DEFAULT_TO_DROP, DEFAULT_TO_CLOSE);
    }

    @Override
    public void flush() throws IOException {
        while (!this.filterStack.isEmpty()) {
            this.filterStack.peek().flush();
            this.filterStack.pop();
        }
        super.flush();
    }

    @Override
    public void write(int chr) throws IOException {
        this.filterStack.peek().write(chr);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.write(str.toCharArray(), off, len);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        for (int count = 0; count < len; ++count) {
            this.write(cbuf[off + count]);
        }
    }

    public void pass(String str) throws IOException {
        this.wrappedWriter.write(str);
    }

    public void pass(String str, int off, int len) throws IOException {
        this.wrappedWriter.write(str, off, len);
    }

    public void pass(char[] cbuf, int off, int len) throws IOException {
        this.wrappedWriter.write(cbuf, off, len);
    }

    public void pass(int chr) throws IOException {
        this.wrappedWriter.write(chr);
    }

    public class TextWriter
    extends TagWriter {
        public TextWriter(TagWriter parent) {
            super(parent);
        }

        @Override
        public void write(int chr) throws IOException {
            switch (chr) {
                case 60: {
                    TagFilteringWriter.this.filterStack.push(new TagWriter(this));
                    break;
                }
                default: {
                    TagFilteringWriter.this.pass(chr);
                }
            }
        }

        @Override
        public void flush() throws IOException {
        }
    }

    public class TagWriter {
        protected final TagWriter parent;
        protected StringBuilder tagName = new StringBuilder();
        protected TagFilter tagFilter = null;

        public TagWriter(TagWriter parent) {
            this.parent = parent;
        }

        public void write(int chr) throws IOException {
            switch (chr) {
                case 60: {
                    TagFilteringWriter.this.filterStack.push(new TagWriter(this));
                    break;
                }
                case 32: 
                case 47: {
                    if (this.tagName.length() == 0) {
                        TagFilteringWriter.this.filterStack.pop();
                        TagWriter parent = TagFilteringWriter.this.filterStack.peek();
                        if (parent.tagFilter != null) {
                            parent.tagFilter.setState(TagFilter.State.tagtail);
                            return;
                        }
                    }
                }
                case 62: {
                    if (this.tagFilter == null) {
                        this.tagFilter = TagFilteringWriter.this.createFilter(this.parent != null ? this.parent.tagFilter : null, this.tagName.toString());
                    }
                }
                default: {
                    if (this.tagFilter == null) {
                        this.tagName.append((char)chr);
                        break;
                    }
                    if (!this.tagFilter.write((char)chr)) break;
                    TagFilteringWriter.this.filterStack.pop();
                }
            }
        }

        public void flush() throws IOException {
            if (this.tagFilter == null) {
                TagFilteringWriter.this.pass("<" + this.tagName);
            } else {
                this.tagFilter.flush();
            }
        }
    }

    protected class DropTagFilter
    extends StripTagFilter {
        public DropTagFilter(@NotNull TagFilter parent, String tagName) throws IOException {
            super(parent, tagName);
        }

        @Override
        public void writeBody(@NotNull String snippet) {
        }
    }

    protected class StripTagFilter
    extends PassTagFilter {
        public StripTagFilter(@NotNull TagFilter parent, String tagName) throws IOException {
            super(parent, tagName);
        }

        @Override
        public void writeHead(@NotNull String snippet) {
        }

        @Override
        public void writeTail(@Nullable String snippet) {
        }
    }

    protected class PassTagFilter
    implements TagFilter {
        protected final TagFilter parent;
        protected String tagName;
        protected TagFilter.State state = TagFilter.State.taghead;
        protected int token = 0;

        public PassTagFilter(@NotNull TagFilter parent, String tagName) throws IOException {
            this.parent = parent;
            this.tagName = tagName;
            this.writeHead("<" + tagName);
        }

        @Override
        public void setState(TagFilter.State state) {
            this.state = state;
        }

        @Override
        public void writeHead(@NotNull String snippet) throws IOException {
            if (this.parent != null) {
                this.parent.writeBody(snippet);
            } else {
                TagFilteringWriter.this.pass(snippet);
            }
        }

        @Override
        public void writeBody(@NotNull String snippet) throws IOException {
            if (this.parent != null) {
                this.parent.writeBody(snippet);
            } else {
                TagFilteringWriter.this.pass(snippet);
            }
        }

        @Override
        public void writeTail(@Nullable String snippet) throws IOException {
            if (snippet == null) {
                String string = snippet = StringUtils.isNotBlank((CharSequence)this.tagName) ? "</" + this.tagName + ">" : ">";
            }
            if (this.parent != null) {
                this.parent.writeBody(snippet);
            } else {
                TagFilteringWriter.this.pass(snippet);
            }
        }

        @Override
        public boolean write(char chr) throws IOException {
            block0 : switch (this.state) {
                case attribute: {
                    this.writeHead("" + chr);
                    if (chr != this.token) break;
                    this.state = TagFilter.State.taghead;
                    this.token = 0;
                    break;
                }
                case taghead: {
                    switch (chr) {
                        case '\"': 
                        case '\'': {
                            this.state = TagFilter.State.attribute;
                            this.token = chr;
                            this.writeHead("" + chr);
                            break block0;
                        }
                        case '>': {
                            if (TagFilteringWriter.this.autoClose.contains(this.tagName)) {
                                this.writeHead(">");
                                return true;
                            }
                            this.state = TagFilter.State.tagbody;
                        }
                        default: {
                            this.writeHead("" + chr);
                            break block0;
                        }
                        case '/': 
                    }
                    this.writeHead("" + chr);
                    this.state = TagFilter.State.tagtail;
                    this.tagName = "";
                    break;
                }
                case tagbody: {
                    this.writeBody("" + chr);
                    break;
                }
                case tagtail: {
                    if (chr != '>') break;
                    this.writeTail(null);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void flush() throws IOException {
        }
    }

    static interface TagFilter {
        public void setState(State var1);

        public void writeHead(@NotNull String var1) throws IOException;

        public void writeBody(@NotNull String var1) throws IOException;

        public void writeTail(@Nullable String var1) throws IOException;

        public boolean write(char var1) throws IOException;

        public void flush() throws IOException;

        public static enum State {
            taghead,
            attribute,
            tagbody,
            tagtail;

        }
    }
}

