/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.util;

import com.composum.sling.core.util.ValueEmbeddingReader;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Formatter;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueEmbeddingWriter
extends FilterWriter {
    protected final Writer wrappedWriter;
    protected final ValueMap values;
    protected final Locale locale;
    protected final Class<?> resourceContext;
    protected final ResourceBundle resourceBundle;
    protected boolean keepUnresolvable = false;
    protected final Stack<TokenWriter> writerStack = new Stack();

    public ValueEmbeddingWriter(@NotNull Writer writer, @NotNull Map<String, Object> values) {
        this(writer, values, null, null, null);
    }

    public ValueEmbeddingWriter(@NotNull Writer writer, @NotNull Map<String, Object> values, @Nullable Locale locale, @Nullable Class<?> resourceContext) {
        this(writer, values, locale, resourceContext, null);
    }

    public ValueEmbeddingWriter(@NotNull Writer writer, @NotNull Map<String, Object> values, @Nullable Locale locale, @Nullable Class<?> resourceContext, @Nullable ResourceBundle resourceBundle) {
        super(writer);
        this.wrappedWriter = writer;
        this.values = values instanceof ValueMap ? (ValueMap)values : new ValueMapDecorator(values);
        this.locale = locale != null ? locale : Locale.getDefault();
        this.resourceContext = resourceContext != null ? resourceContext : values.getClass();
        this.resourceBundle = resourceBundle;
        this.writerStack.push(new TextWriter());
    }

    public boolean isKeepUnresolvable(boolean ... decision) {
        return decision.length > 0 ? (this.keepUnresolvable = decision[0]) : this.keepUnresolvable;
    }

    @Override
    public void flush() throws IOException {
        while (!this.writerStack.isEmpty()) {
            this.writerStack.peek().flush();
            this.writerStack.pop();
        }
        super.flush();
    }

    @Override
    public void write(int token) throws IOException {
        if (this.writerStack.peek().write((char)token)) {
            this.writerStack.pop();
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.write(str.toCharArray(), off, len);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        for (int count = 0; count < len; ++count) {
            this.write(cbuf[off + count]);
        }
    }

    public void pass(String str) throws IOException {
        this.wrappedWriter.write(str);
    }

    public void pass(String str, int off, int len) throws IOException {
        this.wrappedWriter.write(str, off, len);
    }

    public void pass(char[] cbuf, int off, int len) throws IOException {
        this.wrappedWriter.write(cbuf, off, len);
    }

    public void pass(int chr) throws IOException {
        this.wrappedWriter.write(chr);
    }

    protected class ValueWriter
    implements TokenWriter {
        protected StringBuilder keyBuffer = null;

        protected ValueWriter() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean write(char token) throws IOException {
            switch (token) {
                case '{': {
                    if (this.keyBuffer == null) {
                        this.keyBuffer = new StringBuilder();
                        return false;
                    }
                    if (this.keyBuffer.length() != 0) return false;
                    ValueEmbeddingWriter.this.pass("${{");
                    return true;
                }
                case '}': {
                    if (this.keyBuffer == null) {
                        ValueEmbeddingWriter.this.pass("$}");
                        return true;
                    }
                    if (this.keyBuffer.length() == 0) {
                        ValueEmbeddingWriter.this.pass("${}");
                        return true;
                    }
                    ValueEmbeddingReader.Key key = new ValueEmbeddingReader.Key(this.keyBuffer.toString().trim());
                    if ("resource".equals(key.type)) {
                        if (ValueEmbeddingWriter.this.resourceContext != null) {
                            try (InputStream stream = ValueEmbeddingWriter.this.resourceContext.getResourceAsStream(key.name);
                                 InputStreamReader reader = stream != null ? new InputStreamReader(stream, StandardCharsets.UTF_8) : null;){
                                this.embed(key, reader);
                                return true;
                            }
                        }
                        if (!ValueEmbeddingWriter.this.keepUnresolvable) return true;
                        ValueEmbeddingWriter.this.pass("${" + key + "}");
                        return true;
                    }
                    Object value = ValueEmbeddingWriter.this.values.get((Object)key.name);
                    if (value == null && ValueEmbeddingWriter.this.resourceBundle != null) {
                        try {
                            value = ValueEmbeddingWriter.this.resourceBundle.getString(key.name);
                        }
                        catch (MissingResourceException mrex) {
                            value = key.name;
                        }
                    }
                    if (value instanceof Reader) {
                        this.embed(key, (Reader)value);
                        return true;
                    } else if (value != null) {
                        String string;
                        if (StringUtils.isNotBlank((CharSequence)key.format)) {
                            StringBuilder builder = new StringBuilder();
                            Formatter formatter = new Formatter(builder);
                            formatter.format(ValueEmbeddingWriter.this.locale, key.format, value);
                            string = builder.toString();
                        } else {
                            string = value.toString();
                        }
                        ValueEmbeddingWriter.this.pass(string);
                        return true;
                    } else {
                        if (!ValueEmbeddingWriter.this.keepUnresolvable) return true;
                        ValueEmbeddingWriter.this.pass("${" + key + "}");
                    }
                    return true;
                }
                default: {
                    if (this.keyBuffer != null) {
                        this.keyBuffer.append(token);
                        return false;
                    }
                    ValueEmbeddingWriter.this.pass("$" + token);
                    return true;
                }
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.keyBuffer == null) {
                ValueEmbeddingWriter.this.pass("$");
            } else {
                ValueEmbeddingWriter.this.pass("${" + this.keyBuffer);
            }
        }

        protected void embed(@NotNull ValueEmbeddingReader.Key key, @Nullable Reader reader) throws IOException {
            if (reader != null) {
                ValueEmbeddingWriter.this.wrappedWriter.flush();
                IOUtils.copy((Reader)new ValueEmbeddingReader(reader, (Map<String, Object>)ValueEmbeddingWriter.this.values, ValueEmbeddingWriter.this.locale, ValueEmbeddingWriter.this.resourceContext, ValueEmbeddingWriter.this.resourceBundle), (Writer)ValueEmbeddingWriter.this.wrappedWriter);
            } else if (ValueEmbeddingWriter.this.keepUnresolvable) {
                ValueEmbeddingWriter.this.pass("${" + key + "}");
            }
        }
    }

    protected class TextWriter
    implements TokenWriter {
        protected boolean escape = false;

        protected TextWriter() {
        }

        @Override
        public boolean write(char token) throws IOException {
            switch (token) {
                case '\\': {
                    if (this.escape) {
                        ValueEmbeddingWriter.this.pass(92);
                        this.escape = false;
                        break;
                    }
                    this.escape = true;
                    break;
                }
                case '$': {
                    if (this.escape) {
                        ValueEmbeddingWriter.this.pass(token);
                        this.escape = false;
                        break;
                    }
                    ValueEmbeddingWriter.this.writerStack.push(new ValueWriter());
                    break;
                }
                default: {
                    if (this.escape) {
                        ValueEmbeddingWriter.this.pass(92);
                        this.escape = false;
                    }
                    ValueEmbeddingWriter.this.pass(token);
                }
            }
            return false;
        }

        @Override
        public void flush() throws IOException {
            if (this.escape) {
                ValueEmbeddingWriter.this.pass(92);
            }
        }
    }

    static interface TokenWriter {
        public boolean write(char var1) throws IOException;

        public void flush() throws IOException;
    }
}

